/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.find.FindBundle;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineHandler;
import com.intellij.lang.refactoring.InlineHandlers;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GenericInlineHandler {
    private static final Logger LOG = Logger.getInstance(GenericInlineHandler.class);

    public static boolean invoke(PsiElement element2, @Nullable Editor editor, InlineHandler languageSpecific) {
        PsiReference invocationReference = editor != null ? TargetElementUtil.findReference(editor) : null;
        InlineHandler.Settings settings = languageSpecific.prepareInlineElement(element2, editor, invocationReference != null);
        if (settings == null || settings == InlineHandler.Settings.CANNOT_INLINE_SETTINGS) {
            return settings != null;
        }
        Project project = element2.getProject();
        Collection<Object> allReferences = settings.isOnlyOneReferenceToInline() ? Collections.singleton(invocationReference) : (Collection)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReferencesSearch.search((PsiElement)element2).findAll(), FindBundle.message("find.usages.progress.title", new Object[0]), true, project);
        MultiMap conflicts = new MultiMap();
        Map<Language, InlineHandler.Inliner> inliners = GenericInlineHandler.initializeInliners(element2, settings, allReferences);
        for (Object reference2 : allReferences) {
            GenericInlineHandler.collectConflicts((PsiReference)reference2, element2, inliners, (MultiMap<PsiElement, String>)conflicts);
        }
        if (!BaseRefactoringProcessor.processConflicts(project, (MultiMap<PsiElement, String>)conflicts)) {
            return true;
        }
        HashSet<PsiElement> elements2 = new HashSet<PsiElement>();
        for (PsiReference psiReference : allReferences) {
            elements2.add(psiReference.getElement());
        }
        if (!settings.isOnlyOneReferenceToInline()) {
            elements2.add(element2);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, elements2, (boolean)true)) {
            return true;
        }
        String subj = element2 instanceof PsiNamedElement ? ((PsiNamedElement)element2).getName() : "element";
        String string = RefactoringBundle.message((String)"inline.command", (Object[])new Object[]{StringUtil.notNullize((String)subj, (String)"<nameless>")});
        WriteCommandAction.runWriteCommandAction((Project)project, (String)string, null, () -> {
            PsiReference[] references = GenericInlineHandler.sortDepthFirstRightLeftOrder(allReferences);
            UsageInfo[] usages = new UsageInfo[references.length];
            for (int i2 = 0; i2 < references.length; ++i2) {
                usages[i2] = new UsageInfo(references[i2]);
            }
            Consumer<ProgressIndicator> perform2 = indicator -> {
                for (int i2 = 0; i2 < usages.length; ++i2) {
                    indicator.setFraction((double)i2 / (double)usages.length);
                    GenericInlineHandler.inlineReference(usages[i2], element2, inliners);
                }
                if (!settings.isOnlyOneReferenceToInline()) {
                    languageSpecific.removeDefinition(element2, settings);
                }
            };
            if (Registry.is((String)"run.refactorings.under.progress")) {
                ((ApplicationImpl)ApplicationManager.getApplication()).runWriteActionWithNonCancellableProgressInDispatchThread(commandName2, project, null, perform2);
            } else {
                perform2.accept((ProgressIndicator)new EmptyProgressIndicator());
            }
        }, (PsiFile[])new PsiFile[0]);
        return true;
    }

    public static Map<Language, InlineHandler.Inliner> initializeInliners(PsiElement element2, InlineHandler.Settings settings, Collection<? extends PsiReference> allReferences) {
        HashMap<Language, InlineHandler.Inliner> inliners = new HashMap<Language, InlineHandler.Inliner>();
        block0: for (PsiReference psiReference : allReferences) {
            if (psiReference == null) {
                LOG.error("element: " + element2.getClass() + ", allReferences contains null!");
                continue;
            }
            PsiElement refElement = psiReference.getElement();
            Language language = refElement.getLanguage();
            if (inliners.containsKey(language)) continue;
            List handlers = InlineHandlers.getInlineHandlers((Language)language);
            for (InlineHandler handler2 : handlers) {
                InlineHandler.Inliner inliner = handler2.createInliner(element2, settings);
                if (inliner == null) continue;
                inliners.put(language, inliner);
                continue block0;
            }
        }
        return inliners;
    }

    public static Map<Language, InlineHandler.Inliner> initInliners(PsiElement elementToInline, UsageInfo[] usagesIn, InlineHandler.Settings settings, MultiMap<PsiElement, String> conflicts, Language ... emptyInliners) {
        ArrayList<PsiReference> refs = new ArrayList<PsiReference>();
        for (UsageInfo info : usagesIn) {
            PsiReference[] references;
            PsiElement element2;
            if (info instanceof NonCodeUsageInfo || (element2 = info.getElement()) == null || (references = element2.getReferences()).length <= 0) continue;
            refs.add(references[0]);
        }
        Map<Language, InlineHandler.Inliner> inliners = GenericInlineHandler.initializeInliners(elementToInline, settings, refs);
        for (Language language : emptyInliners) {
            inliners.put(language, new InlineHandler.Inliner(){

                @Nullable
                public MultiMap<PsiElement, String> getConflicts(@NotNull PsiReference reference2, @NotNull PsiElement referenced) {
                    if (reference2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (referenced == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return null;
                }

                public void inlineUsage(@NotNull UsageInfo usage, @NotNull PsiElement referenced) {
                    if (usage == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (referenced == null) {
                        1.$$$reportNull$$$0(3);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "reference";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "referenced";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "usage";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/refactoring/inline/GenericInlineHandler$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getConflicts";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "inlineUsage";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        for (PsiReference ref : refs) {
            GenericInlineHandler.collectConflicts(ref, elementToInline, inliners, conflicts);
        }
        return inliners;
    }

    public static void collectConflicts(PsiReference reference2, PsiElement element2, Map<Language, InlineHandler.Inliner> inliners, MultiMap<PsiElement, String> conflicts) {
        PsiElement referenceElement = reference2.getElement();
        Language language = referenceElement.getLanguage();
        InlineHandler.Inliner inliner = inliners.get(language);
        if (inliner != null) {
            MultiMap refConflicts = inliner.getConflicts(reference2, element2);
            if (refConflicts != null) {
                for (PsiElement psiElement : refConflicts.keySet()) {
                    conflicts.putValues((Object)psiElement, refConflicts.get((Object)psiElement));
                }
            }
        } else {
            conflicts.putValue((Object)referenceElement, (Object)("Cannot inline reference from " + language.getDisplayName()));
        }
    }

    public static void inlineReference(UsageInfo usage, PsiElement element2, Map<Language, InlineHandler.Inliner> inliners) {
        PsiElement usageElement = usage.getElement();
        if (usageElement == null) {
            return;
        }
        Language language = usageElement.getLanguage();
        InlineHandler.Inliner inliner = inliners.get(language);
        if (inliner != null) {
            inliner.inlineUsage(usage, element2);
        }
    }

    public static PsiReference[] sortDepthFirstRightLeftOrder(Collection<? extends PsiReference> allReferences) {
        PsiReference[] usages = allReferences.toArray(PsiReference.EMPTY_ARRAY);
        Arrays.sort(usages, (usage1, usage2) -> {
            PsiElement element1 = usage1.getElement();
            PsiElement element2 = usage2.getElement();
            return element2.getTextRange().getStartOffset() - element1.getTextRange().getStartOffset();
        });
        return usages;
    }
}

