/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.AppTopics;
import com.intellij.ide.IdeEventQueue;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.event.EditorEventMulticasterImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.BooleanRunnable;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.FileContentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiDocumentManagerImpl
extends PsiDocumentManagerBase {
    private final boolean myUnitTestMode;

    public PsiDocumentManagerImpl(@NotNull Project project) {
        if (project == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(0);
        }
        super(project);
        this.myUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)this, (Disposable)this);
        ((EditorEventMulticasterImpl)EditorFactory.getInstance().getEventMulticaster()).addPrioritizedDocumentListener(new PsiDocumentManagerBase.PriorityEventCollector(), this);
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerListener(){

            public void fileContentLoaded(@NotNull VirtualFile virtualFile, @NotNull Document document) {
                if (virtualFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (document == null) {
                    1.$$$reportNull$$$0(1);
                }
                PsiFile psiFile = (PsiFile)ReadAction.compute(() -> PsiDocumentManagerImpl.this.myProject.isDisposed() || !virtualFile.isValid() ? null : PsiDocumentManagerImpl.this.getCachedPsiFile(virtualFile));
                PsiDocumentManagerImpl.this.fireDocumentCreated(document, psiFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "virtualFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "document";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/psi/impl/PsiDocumentManagerImpl$1";
                objectArray[2] = "fileContentLoaded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    @Nullable
    public PsiFile getPsiFile(@NotNull Document document) {
        Collection projects;
        VirtualFile virtualFile;
        if (document == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(1);
        }
        PsiFile psiFile = super.getPsiFile(document);
        if (this.myUnitTestMode && (virtualFile = FileDocumentManager.getInstance().getFile(document)) != null && virtualFile.isValid() && !(projects = ProjectLocator.getInstance().getProjectsForFile(virtualFile)).isEmpty() && !projects.contains(this.myProject)) {
            LOG.error("Trying to get PSI for an alien project. VirtualFile=" + virtualFile + ";\n myProject=" + this.myProject + ";\n projects returned: " + projects);
        }
        return psiFile;
    }

    @Override
    public void documentChanged(@NotNull DocumentEvent event) {
        if (event == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(2);
        }
        super.documentChanged(event);
        if (this.isUncommited(event.getDocument()) && FileDocumentManagerImpl.areTooManyDocumentsInTheQueue(this.myUncommittedDocuments)) {
            if (this.myUnitTestMode) {
                this.myStopTrackingDocuments = true;
                try {
                    LOG.error("Too many uncommitted documents for " + this.myProject + "(" + this.myUncommittedDocuments.size() + "):\n" + StringUtil.join((Iterable)this.myUncommittedDocuments, (String)"\n") + (String)(this.myProject instanceof ProjectEx ? "\n\n Project creation trace: " + ((ProjectEx)this.myProject).getCreationTrace() : ""));
                }
                finally {
                    this.clearUncommittedDocuments();
                }
            }
            if (PomModelImpl.isAllowPsiModification() && ApplicationManager.getApplication().isWriteAccessAllowed()) {
                for (Document document : this.myUncommittedDocuments) {
                    if (document == event.getDocument()) continue;
                    this.doCommitWithoutReparse(document);
                    break;
                }
            }
        }
    }

    @Override
    protected void beforeDocumentChangeOnUnlockedDocument(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(3);
        }
        PostprocessReformattingAspect.getInstance(this.myProject).assertDocumentChangeIsAllowed(viewProvider);
        super.beforeDocumentChangeOnUnlockedDocument(viewProvider);
    }

    @Override
    protected boolean finishCommitInWriteAction(@NotNull Document document, @NotNull List<? extends BooleanRunnable> finishProcessors, @NotNull List<? extends BooleanRunnable> reparseInjectedProcessors, boolean synchronously, boolean forceNoPsiCommit) {
        if (document == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(4);
        }
        if (finishProcessors == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(5);
        }
        if (reparseInjectedProcessors == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(6);
        }
        boolean success = super.finishCommitInWriteAction(document, finishProcessors, reparseInjectedProcessors, synchronously, forceNoPsiCommit);
        PsiFile file2 = this.getCachedPsiFile(document);
        if (file2 != null) {
            InjectedLanguageManagerImpl.clearInvalidInjections(file2);
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            InjectedLanguageManagerImpl.disposeInvalidEditors();
        }
        return success;
    }

    @Override
    public boolean isDocumentBlockedByPsi(@NotNull Document doc) {
        FileViewProvider viewProvider;
        if (doc == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(7);
        }
        return (viewProvider = this.getCachedViewProvider(doc)) != null && PostprocessReformattingAspect.getInstance(this.myProject).isViewProviderLocked(viewProvider);
    }

    @Override
    public void doPostponedOperationsAndUnblockDocument(@NotNull Document doc) {
        if (doc == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(8);
        }
        if (doc instanceof DocumentWindow) {
            doc = ((DocumentWindow)doc).getDelegate();
        }
        PostprocessReformattingAspect component2 = PostprocessReformattingAspect.getInstance(this.myProject);
        FileViewProvider viewProvider = this.getCachedViewProvider(doc);
        if (viewProvider != null && component2 != null) {
            component2.doPostponedFormatting(viewProvider);
        }
    }

    @Override
    @NotNull
    List<BooleanRunnable> reparseChangedInjectedFragments(@NotNull Document hostDocument, @NotNull PsiFile hostPsiFile, @NotNull TextRange hostChangedRange, @NotNull ProgressIndicator indicator, @NotNull ASTNode oldRoot, @NotNull ASTNode newRoot) {
        List changedInjected;
        if (hostDocument == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(9);
        }
        if (hostPsiFile == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(10);
        }
        if (hostChangedRange == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(11);
        }
        if (indicator == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(12);
        }
        if (oldRoot == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(13);
        }
        if (newRoot == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(14);
        }
        if ((changedInjected = InjectedLanguageManager.getInstance((Project)this.myProject).getCachedInjectedDocumentsInRange(hostPsiFile, hostChangedRange)).isEmpty()) {
            List<BooleanRunnable> list2 = Collections.emptyList();
            if (list2 == null) {
                PsiDocumentManagerImpl.$$$reportNull$$$0(15);
            }
            return list2;
        }
        FileViewProvider hostViewProvider = hostPsiFile.getViewProvider();
        ArrayList<DocumentWindow> fromLast = new ArrayList<DocumentWindow>(changedInjected);
        fromLast.sort(Collections.reverseOrder(Comparator.comparingInt(doc -> ((Segment)ArrayUtil.getLastElement((Object[])doc.getHostRanges())).getEndOffset())));
        ArrayList<BooleanRunnable> result2 = new ArrayList<BooleanRunnable>(changedInjected.size());
        for (DocumentWindow document : fromLast) {
            PsiFile injectedPsiFile;
            Segment[] ranges = document.getHostRanges();
            if (ranges.length == 0 || (injectedPsiFile = this.getCachedPsiFile((Document)document)) == null || !injectedPsiFile.isValid()) continue;
            BooleanRunnable runnable2 = InjectedLanguageUtil.reparse(injectedPsiFile, document, hostPsiFile, hostDocument, hostViewProvider, indicator, oldRoot, newRoot, this);
            ContainerUtil.addIfNotNull(result2, (Object)runnable2);
        }
        ArrayList<BooleanRunnable> arrayList = result2;
        if (arrayList == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NonNls
    public String toString() {
        return super.toString() + " for the project " + this.myProject + ".";
    }

    @Override
    public void reparseFiles(@NotNull Collection<? extends VirtualFile> files2, boolean includeOpenFiles) {
        if (files2 == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(17);
        }
        FileContentUtil.reparseFiles((Project)this.myProject, files2, (boolean)includeOpenFiles);
    }

    @Override
    @NotNull
    protected DocumentWindow freezeWindow(@NotNull DocumentWindow document) {
        if (document == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(18);
        }
        DocumentWindow documentWindow = InjectedLanguageManager.getInstance((Project)this.myProject).freezeWindow(document);
        if (documentWindow == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(19);
        }
        return documentWindow;
    }

    @Override
    public void associatePsi(@NotNull Document document, @Nullable PsiFile file2) {
        if (document == null) {
            PsiDocumentManagerImpl.$$$reportNull$$$0(20);
        }
        if (file2 != null) {
            VirtualFile vFile = file2.getViewProvider().getVirtualFile();
            Document cachedDocument = FileDocumentManager.getInstance().getCachedDocument(vFile);
            if (cachedDocument != null && cachedDocument != document) {
                throw new IllegalStateException("Can't replace existing document");
            }
            FileDocumentManagerImpl.registerDocument(document, vFile);
        }
    }

    @Override
    public boolean commitAllDocumentsUnderProgress() {
        int eventCount = IdeEventQueue.getInstance().getEventCount();
        boolean success = super.commitAllDocumentsUnderProgress();
        IdeEventQueue.getInstance().setEventCount(eventCount);
        return success;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finishProcessors";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reparseInjectedProcessors";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostDocument";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostPsiFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostChangedRange";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRoot";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRoot";
                break;
            }
            case 15: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PsiDocumentManagerImpl";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PsiDocumentManagerImpl";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "reparseChangedInjectedFragments";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "freezeWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "beforeDocumentChangeOnUnlockedDocument";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "finishCommitInWriteAction";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDocumentBlockedByPsi";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doPostponedOperationsAndUnblockDocument";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "reparseChangedInjectedFragments";
                break;
            }
            case 15: 
            case 16: 
            case 19: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "reparseFiles";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "freezeWindow";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "associatePsi";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 16: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

