/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.DependencyVisitorFactory;
import com.intellij.packageDependencies.ForwardDependenciesBuilder;
import com.intellij.packageDependencies.actions.DependenciesHandlerBase;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AnalyzeDependenciesOnSpecifiedTargetHandler
extends DependenciesHandlerBase {
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"Dependencies", (String)"Dependency Viewer");
    private final GlobalSearchScope myTargetScope;

    public AnalyzeDependenciesOnSpecifiedTargetHandler(@NotNull Project project, @NotNull AnalysisScope scope, @NotNull GlobalSearchScope targetScope) {
        if (project == null) {
            AnalyzeDependenciesOnSpecifiedTargetHandler.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            AnalyzeDependenciesOnSpecifiedTargetHandler.$$$reportNull$$$0(1);
        }
        if (targetScope == null) {
            AnalyzeDependenciesOnSpecifiedTargetHandler.$$$reportNull$$$0(2);
        }
        super(project, Collections.singletonList(scope), new HashSet<PsiFile>());
        this.myTargetScope = targetScope;
    }

    @Override
    protected String getProgressTitle() {
        return CodeInsightBundle.message((String)"package.dependencies.progress.title", (Object[])new Object[0]);
    }

    @Override
    protected String getPanelDisplayName(AnalysisScope scope) {
        return CodeInsightBundle.message((String)"package.dependencies.on.toolwindow.title", (Object[])new Object[]{scope.getDisplayName(), this.myTargetScope.getDisplayName()});
    }

    @Override
    protected boolean shouldShowDependenciesPanel(List<? extends DependenciesBuilder> builders) {
        for (DependenciesBuilder dependenciesBuilder : builders) {
            for (Set<PsiFile> files2 : dependenciesBuilder.getDependencies().values()) {
                if (files2.isEmpty()) continue;
                return true;
            }
        }
        String source = StringUtil.decapitalize((String)this.getPanelDisplayName(builders));
        String string = StringUtil.decapitalize((String)this.myTargetScope.getDisplayName());
        Object message = CodeInsightBundle.message((String)"no.dependencies.found.message", (Object[])new Object[]{source, string});
        if (DependencyVisitorFactory.VisitorOptions.fromSettings(this.myProject).skipImports()) {
            message = (String)message + " ";
            message = (String)message + CodeInsightBundle.message((String)"dependencies.in.imports.message", (Object[])new Object[0]);
        }
        NOTIFICATION_GROUP.createNotification((String)message, MessageType.INFO).notify(this.myProject);
        return false;
    }

    @Override
    protected DependenciesBuilder createDependenciesBuilder(AnalysisScope scope) {
        return new ForwardDependenciesBuilder(this.myProject, scope, this.myTargetScope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "scope";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "targetScope";
                break;
            }
        }
        objectArray[1] = "com/intellij/packageDependencies/actions/AnalyzeDependenciesOnSpecifiedTargetHandler";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

