/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class VfsDependentEnum<T> {
    @NonNls
    private static final String DEPENDENT_PERSISTENT_LIST_START_PREFIX = "vfs_enum_";
    private final File myFile;
    private final DataExternalizer<T> myKeyDescriptor;
    private final int myVersion;
    private boolean myMarkedForInvalidation;
    private final List<T> myInstances;
    private final Map<T, Integer> myInstanceToId;
    private final Object myLock;
    private boolean myTriedToLoadFile;

    public VfsDependentEnum(@NotNull String fileName, @NotNull KeyDescriptor<T> descriptor2, int version2) {
        if (fileName == null) {
            VfsDependentEnum.$$$reportNull$$$0(0);
        }
        if (descriptor2 == null) {
            VfsDependentEnum.$$$reportNull$$$0(1);
        }
        this.myInstances = ContainerUtil.createConcurrentList();
        this.myInstanceToId = new ConcurrentHashMap<T, Integer>();
        this.myLock = new Object();
        this.myFile = new File(FSRecords.basePath(), DEPENDENT_PERSISTENT_LIST_START_PREFIX + fileName + FSRecords.VFS_FILES_EXTENSION);
        this.myKeyDescriptor = descriptor2;
        this.myVersion = version2;
    }

    @NotNull
    static File getBaseFile() {
        return new File(FSRecords.basePath(), DEPENDENT_PERSISTENT_LIST_START_PREFIX);
    }

    public int getId(@NotNull T s) throws IOException {
        if (s == null) {
            VfsDependentEnum.$$$reportNull$$$0(2);
        }
        return this.getIdRaw(s, true);
    }

    int getIdRaw(@NotNull T s, boolean vfsRebuildOnException) throws IOException {
        Integer integer;
        if (s == null) {
            VfsDependentEnum.$$$reportNull$$$0(3);
        }
        if ((integer = this.myInstanceToId.get(s)) != null) {
            return integer;
        }
        Object object = this.myLock;
        synchronized (object) {
            integer = this.myInstanceToId.get(s);
            if (integer != null) {
                return integer;
            }
            try {
                boolean loaded = this.loadFromFile();
                if (loaded && (integer = this.myInstanceToId.get(s)) != null) {
                    return integer;
                }
                int enumerated = this.myInstances.size() + 1;
                this.register(s, enumerated);
                this.saveToFile(s);
                return enumerated;
            }
            catch (IOException e) {
                this.invalidate(e, vfsRebuildOnException);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile(@NotNull T instance) throws IOException {
        if (instance == null) {
            VfsDependentEnum.$$$reportNull$$$0(4);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this.myFile, true);
        try (DataOutputStream output = new DataOutputStream(new BufferedOutputStream(fileOutputStream));){
            if (this.myFile.length() == 0L) {
                DataInputOutputUtil.writeTIME((DataOutput)output, (long)FSRecords.getCreationTimestamp());
                DataInputOutputUtil.writeINT((DataOutput)output, (int)this.myVersion);
            }
            this.myKeyDescriptor.save((DataOutput)output, instance);
        }
        finally {
            try {
                fileOutputStream.getFD().sync();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean loadFromFile() throws IOException {
        if (this.myTriedToLoadFile || !this.myInstances.isEmpty() || !this.myFile.exists()) return false;
        this.myTriedToLoadFile = true;
        boolean deleteFile2 = false;
        try {
            DataInputStream input = new DataInputStream(new BufferedInputStream(new FileInputStream(this.myFile)));
            long vfsVersion = DataInputOutputUtil.readTIME((DataInput)input);
            if (vfsVersion != FSRecords.getCreationTimestamp()) {
                deleteFile2 = true;
                boolean bl = false;
                return bl;
            }
            int savedVersion = DataInputOutputUtilRt.readINT((DataInput)input);
            if (savedVersion != this.myVersion) throw new IOException("Version mismatch: current " + this.myVersion + ", previous:" + savedVersion + ", file:" + this.myFile);
            ArrayList<Object> elements2 = new ArrayList<Object>();
            HashMap<Object, Integer> elementToIdMap = new HashMap<Object, Integer>();
            while (input.available() > 0) {
                Object instance = this.myKeyDescriptor.read((DataInput)input);
                assert (instance != null);
                elements2.add(instance);
                elementToIdMap.put(instance, elements2.size());
            }
            this.myInstances.addAll(elements2);
            this.myInstanceToId.putAll(elementToIdMap);
            boolean bl = true;
            return bl;
            finally {
                input.close();
            }
        }
        finally {
            if (deleteFile2) {
                FileUtil.deleteWithRenaming((File)this.myFile);
            }
        }
    }

    private void invalidate(@NotNull Throwable e, boolean vfsRebuildOnException) {
        if (e == null) {
            VfsDependentEnum.$$$reportNull$$$0(5);
        }
        if (!this.myMarkedForInvalidation) {
            this.myMarkedForInvalidation = true;
            FileUtil.deleteWithRenaming((File)this.myFile);
            if (vfsRebuildOnException) {
                FSRecords.requestVfsRebuild(e);
            }
        }
    }

    private void register(@NotNull T instance, int id2) {
        if (instance == null) {
            VfsDependentEnum.$$$reportNull$$$0(6);
        }
        this.myInstanceToId.put(instance, id2);
        assert (id2 == this.myInstances.size() + 1);
        this.myInstances.add(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public T getById(int id2) throws IOException {
        boolean loaded;
        block10: {
            T instance;
            assert (id2 > 0);
            if (--id2 < this.myInstances.size() && (instance = this.myInstances.get(id2)) != null) {
                T t = instance;
                if (t != null) return t;
                VfsDependentEnum.$$$reportNull$$$0(7);
                return t;
            }
            Object object = this.myLock;
            // MONITORENTER : object
            if (id2 < this.myInstances.size() && (instance = this.myInstances.get(id2)) != null) {
                T t = instance;
                // MONITOREXIT : object
                if (t != null) return t;
                VfsDependentEnum.$$$reportNull$$$0(8);
                return t;
            }
            loaded = this.loadFromFile();
            if (!loaded || (instance = this.myInstances.get(id2)) == null) break block10;
            T t = instance;
            // MONITOREXIT : object
            if (t != null) return t;
            VfsDependentEnum.$$$reportNull$$$0(9);
            return t;
        }
        try {
            assert (false) : "Reading nonexistent value:" + id2 + "," + this.myFile + ", loaded:" + loaded;
        }
        catch (IOException | AssertionError e) {
            this.invalidate((Throwable)e, true);
            throw e;
        }
        VfsDependentEnum.$$$reportNull$$$0(10);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/VfsDependentEnum";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/VfsDependentEnum";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getById";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getId";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIdRaw";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveToFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invalidate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

