/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.local.FileWatcherNotificationSink;
import com.intellij.openapi.vfs.local.PluggableFileWatcher;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import com.sun.jna.Platform;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class NativeFileWatcherImpl
extends PluggableFileWatcher {
    private static final Logger LOG = Logger.getInstance(NativeFileWatcherImpl.class);
    private static final String PROPERTY_WATCHER_DISABLED = "idea.filewatcher.disabled";
    private static final String PROPERTY_WATCHER_EXECUTABLE_PATH = "idea.filewatcher.executable.path";
    private static final String ROOTS_COMMAND = "ROOTS";
    private static final String EXIT_COMMAND = "EXIT";
    private static final int MAX_PROCESS_LAUNCH_ATTEMPT_COUNT = 10;
    private FileWatcherNotificationSink myNotificationSink;
    private File myExecutable;
    private volatile MyProcessHandler myProcessHandler;
    private final AtomicInteger myStartAttemptCount = new AtomicInteger(0);
    private volatile boolean myIsShuttingDown;
    private final AtomicInteger mySettingRoots = new AtomicInteger(0);
    private volatile List<String> myRecursiveWatchRoots = Collections.emptyList();
    private volatile List<String> myFlatWatchRoots = Collections.emptyList();
    private volatile List<String> myIgnoredRoots = Collections.emptyList();
    private final String[] myLastChangedPaths = new String[2];
    private int myLastChangedPathIndex;
    private static final Charset CHARSET = SystemInfo.isWindows || SystemInfo.isMac ? StandardCharsets.UTF_8 : CharsetToolkit.getPlatformCharset();
    private static final BaseOutputReader.Options READER_OPTIONS = new BaseOutputReader.Options(){

        public BaseDataReader.SleepingPolicy policy() {
            return BaseDataReader.SleepingPolicy.BLOCKING;
        }

        public boolean sendIncompleteLines() {
            return false;
        }

        public boolean withSeparators() {
            return false;
        }
    };

    public void initialize(@NotNull ManagingFS managingFS, @NotNull FileWatcherNotificationSink notificationSink) {
        if (managingFS == null) {
            NativeFileWatcherImpl.$$$reportNull$$$0(0);
        }
        if (notificationSink == null) {
            NativeFileWatcherImpl.$$$reportNull$$$0(1);
        }
        this.myNotificationSink = notificationSink;
        boolean disabled = this.isDisabled();
        this.myExecutable = this.getExecutable();
        if (disabled) {
            LOG.info("Native file watcher is disabled");
        } else if (this.myExecutable == null) {
            if (SystemInfo.isWindows || SystemInfo.isMac || SystemInfo.isLinux && ArrayUtil.contains((String)Platform.RESOURCE_PREFIX, (String[])new String[]{"linux-x86", "linux-x86-64"})) {
                this.notifyOnFailure(ApplicationBundle.message((String)"watcher.exe.not.found", (Object[])new Object[0]), null);
            } else if (SystemInfo.isLinux) {
                this.notifyOnFailure(ApplicationBundle.message((String)"watcher.exe.compile", (Object[])new Object[0]), NotificationListener.URL_OPENING_LISTENER);
            } else {
                this.notifyOnFailure(ApplicationBundle.message((String)"watcher.exe.not.exists", (Object[])new Object[0]), null);
            }
        } else if (!this.myExecutable.canExecute()) {
            String message = ApplicationBundle.message((String)"watcher.exe.not.exe", (Object[])new Object[]{this.myExecutable});
            this.notifyOnFailure(message, (notification2, event) -> RevealFileAction.openFile(this.myExecutable));
        } else {
            try {
                this.startupProcess(false);
                LOG.info("Native file watcher is operational.");
            }
            catch (IOException e) {
                LOG.warn(e.getMessage());
                this.notifyOnFailure(ApplicationBundle.message((String)"watcher.failed.to.start", (Object[])new Object[0]), null);
            }
        }
    }

    public void dispose() {
        this.myIsShuttingDown = true;
        this.shutdownProcess();
    }

    public boolean isOperational() {
        return this.myProcessHandler != null;
    }

    public boolean isSettingRoots() {
        return this.isOperational() && this.mySettingRoots.get() > 0;
    }

    public void setWatchRoots(@NotNull List<String> recursive, @NotNull List<String> flat) {
        if (recursive == null) {
            NativeFileWatcherImpl.$$$reportNull$$$0(2);
        }
        if (flat == null) {
            NativeFileWatcherImpl.$$$reportNull$$$0(3);
        }
        this.setWatchRoots(recursive, flat, false);
    }

    protected boolean isDisabled() {
        if (Boolean.getBoolean(PROPERTY_WATCHER_DISABLED)) {
            return true;
        }
        Application app = ApplicationManager.getApplication();
        return app.isCommandLine() || app.isUnitTestMode();
    }

    @Nullable
    protected File getExecutable() {
        return NativeFileWatcherImpl.getFSNotifierExecutable();
    }

    @Nullable
    public static File getFSNotifierExecutable() {
        String customPath = System.getProperty(PROPERTY_WATCHER_EXECUTABLE_PATH);
        if (customPath != null) {
            Path customFile = PathManager.findBinFile((String)customPath);
            return customFile != null ? customFile.toFile() : new File(customPath);
        }
        String[] names2 = ArrayUtil.EMPTY_STRING_ARRAY;
        if (SystemInfo.isWindows) {
            if ("win32-x86".equals(Platform.RESOURCE_PREFIX)) {
                names2 = new String[]{"fsnotifier.exe"};
            } else if ("win32-x86-64".equals(Platform.RESOURCE_PREFIX)) {
                names2 = new String[]{"fsnotifier64.exe", "fsnotifier.exe"};
            }
        } else if (SystemInfo.isMac) {
            names2 = new String[]{"fsnotifier"};
        } else if (SystemInfo.isLinux) {
            if ("linux-x86".equals(Platform.RESOURCE_PREFIX)) {
                names2 = new String[]{"fsnotifier"};
            } else if ("linux-x86-64".equals(Platform.RESOURCE_PREFIX)) {
                names2 = new String[]{"fsnotifier64"};
            }
        }
        for (String name : names2) {
            Path file2 = PathManager.findBinFile((String)name);
            if (file2 == null) continue;
            return file2.toFile();
        }
        return null;
    }

    private void notifyOnFailure(@NlsContexts.NotificationContent String cause, @Nullable NotificationListener listener2) {
        this.myNotificationSink.notifyUserOnFailure(cause, listener2);
    }

    private void startupProcess(boolean restart) throws IOException {
        if (this.myIsShuttingDown) {
            return;
        }
        if (ShutDownTracker.isShutdownHookRunning()) {
            this.myIsShuttingDown = true;
            return;
        }
        if (this.myStartAttemptCount.incrementAndGet() > 10) {
            this.notifyOnFailure(ApplicationBundle.message((String)"watcher.bailed.out.10x", (Object[])new Object[0]), null);
            return;
        }
        if (restart) {
            this.shutdownProcess();
        }
        LOG.info("Starting file watcher: " + this.myExecutable);
        Process process2 = new ProcessBuilder(this.myExecutable.getAbsolutePath()).start();
        this.myProcessHandler = new MyProcessHandler(process2, this.myExecutable.getName());
        this.myProcessHandler.startNotify();
        if (restart) {
            List<String> recursive = this.myRecursiveWatchRoots;
            List<String> flat = this.myFlatWatchRoots;
            if (recursive.size() + flat.size() > 0) {
                this.setWatchRoots(recursive, flat, true);
            }
        }
    }

    private void shutdownProcess() {
        MyProcessHandler processHandler2 = this.myProcessHandler;
        if (processHandler2 != null) {
            if (!processHandler2.isProcessTerminated()) {
                try {
                    this.writeLine(EXIT_COMMAND);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!processHandler2.waitFor(10L)) {
                    Runnable r = () -> {
                        if (!processHandler2.waitFor(500L)) {
                            LOG.warn("File watcher is still alive, doing a force quit.");
                            processHandler2.destroyProcess();
                        }
                    };
                    if (this.myIsShuttingDown) {
                        new Thread(r, "fsnotifier shutdown").start();
                    } else {
                        ApplicationManager.getApplication().executeOnPooledThread(r);
                    }
                }
            }
            this.myProcessHandler = null;
        }
    }

    private void setWatchRoots(List<String> recursive, List<String> flat, boolean restart) {
        if (this.myProcessHandler == null || this.myProcessHandler.isProcessTerminated()) {
            return;
        }
        if (ApplicationManager.getApplication().isDisposed()) {
            flat = Collections.emptyList();
            recursive = flat;
        }
        if (!restart && this.myRecursiveWatchRoots.equals(recursive) && this.myFlatWatchRoots.equals(flat)) {
            this.myNotificationSink.notifyManualWatchRoots((PluggableFileWatcher)this, this.myIgnoredRoots);
            return;
        }
        this.mySettingRoots.incrementAndGet();
        this.myRecursiveWatchRoots = recursive;
        this.myFlatWatchRoots = flat;
        SmartList ignored = new SmartList();
        if (SystemInfo.isWindows) {
            recursive = NativeFileWatcherImpl.screenUncRoots(recursive, (List<String>)ignored);
            flat = NativeFileWatcherImpl.screenUncRoots(flat, (List<String>)ignored);
        }
        this.myIgnoredRoots = new CopyOnWriteArrayList<String>((Collection<String>)ignored);
        this.myNotificationSink.notifyManualWatchRoots((PluggableFileWatcher)this, (Collection)ignored);
        try {
            this.writeLine(ROOTS_COMMAND);
            for (String path : recursive) {
                this.writeLine(path);
            }
            for (String path : flat) {
                this.writeLine("|" + path);
            }
            this.writeLine("#");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private static List<String> screenUncRoots(List<String> roots, List<String> ignored) {
        List<String> filtered2 = null;
        for (int i2 = 0; i2 < roots.size(); ++i2) {
            String root = roots.get(i2);
            if (OSAgnosticPathUtil.isUncPath((String)root)) {
                if (filtered2 == null) {
                    filtered2 = new ArrayList<String>(roots.subList(0, i2));
                }
                ignored.add(root);
                continue;
            }
            if (filtered2 == null) continue;
            filtered2.add(root);
        }
        return filtered2 != null ? filtered2 : roots;
    }

    private void writeLine(String line) throws IOException {
        MyProcessHandler processHandler2;
        if (LOG.isTraceEnabled()) {
            LOG.trace("<< " + line);
        }
        if ((processHandler2 = this.myProcessHandler) != null) {
            processHandler2.writeLine(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetChangedPaths() {
        String[] stringArray = this.myLastChangedPaths;
        synchronized (this.myLastChangedPaths) {
            this.myLastChangedPathIndex = 0;
            Arrays.fill(this.myLastChangedPaths, null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRepetition(String path) {
        String[] stringArray = this.myLastChangedPaths;
        synchronized (this.myLastChangedPaths) {
            for (int i2 = 0; i2 < this.myLastChangedPaths.length; ++i2) {
                String lastChangedPath;
                int last = this.myLastChangedPathIndex - i2 - 1;
                if (last < 0) {
                    last += this.myLastChangedPaths.length;
                }
                if ((lastChangedPath = this.myLastChangedPaths[last]) == null || !lastChangedPath.equals(path)) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            this.myLastChangedPaths[this.myLastChangedPathIndex++] = path;
            if (this.myLastChangedPathIndex == this.myLastChangedPaths.length) {
                this.myLastChangedPathIndex = 0;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    @TestOnly
    public void startup() throws IOException {
        Application app = ApplicationManager.getApplication();
        if (app == null || !app.isUnitTestMode()) {
            throw new IllegalStateException();
        }
        this.myIsShuttingDown = false;
        this.myStartAttemptCount.set(0);
        this.startupProcess(false);
    }

    @TestOnly
    public void shutdown() throws InterruptedException {
        Application app = ApplicationManager.getApplication();
        if (app == null || !app.isUnitTestMode()) {
            throw new IllegalStateException();
        }
        MyProcessHandler processHandler2 = this.myProcessHandler;
        if (processHandler2 != null) {
            this.myIsShuttingDown = true;
            this.shutdownProcess();
            long t = System.currentTimeMillis();
            while (!processHandler2.isProcessTerminated()) {
                if (System.currentTimeMillis() - t > 15000L) {
                    throw new InterruptedException("Timed out waiting watcher process to terminate");
                }
                TimeoutUtil.sleep((long)100L);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "managingFS";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationSink";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recursive";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flat";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/impl/local/NativeFileWatcherImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "initialize";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setWatchRoots";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MyProcessHandler
    extends OSProcessHandler {
        private final BufferedWriter myWriter;
        private WatcherOp myLastOp;
        private final List<String> myLines;

        MyProcessHandler(Process process2, String commandLine) {
            super(process2, commandLine, CHARSET);
            this.myLines = new ArrayList<String>();
            this.myWriter = new BufferedWriter(new OutputStreamWriter(process2.getOutputStream(), CHARSET));
        }

        void writeLine(String line) throws IOException {
            this.myWriter.write(line);
            this.myWriter.newLine();
            this.myWriter.flush();
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options2 = READER_OPTIONS;
            if (options2 == null) {
                MyProcessHandler.$$$reportNull$$$0(0);
            }
            return options2;
        }

        protected void notifyProcessTerminated(int exitCode) {
            super.notifyProcessTerminated(exitCode);
            String message = "Watcher terminated with exit code " + exitCode;
            if (NativeFileWatcherImpl.this.myIsShuttingDown) {
                LOG.info(message);
            } else {
                LOG.warn(message);
            }
            NativeFileWatcherImpl.this.myProcessHandler = null;
            try {
                NativeFileWatcherImpl.this.startupProcess(true);
            }
            catch (IOException e) {
                NativeFileWatcherImpl.this.shutdownProcess();
                LOG.warn("Watcher terminated and attempt to restart has failed. Exiting watching thread.", (Throwable)e);
            }
        }

        public void notifyTextAvailable(@NotNull String line, @NotNull Key outputType) {
            if (line == null) {
                MyProcessHandler.$$$reportNull$$$0(1);
            }
            if (outputType == null) {
                MyProcessHandler.$$$reportNull$$$0(2);
            }
            if (outputType == ProcessOutputTypes.STDERR) {
                LOG.warn(line);
            }
            if (outputType != ProcessOutputTypes.STDOUT) {
                return;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace(">> " + line);
            }
            if (this.myLastOp == null) {
                WatcherOp watcherOp;
                try {
                    watcherOp = WatcherOp.valueOf(line);
                }
                catch (IllegalArgumentException e) {
                    String message = "Illegal watcher command: '" + line + "'";
                    if (line.length() <= 20) {
                        message = message + " " + Arrays.toString(line.chars().toArray());
                    }
                    LOG.error(message);
                    return;
                }
                if (watcherOp == WatcherOp.GIVEUP) {
                    NativeFileWatcherImpl.this.notifyOnFailure(ApplicationBundle.message((String)"watcher.gave.up", (Object[])new Object[0]), null);
                    NativeFileWatcherImpl.this.myIsShuttingDown = true;
                } else if (watcherOp == WatcherOp.RESET) {
                    NativeFileWatcherImpl.this.myNotificationSink.notifyReset(null);
                } else {
                    this.myLastOp = watcherOp;
                }
            } else if (this.myLastOp == WatcherOp.MESSAGE) {
                String localized = Objects.requireNonNullElse(ApplicationBundle.INSTANCE.messageOrNull(line, new Object[0]), line);
                LOG.warn(localized);
                NativeFileWatcherImpl.this.notifyOnFailure(localized, NotificationListener.URL_OPENING_LISTENER);
                this.myLastOp = null;
            } else if (this.myLastOp == WatcherOp.REMAP || this.myLastOp == WatcherOp.UNWATCHEABLE) {
                if ("#".equals(line)) {
                    if (this.myLastOp == WatcherOp.REMAP) {
                        this.processRemap();
                    } else {
                        NativeFileWatcherImpl.this.mySettingRoots.decrementAndGet();
                        this.processUnwatchable();
                    }
                    this.myLines.clear();
                    this.myLastOp = null;
                } else {
                    this.myLines.add(line);
                }
            } else {
                String path = StringUtil.trimEnd((String)line.replace('\u0000', '\n'), (String)File.separator);
                this.processChange(path, this.myLastOp);
                this.myLastOp = null;
            }
        }

        private void processRemap() {
            HashSet<Pair> pairs = new HashSet<Pair>();
            for (int i2 = 0; i2 < this.myLines.size() - 1; i2 += 2) {
                pairs.add(Pair.create((Object)this.myLines.get(i2), (Object)this.myLines.get(i2 + 1)));
            }
            NativeFileWatcherImpl.this.myNotificationSink.notifyMapping(pairs);
        }

        private void processUnwatchable() {
            NativeFileWatcherImpl.this.myIgnoredRoots.addAll(this.myLines);
            NativeFileWatcherImpl.this.myNotificationSink.notifyManualWatchRoots((PluggableFileWatcher)NativeFileWatcherImpl.this, this.myLines);
        }

        private void processChange(String path, WatcherOp op) {
            if (SystemInfo.isWindows && op == WatcherOp.RECDIRTY) {
                NativeFileWatcherImpl.this.myNotificationSink.notifyReset(path);
                return;
            }
            if ((op == WatcherOp.CHANGE || op == WatcherOp.STATS) && NativeFileWatcherImpl.this.isRepetition(path)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("repetition: " + path);
                }
                return;
            }
            if (SystemInfo.isMac) {
                path = Normalizer.normalize(path, Normalizer.Form.NFC);
            }
            switch (op) {
                case STATS: 
                case CHANGE: {
                    NativeFileWatcherImpl.this.myNotificationSink.notifyDirtyPath(path);
                    break;
                }
                case CREATE: 
                case DELETE: {
                    NativeFileWatcherImpl.this.myNotificationSink.notifyPathCreatedOrDeleted(path);
                    break;
                }
                case DIRTY: {
                    NativeFileWatcherImpl.this.myNotificationSink.notifyDirtyDirectory(path);
                    break;
                }
                case RECDIRTY: {
                    NativeFileWatcherImpl.this.myNotificationSink.notifyDirtyPathRecursive(path);
                    break;
                }
                default: {
                    LOG.error("Unexpected op: " + op);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/impl/local/NativeFileWatcherImpl$MyProcessHandler";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readerOptions";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/impl/local/NativeFileWatcherImpl$MyProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyTextAvailable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum WatcherOp {
        GIVEUP,
        RESET,
        UNWATCHEABLE,
        REMAP,
        MESSAGE,
        CREATE,
        DELETE,
        STATS,
        CHANGE,
        DIRTY,
        RECDIRTY;

    }
}

