/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.DependentSdkType;
import com.intellij.openapi.projectRoots.impl.UnknownSdkCollector;
import com.intellij.openapi.projectRoots.impl.UnknownSdkContributor;
import com.intellij.openapi.projectRoots.impl.UnknownSdkSnapshot;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstaller;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkListDownloader;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkUpdateCheckContributor;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkUpdaterKt;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkUpdaterNotifications;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkUpdaterState;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkUpdatesCollector;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkUpdatesCollectorQueue;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.UnknownSdk;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\u0006H\u0002J\u0006\u0010\n\u001a\u00020\u0006J\b\u0010\u000b\u001a\u00020\u0006H\u0002J\u001e\u0010\f\u001a\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkUpdatesCollector;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "dispose", "", "isEnabled", "", "schedule", "updateNotifications", "updateNotificationsDebounced", "updateWithSnapshot", "knownSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.platform.lang.impl"})
public final class JdkUpdatesCollector
implements Disposable {
    private final Project project;

    public void dispose() {
    }

    private final boolean isEnabled() {
        return JdkUpdaterKt.access$isEnabled(this.project);
    }

    private final void schedule() {
        if (!this.isEnabled()) {
            return;
        }
        ScheduledFuture<?> future2 = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(new Runnable(this){
            final /* synthetic */ JdkUpdatesCollector this$0;

            public final void run() {
                if (JdkUpdatesCollector.access$getProject$p(this.this$0).isDisposed()) {
                    return;
                }
                try {
                    this.this$0.updateNotifications();
                }
                catch (Throwable t) {
                    if (t instanceof ControlFlowException) {
                        return;
                    }
                    JdkUpdaterKt.access$getLOG$p().warn("Failed to complete JDK Update check. " + t.getMessage(), t);
                }
            }
            {
                this.this$0 = jdkUpdatesCollector;
            }
        }, 12L, 12L, TimeUnit.HOURS);
        Disposer.register((Disposable)this, (Disposable)new Disposable(future2){
            final /* synthetic */ ScheduledFuture $future;

            public final void dispose() {
                this.$future.cancel(false);
            }
            {
                this.$future = scheduledFuture;
            }
        });
        AtomicLong myLastKnownModificationId = new AtomicLong(-100500L);
        this.project.getMessageBus().connect((Disposable)this).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(this, myLastKnownModificationId){
            final /* synthetic */ JdkUpdatesCollector this$0;
            final /* synthetic */ AtomicLong $myLastKnownModificationId;

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.isCausedByFileTypesChange()) {
                    return;
                }
                ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)JdkUpdatesCollector.access$getProject$p(this.this$0));
                Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
                long newCounterValue = projectRootManager.getModificationCount();
                if (this.$myLastKnownModificationId.getAndSet(newCounterValue) == newCounterValue) {
                    return;
                }
                this.this$0.updateNotifications();
            }
            {
                this.this$0 = this$0;
                this.$myLastKnownModificationId = $captured_local_variable$1;
            }
        });
    }

    public final void updateNotifications() {
        if (!this.isEnabled()) {
            return;
        }
        Project $this$service$iv = this.project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(JdkUpdatesCollectorQueue.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        ((JdkUpdatesCollectorQueue)object).queue(new Runnable(this){
            final /* synthetic */ JdkUpdatesCollector this$0;

            public final void run() {
                JdkUpdatesCollector.access$updateNotificationsDebounced(this.this$0);
            }
            {
                this.this$0 = jdkUpdatesCollector;
            }
        });
    }

    private final void updateNotificationsDebounced() {
        if (!this.isEnabled()) {
            return;
        }
        new UnknownSdkCollector(this, this.project){
            final /* synthetic */ JdkUpdatesCollector this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            protected List<UnknownSdkContributor> getContributors() {
                Collection<updateNotificationsDebounced.getContributors.1.1> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Collection collection2 = super.getContributors();
                List list2 = JdkUpdaterKt.access$getEP_NAME$p().getExtensionList();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"EP_NAME.extensionList");
                Iterable iterable = list2;
                Collection collection3 = collection2;
                boolean $i$f$map = false;
                void var3_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JdkUpdateCheckContributor jdkUpdateCheckContributor = (JdkUpdateCheckContributor)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    UnknownSdkContributor unknownSdkContributor = new UnknownSdkContributor((JdkUpdateCheckContributor)it){
                        final /* synthetic */ JdkUpdateCheckContributor $it;

                        @NotNull
                        public List<UnknownSdk> contributeUnknownSdks(@NotNull Project project) {
                            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                            boolean bl = false;
                            return CollectionsKt.emptyList();
                        }

                        @NotNull
                        public List<Sdk> contributeKnownSdks(@NotNull Project project) {
                            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                            return this.$it.contributeJdks(project);
                        }
                        {
                            this.$it = $captured_local_variable$0;
                        }
                    };
                    collection.add(unknownSdkContributor);
                }
                collection = (List)destination$iv$iv;
                return CollectionsKt.plus((Collection)collection3, (Iterable)collection);
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        }.collectSdksPromise(new Consumer<UnknownSdkSnapshot>(this){
            final /* synthetic */ JdkUpdatesCollector this$0;

            /*
             * WARNING - void declaration
             */
            public final void accept(@NotNull UnknownSdkSnapshot snapshot) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
                Iterable $this$filter$iv = snapshot.getKnownSdks();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    Sdk it = (Sdk)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getSdkType() instanceof JavaSdkType && !(it.getSdkType() instanceof DependentSdkType))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List knownSdks = (List)destination$iv$iv;
                if (knownSdks.isEmpty()) {
                    return;
                }
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, knownSdks, JdkUpdatesCollector.access$getProject$p(this.this$0), ProjectBundle.message((String)"progress.title.checking.for.jdk.updates", (Object[])new Object[0]), true, Task.Backgroundable.ALWAYS_BACKGROUND){
                    final /* synthetic */ updateNotificationsDebounced.2 this$0;
                    final /* synthetic */ List $knownSdks;

                    public void run(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        Iterable $this$sortedBy$iv = CollectionsKt.distinct((Iterable)this.$knownSdks);
                        boolean $i$f$sortedBy = false;
                        boolean bl = false;
                        JdkUpdatesCollector.access$updateWithSnapshot(this.this$0.this$0, CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                            public final int compare(T a, T b) {
                                boolean bl = false;
                                Sdk it = (Sdk)a;
                                boolean bl2 = false;
                                Comparable comparable = (Comparable)((Object)it.getName());
                                it = (Sdk)b;
                                Comparable comparable2 = comparable;
                                bl2 = false;
                                String string = it.getName();
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                            }
                        }), indicator);
                    }
                    {
                        this.this$0 = this$0;
                        this.$knownSdks = $captured_local_variable$1;
                        super($super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5);
                    }
                });
            }
            {
                this.this$0 = jdkUpdatesCollector;
            }
        });
    }

    private final void updateWithSnapshot(List<? extends Sdk> knownSdks, ProgressIndicator indicator) {
        Object var4_3 = null;
        Lazy jdkFeed2 = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends JdkItem>>(indicator){
            final /* synthetic */ ProgressIndicator $indicator;

            @NotNull
            public final List<JdkItem> invoke() {
                return JdkListDownloader.Companion.getInstance().downloadModelForJdkInstaller(this.$indicator);
            }
            {
                this.$indicator = progressIndicator;
                super(0);
            }
        }));
        boolean $i$f$service = false;
        Object object = ApplicationManager.getApplication().getService(JdkUpdaterNotifications.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
        JdkUpdaterNotifications notifications = (JdkUpdaterNotifications)object;
        List<Sdk> jdksToTest = notifications.filterNotPendingSdks(knownSdks);
        HashSet noUpdatesFor = new HashSet(jdksToTest);
        for (Sdk jdk : jdksToTest) {
            JdkItem feedItem;
            Object v1;
            JdkItem actualItem;
            block5: {
                if (JdkInstaller.Companion.getInstance().findJdkItemForInstalledJdk(jdk.getHomePath()) == null) {
                    continue;
                }
                Lazy lazy = jdkFeed2;
                Object var13_17 = null;
                boolean bl = false;
                Iterable $this$firstOrNull$iv = (Iterable)lazy.getValue();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    JdkItem it = (JdkItem)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getSuggestedSdkName(), (Object)actualItem.getSuggestedSdkName()) && Intrinsics.areEqual((Object)it.getArch(), (Object)actualItem.getArch()))) continue;
                    v1 = element$iv;
                    break block5;
                }
                v1 = null;
            }
            if ((JdkItem)v1 == null) {
                continue;
            }
            boolean $i$f$service2 = false;
            Object object2 = ApplicationManager.getApplication().getService(JdkUpdaterState.class);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
            if (!((JdkUpdaterState)((Object)object2)).isAllowed(jdk, feedItem) || VersionComparatorUtil.compare((String)feedItem.getJdkVersion(), (String)actualItem.getJdkVersion()) <= 0) continue;
            notifications.showNotification(jdk, actualItem, feedItem);
            Collection collection = noUpdatesFor;
            boolean bl = false;
            collection.remove(jdk);
        }
        Iterator<Object> iterator2 = noUpdatesFor.iterator();
        while (iterator2.hasNext()) {
            Sdk jdk;
            Sdk sdk2 = jdk = (Sdk)iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)sdk2, (String)"jdk");
            notifications.hideNotification(sdk2);
        }
    }

    public JdkUpdatesCollector(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.schedule();
    }

    public static final /* synthetic */ Project access$getProject$p(JdkUpdatesCollector $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$updateNotificationsDebounced(JdkUpdatesCollector $this) {
        $this.updateNotificationsDebounced();
    }

    public static final /* synthetic */ void access$updateWithSnapshot(JdkUpdatesCollector $this, List knownSdks, ProgressIndicator indicator) {
        $this.updateWithSnapshot(knownSdks, indicator);
    }
}

