/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.projectRoots.impl.UnknownMissingSdk;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFix;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFixAction;
import com.intellij.openapi.roots.ui.configuration.SdkPopupFactory;
import com.intellij.openapi.roots.ui.configuration.UnknownSdk;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UnknownMissingSdkFix
implements UnknownSdkFix {
    private static final Logger LOG = Logger.getInstance(UnknownMissingSdkFix.class);
    @Nullable
    private final Project myProject;
    @NotNull
    private final UnknownSdk mySdk;
    @Nullable
    private final UnknownSdkFixAction myAction;

    UnknownMissingSdkFix(@Nullable Project project, @NotNull UnknownSdk unknownSdk2, @Nullable UnknownSdkFixAction action2) {
        if (unknownSdk2 == null) {
            UnknownMissingSdkFix.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.mySdk = unknownSdk2;
        this.myAction = action2;
    }

    @NotNull
    String getSdkNameForUi() {
        String string = UnknownMissingSdk.getSdkNameForUi(this.mySdk);
        if (string == null) {
            UnknownMissingSdkFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isRelevantFor(@NotNull Project project) {
        if (project == null) {
            UnknownMissingSdkFix.$$$reportNull$$$0(2);
        }
        return this.myProject == null || project == this.myProject;
    }

    @Override
    public boolean isRelevantFor(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            UnknownMissingSdkFix.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            UnknownMissingSdkFix.$$$reportNull$$$0(4);
        }
        return this.isRelevantFor(project) && this.mySdk.getSdkType().isRelevantForFile(project, file2);
    }

    @NotNull
    private SdkType getSdkType() {
        SdkType sdkType = this.mySdk.getSdkType();
        if (sdkType == null) {
            UnknownMissingSdkFix.$$$reportNull$$$0(5);
        }
        return sdkType;
    }

    @Override
    @Nullable
    public UnknownSdkFixAction getSuggestedFixAction() {
        return this.myAction;
    }

    @Override
    @Nls
    @NotNull
    public String getIntentionActionText() {
        String sdkTypeName = this.mySdk.getSdkType().getPresentableName();
        String string = ProjectBundle.message((String)"config.unknown.sdk.configure.missing", (Object[])new Object[]{sdkTypeName, this.getSdkNameForUi()});
        if (string == null) {
            UnknownMissingSdkFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public EditorNotificationPanel.ActionHandler getConfigureActionHandler(@NotNull Project project) {
        if (project == null) {
            UnknownMissingSdkFix.$$$reportNull$$$0(7);
        }
        EditorNotificationPanel.ActionHandler actionHandler = SdkPopupFactory.newBuilder().withProject(this.myProject).withSdkTypeFilter((Condition<SdkTypeId>)((Condition)type -> Objects.equals(type, this.mySdk.getSdkType()))).onSdkSelected(sdk2 -> UnknownMissingSdkFix.registerNewSdkInJdkTable(this.mySdk.getSdkName(), sdk2)).buildEditorNotificationPanelHandler();
        if (actionHandler == null) {
            UnknownMissingSdkFix.$$$reportNull$$$0(8);
        }
        return actionHandler;
    }

    @Override
    @Nls
    @NotNull
    public String getNotificationText() {
        String sdkTypeName = this.getSdkType().getPresentableName();
        String string = ProjectBundle.message((String)"notification.text.config.unknown.sdk", (Object[])new Object[]{sdkTypeName, this.getSdkNameForUi()});
        if (string == null) {
            UnknownMissingSdkFix.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getSdkTypeAndNameText() {
        String sdkTypeName = this.getSdkType().getPresentableName();
        String string = ProjectBundle.message((String)"dialog.text.resolving.sdks.item", (Object[])new Object[]{sdkTypeName, this.getSdkNameForUi()});
        if (string == null) {
            UnknownMissingSdkFix.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getConfigureActionText() {
        String string = ProjectBundle.message((String)"action.text.config.unknown.sdk.configure", (Object[])new Object[0]);
        if (string == null) {
            UnknownMissingSdkFix.$$$reportNull$$$0(11);
        }
        return string;
    }

    public String toString() {
        return "SdkFixInfo {" + this.mySdk + ", " + this.myAction + "}";
    }

    @NotNull
    static Sdk createNewSdk(@NotNull UnknownSdk unknownSdk2, @NotNull @NotNull Supplier<@NotNull String> suggestedSdkName) {
        String actualSdkName;
        if (unknownSdk2 == null) {
            UnknownMissingSdkFix.$$$reportNull$$$0(12);
        }
        if (suggestedSdkName == null) {
            UnknownMissingSdkFix.$$$reportNull$$$0(13);
        }
        if ((actualSdkName = unknownSdk2.getSdkName()) == null) {
            actualSdkName = suggestedSdkName.get();
        }
        ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
        actualSdkName = SdkConfigurationUtil.createUniqueSdkName(actualSdkName, List.of(jdkTable.getAllJdks()));
        Sdk sdk2 = jdkTable.createSdk(actualSdkName, (SdkTypeId)unknownSdk2.getSdkType());
        if (sdk2 == null) {
            UnknownMissingSdkFix.$$$reportNull$$$0(14);
        }
        return sdk2;
    }

    static void registerNewSdkInJdkTable(@Nullable String sdkName, @NotNull Sdk sdk2) {
        if (sdk2 == null) {
            UnknownMissingSdkFix.$$$reportNull$$$0(15);
        }
        WriteAction.run(() -> {
            ProjectJdkTable table = ProjectJdkTable.getInstance();
            if (sdkName != null) {
                Sdk clash = table.findJdk(sdkName);
                if (clash != null) {
                    LOG.warn("SDK with name " + sdkName + " already exists: clash=" + clash + ", new=" + sdk2);
                    return;
                }
                SdkModificator mod = sdk2.getSdkModificator();
                mod.setName(sdkName);
                mod.commitChanges();
            }
            table.addJdk(sdk2);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unknownSdk";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/UnknownMissingSdkFix";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedSdkName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/UnknownMissingSdkFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkNameForUi";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntentionActionText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigureActionHandler";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkTypeAndNameText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigureActionText";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewSdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isRelevantFor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getConfigureActionHandler";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createNewSdk";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerNewSdkInJdkTable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

