/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.actions;

import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.actions.FileChooserAction;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;

public final class GotoHomeAction
extends FileChooserAction
implements LightEditCompatible {
    @Override
    protected void actionPerformed(FileSystemTree fileSystemTree, AnActionEvent e) {
        VirtualFile userHomeDir = VfsUtil.getUserHomeDir();
        if (userHomeDir != null) {
            fileSystemTree.select(userHomeDir, () -> fileSystemTree.expand(userHomeDir, null));
        }
    }

    @Override
    protected void update(FileSystemTree fileSystemTree, AnActionEvent e) {
        Presentation presentation2 = e.getPresentation();
        if (!presentation2.isEnabled()) {
            return;
        }
        VirtualFile userHomeDir = VfsUtil.getUserHomeDir();
        presentation2.setEnabled(userHomeDir != null && fileSystemTree.isUnderRoots(userHomeDir));
    }
}

