/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkException;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkProvider;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import javax.swing.UIManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemJdkComboBox
extends ComboBoxWithWidePopup<JdkComboBoxItem> {
    private static final int MAX_PATH_LENGTH = 50;
    @Nullable
    private Project myProject;
    @Nullable
    private Sdk myProjectJdk;
    private boolean myHighlightInternalJdk = true;

    public ExternalSystemJdkComboBox() {
        this(null);
    }

    public ExternalSystemJdkComboBox(@Nullable Project project) {
        this.myProject = project;
        this.setRenderer((ListCellRenderer)new ColoredListCellRenderer<JdkComboBoxItem>(){

            protected void customizeCellRenderer(@NotNull JList list2, JdkComboBoxItem value2, int index, boolean selected2, boolean hasFocus) {
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value2 == null) {
                    return;
                }
                CompositeAppearance appearance = new CompositeAppearance();
                appearance.setIcon(AllIcons.Nodes.PpJdk);
                SimpleTextAttributes attributes = ExternalSystemJdkComboBox.getTextAttributes(value2.valid, selected2);
                CompositeAppearance.DequeEnd ending = appearance.getEnding();
                ending.addText(value2.label, attributes);
                if (value2.comment != null && !value2.comment.equals(value2.jdkName)) {
                    SimpleTextAttributes textAttributes = !value2.valid ? SimpleTextAttributes.ERROR_ATTRIBUTES : (SystemInfo.isMac && selected2 ? new SimpleTextAttributes(0, (Color)JBColor.WHITE) : SimpleTextAttributes.GRAY_ATTRIBUTES);
                    ending.addComment(value2.comment, textAttributes);
                }
                CompositeAppearance compositeAppearance = ending.getAppearance();
                compositeAppearance.customize((SimpleColoredComponent)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/externalSystem/service/ui/ExternalSystemJdkComboBox$1", "customizeCellRenderer"));
            }
        });
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public void setProject(@Nullable Project project) {
        this.myProject = project;
    }

    public void setProjectJdk(@Nullable Sdk projectJdk) {
        this.myProjectJdk = projectJdk;
    }

    public void setSetupButton(@NotNull JButton setUpButton, @NotNull ProjectSdksModel jdksModel, @Nullable String actionGroupTitle, @Nullable Condition<? super SdkTypeId> creationFilter) {
        if (setUpButton == null) {
            ExternalSystemJdkComboBox.$$$reportNull$$$0(0);
        }
        if (jdksModel == null) {
            ExternalSystemJdkComboBox.$$$reportNull$$$0(1);
        }
        this.setSetupButton(setUpButton, jdksModel, actionGroupTitle, creationFilter, null);
    }

    public void setSetupButton(@NotNull JButton setUpButton, final @NotNull ProjectSdksModel jdksModel, @Nullable String actionGroupTitle, @Nullable Condition<? super SdkTypeId> creationFilter, @Nullable WizardContext wizardContext) {
        if (setUpButton == null) {
            ExternalSystemJdkComboBox.$$$reportNull$$$0(2);
        }
        if (jdksModel == null) {
            ExternalSystemJdkComboBox.$$$reportNull$$$0(3);
        }
        Arrays.stream(setUpButton.getActionListeners()).forEach(setUpButton::removeActionListener);
        setUpButton.addActionListener(e -> {
            DefaultActionGroup group2 = new DefaultActionGroup();
            final Sdk selectedJdk = this.getSelectedJdk();
            final Consumer updateTree = jdk -> {
                String jdkName;
                Sdk existingJdk = Arrays.stream(ProjectJdkTable.getInstance().getAllJdks()).filter(sdk2 -> StringUtil.equals((CharSequence)sdk2.getHomePath(), (CharSequence)jdk.getHomePath())).findFirst().orElse(null);
                if (existingJdk == null) {
                    SdkConfigurationUtil.addSdk(jdk);
                    jdkName = jdk.getName();
                } else {
                    jdkName = existingJdk.getName();
                }
                this.refreshData(jdkName, wizardContext != null ? wizardContext.getProjectJdk() : null);
            };
            jdksModel.reset(this.getProject());
            jdksModel.createAddActions(group2, (JComponent)((Object)this), selectedJdk, (Consumer<? super Sdk>)updateTree, creationFilter);
            if (group2.getChildrenCount() == 0) {
                final SimpleJavaSdkType javaSdkType = SimpleJavaSdkType.getInstance();
                DumbAwareAction addAction = new DumbAwareAction(javaSdkType.getPresentableName(), null, javaSdkType.getIconForAddAction()){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        jdksModel.doAdd((JComponent)((Object)ExternalSystemJdkComboBox.this), selectedJdk, (SdkType)javaSdkType, (Consumer<? super Sdk>)updateTree);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/service/ui/ExternalSystemJdkComboBox$2", "actionPerformed"));
                    }
                };
                group2.add((AnAction)addAction);
            }
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)this));
            if (group2.getChildrenCount() > 1) {
                JBPopupFactory.getInstance().createActionGroupPopup(actionGroupTitle, (ActionGroup)group2, dataContext, JBPopupFactory.ActionSelectionAid.MNEMONICS, false).showUnderneathOf((Component)setUpButton);
            } else if (group2.getChildrenCount() == 1) {
                AnActionEvent event = new AnActionEvent(null, dataContext, "unknown", new Presentation(""), ActionManager.getInstance(), 0);
                group2.getChildren(event)[0].actionPerformed(event);
            }
        });
    }

    @Nullable
    public Sdk getSelectedJdk() {
        String jdkName = this.getSelectedValue();
        Sdk jdk = null;
        try {
            jdk = ExternalSystemJdkUtil.resolveJdkName(this.myProjectJdk, jdkName);
        }
        catch (ExternalSystemJdkException externalSystemJdkException) {
            // empty catch block
        }
        return jdk;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    @NotNull
    public ExternalSystemJdkComboBox withoutJre() {
        ExternalSystemJdkComboBox externalSystemJdkComboBox = this;
        if (externalSystemJdkComboBox == null) {
            ExternalSystemJdkComboBox.$$$reportNull$$$0(4);
        }
        return externalSystemJdkComboBox;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    public boolean isHighlightInternalJdk() {
        return this.myHighlightInternalJdk;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    public void setHighlightInternalJdk(boolean highlightInternalJdk) {
        this.myHighlightInternalJdk = highlightInternalJdk;
    }

    public void refreshData(@Nullable String selectedValue) {
        this.refreshData(selectedValue, null);
    }

    public void refreshData(@Nullable String selectedValue, @Nullable Sdk projectJdk) {
        this.myProjectJdk = projectJdk;
        Map<String, JdkComboBoxItem> jdkMap = this.collectComboBoxItem();
        if ("#JAVA_INTERNAL".equals(selectedValue)) {
            jdkMap.put(selectedValue, this.getInternalJdkItem());
        } else if (selectedValue != null && !jdkMap.containsKey(selectedValue)) {
            assert (selectedValue.length() > 0);
            jdkMap.put(selectedValue, new JdkComboBoxItem(selectedValue, selectedValue, "", false));
        }
        this.removeAllItems();
        ComboBoxModel comboBoxModel = this.getModel();
        for (Map.Entry<String, JdkComboBoxItem> entry : jdkMap.entrySet()) {
            ((MutableComboBoxModel)comboBoxModel).addElement(entry.getValue());
        }
        this.select(selectedValue);
    }

    @ApiStatus.Experimental
    public void select(@Nullable String selectedValue) {
        ComboBoxModel model2 = this.getModel();
        for (int i2 = 0; i2 < model2.getSize(); ++i2) {
            JdkComboBoxItem item = (JdkComboBoxItem)model2.getElementAt(i2);
            if (!item.jdkName.equals(selectedValue)) continue;
            model2.setSelectedItem(item);
            return;
        }
        if ("#JAVA_INTERNAL".equals(selectedValue)) {
            JdkComboBoxItem item = this.getInternalJdkItem();
            ((MutableComboBoxModel)model2).addElement(item);
        }
        if (model2.getSize() != 0) {
            model2.setSelectedItem(model2.getElementAt(0));
        }
    }

    private JdkComboBoxItem getInternalJdkItem() {
        ExternalSystemJdkProvider jdkProvider = ExternalSystemJdkProvider.getInstance();
        Sdk internalJdk = jdkProvider.getInternalJdk();
        return new JdkComboBoxItem("#JAVA_INTERNAL", ExternalSystemBundle.message((String)"external.system.java.internal.jre", (Object[])new Object[0]), ExternalSystemJdkComboBox.buildComment(internalJdk), !this.myHighlightInternalJdk);
    }

    @Nullable
    public String getSelectedValue() {
        DefaultComboBoxModel model2 = (DefaultComboBoxModel)this.getModel();
        Object item = model2.getSelectedItem();
        return item != null ? ((JdkComboBoxItem)item).jdkName : null;
    }

    private Map<String, JdkComboBoxItem> collectComboBoxItem() {
        String javaHomePath;
        LinkedHashMap<String, JdkComboBoxItem> result2 = new LinkedHashMap<String, JdkComboBoxItem>();
        for (Sdk sdk2 : ProjectJdkTable.getInstance().getAllJdks()) {
            SdkTypeId sdkType = sdk2.getSdkType();
            if (!(sdkType instanceof JavaSdkType) || !(sdkType instanceof SdkType) || !((SdkType)sdkType).sdkHasValidPath(sdk2)) continue;
            String name = sdk2.getName();
            String comment = ExternalSystemJdkComboBox.buildComment(sdk2);
            result2.put(name, new JdkComboBoxItem(name, name, comment, true));
        }
        if (this.myProjectJdk == null && this.myProject != null && !this.myProject.isDisposed()) {
            this.myProjectJdk = ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk();
        }
        if (this.myProjectJdk != null) {
            result2.put("#USE_PROJECT_JDK", new JdkComboBoxItem("#USE_PROJECT_JDK", "Use Project JDK", ExternalSystemJdkComboBox.buildComment(this.myProjectJdk), true));
        }
        if (ExternalSystemJdkUtil.isValidJdk(javaHomePath = ExternalSystemJdkUtil.getJavaHome())) {
            result2.put("#JAVA_HOME", new JdkComboBoxItem("#JAVA_HOME", ExternalSystemBundle.message((String)"external.system.java.home.env", (Object[])new Object[0]), ExternalSystemJdkComboBox.truncateLongPath(javaHomePath), true));
        }
        return result2;
    }

    private static String buildComment(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            ExternalSystemJdkComboBox.$$$reportNull$$$0(5);
        }
        String versionString = sdk2.getVersionString();
        String path = sdk2.getHomePath();
        StringBuilder buf = new StringBuilder();
        if (versionString != null) {
            buf.append(versionString);
        }
        if (path != null) {
            buf.append(versionString != null ? ", " : "");
            buf.append("path: ").append(ExternalSystemJdkComboBox.truncateLongPath(path));
        }
        return buf.toString();
    }

    @NotNull
    private static String truncateLongPath(@NotNull String path) {
        if (path == null) {
            ExternalSystemJdkComboBox.$$$reportNull$$$0(6);
        }
        if (path.length() > 50) {
            String string = path.substring(0, 25) + "..." + path.substring(path.length() - 25 - 3);
            if (string == null) {
                ExternalSystemJdkComboBox.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            ExternalSystemJdkComboBox.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static SimpleTextAttributes getTextAttributes(boolean valid, boolean selected2) {
        if (!valid) {
            return SimpleTextAttributes.ERROR_ATTRIBUTES;
        }
        if (!(!selected2 || SystemInfo.isWinVistaOrNewer && UIManager.getLookAndFeel().getName().contains("Windows"))) {
            return SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES;
        }
        return SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setUpButton";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdksModel";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/ui/ExternalSystemJdkComboBox";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/ui/ExternalSystemJdkComboBox";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutJre";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "truncateLongPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setSetupButton";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildComment";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "truncateLongPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class JdkComboBoxItem {
        private final String jdkName;
        private final String label;
        private final String comment;
        private final boolean valid;

        JdkComboBoxItem(String jdkName, String label2, String comment, boolean valid) {
            this.jdkName = jdkName;
            this.label = label2;
            this.comment = comment;
            this.valid = valid;
        }
    }
}

