/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.ProjectTopics;
import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.externalSystem.service.project.manage.SourceFolderManager;
import com.intellij.openapi.externalSystem.service.project.manage.SourceFolderManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.SourceFolderManagerState;
import com.intellij.openapi.externalSystem.service.project.manage.SourceFolderModelState;
import com.intellij.openapi.externalSystem.util.PathPrefixTreeMap;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Consumer;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@State(name="sourceFolderManager", storages={@Storage(value="$CACHE_FILE$")})
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 @2\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003:\u0003@ABB\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J$\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\f2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 H\u0016J\u0018\u0010!\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\fH\u0002J \u0010\"\u001a\u00020\u001b2\u0016\u0010#\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0004\u0012\u00020\u001b0$H\u0007J\b\u0010%\u001a\u00020\u001bH\u0016J\u0018\u0010&\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010'2\u0006\u0010(\u001a\u00020\fH\u0007J\n\u0010)\u001a\u0004\u0018\u00010\u0004H\u0016J\b\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\rH\u0002J\u0018\u0010,\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010-\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u0004H\u0016J\u0010\u0010/\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\fH\u0002J\u0010\u00100\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0006\u00101\u001a\u00020\u001bJ\b\u00102\u001a\u00020\u001bH\u0002J\u0018\u00103\u001a\u00020\u001b2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\tH\u0002J\u0018\u00107\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u00106\u001a\u00020\tH\u0016J\u001a\u00108\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\f2\b\u00109\u001a\u0004\u0018\u00010\fH\u0016J.\u0010:\u001a\u00020\u001b2$\u0010;\u001a \u0012\u0004\u0012\u00020\u001d\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020\u00150>0=0<H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00180\u0017j\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0018`\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/manage/SourceFolderManagerImpl;", "Lcom/intellij/openapi/externalSystem/service/project/manage/SourceFolderManager;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/openapi/externalSystem/service/project/manage/SourceFolderManagerState;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "isDisposed", "", "moduleNamesToSourceFolderState", "Lcom/intellij/util/containers/MultiMap;", "", "Lcom/intellij/openapi/externalSystem/service/project/manage/SourceFolderModelState;", "mutex", "", "operationsStates", "", "Ljava/util/concurrent/Future;", "sourceFolders", "Lcom/intellij/openapi/externalSystem/util/PathPrefixTreeMap;", "Lcom/intellij/openapi/externalSystem/service/project/manage/SourceFolderManagerImpl$SourceFolderModel;", "sourceFoldersByModule", "Ljava/util/HashMap;", "Lcom/intellij/openapi/externalSystem/service/project/manage/SourceFolderManagerImpl$ModuleModel;", "Lkotlin/collections/HashMap;", "addSourceFolder", "", "module", "Lcom/intellij/openapi/module/Module;", "url", "type", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "addUrlToModuleModel", "consumeBulkOperationsState", "stateConsumer", "Lkotlin/Function1;", "dispose", "getSourceFolders", "", "moduleName", "getState", "listenToModuleAdded", "model", "loadSourceFolderState", "loadState", "state", "removeSourceFolder", "removeSourceFolders", "rescanAndUpdateSourceFolders", "resetModuleAddedListeners", "setForGeneratedSources", "folder", "Lcom/intellij/openapi/roots/SourceFolder;", "generated", "setSourceFolderGenerated", "setSourceFolderPackagePrefix", "packagePrefix", "updateSourceFolders", "sourceFoldersToChange", "", "", "Lkotlin/Pair;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "ModuleModel", "SourceFolderModel", "intellij.platform.externalSystem.impl"})
public final class SourceFolderManagerImpl
implements SourceFolderManager,
Disposable,
PersistentStateComponent<SourceFolderManagerState> {
    private final MultiMap<String, SourceFolderModelState> moduleNamesToSourceFolderState;
    private boolean isDisposed;
    private final Object mutex;
    private PathPrefixTreeMap<SourceFolderModel> sourceFolders;
    private HashMap<String, ModuleModel> sourceFoldersByModule;
    private final List<Future<?>> operationsStates;
    private final Project project;
    @NotNull
    private static final Map<String, JpsModuleSourceRootType<?>> dictionary;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourceFolder(@NotNull Module module, @NotNull String url, @NotNull JpsModuleSourceRootType<?> type) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Object object = this.mutex;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.sourceFolders.set(url, new SourceFolderModel(module, url, type, null, false, 24, null));
            this.addUrlToModuleModel(module, url);
            Unit unit = Unit.INSTANCE;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(url){
            final /* synthetic */ String $url;

            public final void run() {
                VirtualFileManager.getInstance().refreshAndFindFileByUrl(this.$url);
            }
            {
                this.$url = string;
            }
        }, this.project.getDisposed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceFolderPackagePrefix(@NotNull String url, @Nullable String packagePrefix) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Object object = this.mutex;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            SourceFolderModel sourceFolderModel = this.sourceFolders.get((Object)url);
            if (sourceFolderModel == null) {
                return;
            }
            SourceFolderModel sourceFolder = sourceFolderModel;
            sourceFolder.setPackagePrefix(packagePrefix);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceFolderGenerated(@NotNull String url, boolean generated) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Object object = this.mutex;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            SourceFolderModel sourceFolderModel = this.sourceFolders.get((Object)url);
            if (sourceFolderModel == null) {
                return;
            }
            SourceFolderModel sourceFolder = sourceFolderModel;
            sourceFolder.setGenerated(generated);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSourceFolders(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Object object = this.mutex;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            ModuleModel moduleModel = this.sourceFoldersByModule.remove(module.getName());
            if (moduleModel == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)moduleModel, (String)"sourceFoldersByModule.re\u2026ve(module.name) ?: return");
            ModuleModel moduleModel2 = moduleModel;
            Iterable $this$forEach$iv = moduleModel2.getSourceFolders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl4 = false;
                this.sourceFolders.remove(it);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public void dispose() {
        boolean bl = !this.isDisposed;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Source folder manager already disposed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.isDisposed = true;
    }

    @TestOnly
    public final boolean isDisposed() {
        return this.isDisposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    @Nullable
    public final Set<String> getSourceFolders(@NotNull String moduleName) {
        Set<String> set2;
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Object object = this.mutex;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            ModuleModel moduleModel = this.sourceFoldersByModule.get(moduleName);
            set2 = moduleModel != null ? moduleModel.getSourceFolders() : null;
        }
        return set2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeSourceFolder(String url) {
        Object object = this.mutex;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            SourceFolderModel sourceFolderModel = this.sourceFolders.remove(url);
            if (sourceFolderModel == null) {
                return;
            }
            SourceFolderModel sourceFolder = sourceFolderModel;
            Module module = sourceFolder.getModule();
            ModuleModel moduleModel = this.sourceFoldersByModule.get(module.getName());
            if (moduleModel == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)moduleModel, (String)"sourceFoldersByModule[module.name] ?: return");
            ModuleModel moduleModel2 = moduleModel;
            Set<String> sourceFolders2 = moduleModel2.getSourceFolders();
            sourceFolders2.remove(url);
            if (sourceFolders2.isEmpty()) {
                this.sourceFoldersByModule.remove(module.getName());
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rescanAndUpdateSourceFolders() {
        List list2;
        HashMap sourceFoldersToChange = new HashMap();
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"VirtualFileManager.getInstance()");
        VirtualFileManager virtualFileManager2 = virtualFileManager;
        Object object = this.mutex;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            list2 = (List)this.sourceFolders.values();
        }
        List values = list2;
        for (SourceFolderModel sourceFolder : values) {
            VirtualFile sourceFolderFile = virtualFileManager2.refreshAndFindFileByUrl(sourceFolder.getUrl());
            if (sourceFolderFile == null || !sourceFolderFile.isValid()) continue;
            ((ArrayList)sourceFoldersToChange.computeIfAbsent(sourceFolder.getModule(), rescanAndUpdateSourceFolders.1.INSTANCE)).add(new Pair((Object)sourceFolderFile, (Object)sourceFolder));
            this.removeSourceFolder(sourceFolder.getUrl());
        }
        this.updateSourceFolders(sourceFoldersToChange);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateSourceFolders(Map<Module, ? extends List<? extends Pair<? extends VirtualFile, SourceFolderModel>>> sourceFoldersToChange) {
        Module module = sourceFoldersToChange;
        boolean bl = false;
        Iterator<Map.Entry<Module, ? extends List<? extends Pair<? extends VirtualFile, SourceFolderModel>>>> iterator2 = module.entrySet().iterator();
        while (iterator2.hasNext()) {
            void module2;
            Map.Entry<Module, ? extends List<? extends Pair<? extends VirtualFile, SourceFolderModel>>> entry;
            Map.Entry<Module, ? extends List<? extends Pair<? extends VirtualFile, SourceFolderModel>>> entry2 = entry = iterator2.next();
            boolean bl2 = false;
            module = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            List<? extends Pair<? extends VirtualFile, SourceFolderModel>> p = entry2.getValue();
            ModuleRootModificationUtil.updateModel((Module)module2, (Consumer)((Consumer)new Consumer<ModifiableRootModel>(this, p){
                final /* synthetic */ SourceFolderManagerImpl this$0;
                final /* synthetic */ List $p;

                /*
                 * WARNING - void declaration
                 */
                public final void consume(ModifiableRootModel model2) {
                    for (Pair pair : this.$p) {
                        SourceFolder sourceFolder;
                        void packagePrefix;
                        void type;
                        void url;
                        void eventFile;
                        SourceFolderModel sourceFolders2;
                        VirtualFile virtualFile = (VirtualFile)pair.component1();
                        SourceFolderModel sourceFolderModel = sourceFolders2 = (SourceFolderModel)pair.component2();
                        String string = sourceFolderModel.component2();
                        JpsModuleSourceRootType<?> jpsModuleSourceRootType = sourceFolderModel.component3();
                        String string2 = sourceFolderModel.component4();
                        boolean generated = sourceFolderModel.component5();
                        ContentEntry contentEntry = MarkRootActionBase.findContentEntry((ModuleRootModel)model2, (VirtualFile)eventFile);
                        if (contentEntry == null) {
                            contentEntry = model2.addContentEntry((String)url);
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)contentEntry, (String)"MarkRootActionBase.findC\u2026odel.addContentEntry(url)");
                        ContentEntry contentEntry2 = contentEntry;
                        Intrinsics.checkNotNullExpressionValue((Object)contentEntry2.addSourceFolder((String)url, (JpsModuleSourceRootType)type), (String)"contentEntry.addSourceFolder(url, type)");
                        if (packagePrefix != null) {
                            CharSequence charSequence = (CharSequence)packagePrefix;
                            boolean bl = false;
                            if (charSequence.length() > 0) {
                                sourceFolder.setPackagePrefix((String)packagePrefix);
                            }
                        }
                        SourceFolderManagerImpl.access$setForGeneratedSources(this.this$0, sourceFolder, generated);
                    }
                }
                {
                    this.this$0 = sourceFolderManagerImpl;
                    this.$p = list2;
                }
            }));
        }
    }

    private final void setForGeneratedSources(SourceFolder folder, boolean generated) {
        JpsModuleSourceRoot jpsModuleSourceRoot = folder.getJpsElement();
        Intrinsics.checkNotNullExpressionValue((Object)jpsModuleSourceRoot, (String)"folder.jpsElement");
        JpsModuleSourceRoot jpsElement = jpsModuleSourceRoot;
        JavaSourceRootProperties properties = (JavaSourceRootProperties)jpsElement.getProperties(JavaModuleSourceRootTypes.SOURCES);
        if (properties != null) {
            properties.setForGeneratedSources(generated);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SourceFolderManagerState getState() {
        Object object = this.mutex;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            SourceFolderManagerState sourceFolderManagerState = new SourceFolderManagerState(SequencesKt.toList((Sequence)SequencesKt.mapNotNull(this.sourceFolders.getValueSequence(), (Function1)getState.1.1.INSTANCE)));
            return sourceFolderManagerState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull SourceFolderManagerState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Object object = this.mutex;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.resetModuleAddedListeners();
            if (this.isDisposed) {
                return;
            }
            this.sourceFolders = new PathPrefixTreeMap(null, false, 3, null);
            this.sourceFoldersByModule = new HashMap();
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.project);
            Iterable $this$forEach$iv = state.getSourceFolders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SourceFolderModelState model2 = (SourceFolderModelState)element$iv;
                boolean bl4 = false;
                Module module = moduleManager.findModuleByName(model2.getModuleName());
                if (module == null) {
                    this.listenToModuleAdded(model2);
                    continue;
                }
                this.loadSourceFolderState(model2, module);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void resetModuleAddedListeners() {
        this.moduleNamesToSourceFolderState.clear();
    }

    private final void listenToModuleAdded(SourceFolderModelState model2) {
        this.moduleNamesToSourceFolderState.putValue((Object)model2.getModuleName(), (Object)model2);
    }

    private final void loadSourceFolderState(SourceFolderModelState model2, Module module) {
        JpsModuleSourceRootType<?> jpsModuleSourceRootType = dictionary.get(model2.getType());
        if (jpsModuleSourceRootType == null) {
            return;
        }
        JpsModuleSourceRootType<?> rootType = jpsModuleSourceRootType;
        String url = model2.getUrl();
        this.sourceFolders.set(url, new SourceFolderModel(module, url, rootType, model2.getPackagePrefix(), model2.getGenerated()));
        this.addUrlToModuleModel(module, url);
    }

    /*
     * WARNING - void declaration
     */
    private final void addUrlToModuleModel(Module module, String url) {
        Object object;
        void $this$getOrPut$iv;
        Map map2 = this.sourceFoldersByModule;
        String string = module.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"module.name");
        String key$iv = string;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            ModuleModel moduleModel = new ModuleModel(module, null, 2, null);
            boolean bl2 = false;
            boolean bl3 = false;
            ModuleModel it = moduleModel;
            boolean bl4 = false;
            Disposer.register((Disposable)((Disposable)module), (Disposable)new Disposable(this, module){
                final /* synthetic */ SourceFolderManagerImpl this$0;
                final /* synthetic */ Module $module$inlined;
                {
                    this.this$0 = sourceFolderManagerImpl;
                    this.$module$inlined = module;
                }

                public final void dispose() {
                    this.this$0.removeSourceFolders(this.$module$inlined);
                }
            });
            ModuleModel answer$iv = moduleModel;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ModuleModel moduleModel = (ModuleModel)object;
        moduleModel.getSourceFolders().add(url);
    }

    @TestOnly
    public final void consumeBulkOperationsState(@NotNull Function1<? super Future<?>, Unit> stateConsumer) throws Exception {
        Intrinsics.checkNotNullParameter(stateConsumer, (String)"stateConsumer");
        ApplicationManager.getApplication().assertIsDispatchThread();
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        boolean bl = application.isUnitTestMode();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        for (Future<?> operationsState : this.operationsStates) {
            stateConsumer.invoke(operationsState);
        }
    }

    public SourceFolderManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        MultiMap multiMap = MultiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"MultiMap.create()");
        this.moduleNamesToSourceFolderState = multiMap;
        this.mutex = new Object();
        this.sourceFolders = new PathPrefixTreeMap(null, false, 3, null);
        this.sourceFoldersByModule = new HashMap();
        boolean bl = false;
        this.operationsStates = new ArrayList();
        this.project.getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void after(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                HashMap sourceFoldersToChange = new HashMap();
                VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"VirtualFileManager.getInstance()");
                VirtualFileManager virtualFileManager2 = virtualFileManager;
                for (VFileEvent vFileEvent : events) {
                    Set bl2;
                    if (!(vFileEvent instanceof VFileCreateEvent)) continue;
                    Object object = mutex;
                    boolean bl = false;
                    boolean bl3 = false;
                    synchronized (object) {
                        boolean bl32 = false;
                        PathPrefixTreeMap pathPrefixTreeMap = sourceFolders;
                        String string = VfsUtilCore.pathToUrl((String)((VFileCreateEvent)vFileEvent).getPath());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VfsUtilCore.pathToUrl(event.path)");
                        bl2 = pathPrefixTreeMap.getAllDescendantValues(string);
                    }
                    Set allDescendantValues = bl2;
                    for (SourceFolderModel sourceFolder : allDescendantValues) {
                        VirtualFile sourceFolderFile = virtualFileManager2.refreshAndFindFileByUrl(sourceFolder.getUrl());
                        if (sourceFolderFile == null || !sourceFolderFile.isValid()) continue;
                        ArrayList arrayList = (ArrayList)sourceFoldersToChange.computeIfAbsent(sourceFolder.getModule(), after.1.INSTANCE);
                        VirtualFile virtualFile = ((VFileCreateEvent)vFileEvent).getFile();
                        Intrinsics.checkNotNull((Object)virtualFile);
                        arrayList.add(new Pair((Object)virtualFile, (Object)sourceFolder));
                        this.removeSourceFolder(sourceFolder.getUrl());
                    }
                }
                Application application = ApplicationManager.getApplication();
                Future future2 = application.executeOnPooledThread(new Runnable(this, sourceFoldersToChange){
                    final /* synthetic */ 1 this$0;
                    final /* synthetic */ HashMap $sourceFoldersToChange;

                    public final void run() {
                        SourceFolderManagerImpl.access$updateSourceFolders(this.this$0.this, this.$sourceFoldersToChange);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$sourceFoldersToChange = hashMap;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)future2, (String)"application.executeOnPoo\u2026(sourceFoldersToChange) }");
                Future future3 = future2;
                Application application2 = application;
                Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"application");
                if (application2.isUnitTestMode()) {
                    ApplicationManager.getApplication().assertIsDispatchThread();
                    operationsStates.removeIf(after.2.INSTANCE);
                    operationsStates.add(future3);
                }
            }
        });
        this.project.getMessageBus().connect().subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void moduleAdded(@NotNull Project project, @NotNull Module module) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                Object object = mutex;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (object) {
                    boolean bl3 = false;
                    Collection collection = moduleNamesToSourceFolderState.get((Object)module.getName());
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"moduleNamesToSourceFolderState[module.name]");
                    Iterable $this$forEach$iv = collection;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        SourceFolderModelState it = (SourceFolderModelState)element$iv;
                        boolean bl4 = false;
                        SourceFolderModelState sourceFolderModelState = it;
                        Intrinsics.checkNotNullExpressionValue((Object)sourceFolderModelState, (String)"it");
                        this.loadSourceFolderState(sourceFolderModelState, module);
                    }
                    Collection collection2 = moduleNamesToSourceFolderState.remove((Object)module.getName());
                }
            }
        });
    }

    static {
        Companion = new Companion(null);
        dictionary = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"SOURCE", (Object)JavaSourceRootType.SOURCE), TuplesKt.to((Object)"TEST_SOURCE", (Object)JavaSourceRootType.TEST_SOURCE), TuplesKt.to((Object)"RESOURCE", (Object)JavaResourceRootType.RESOURCE), TuplesKt.to((Object)"TEST_RESOURCE", (Object)JavaResourceRootType.TEST_RESOURCE)});
    }

    public static final /* synthetic */ void access$setForGeneratedSources(SourceFolderManagerImpl $this, SourceFolder folder, boolean generated) {
        $this.setForGeneratedSources(folder, generated);
    }

    public static final /* synthetic */ void access$setSourceFolders$p(SourceFolderManagerImpl $this, PathPrefixTreeMap pathPrefixTreeMap) {
        $this.sourceFolders = pathPrefixTreeMap;
    }

    public static final /* synthetic */ void access$updateSourceFolders(SourceFolderManagerImpl $this, Map sourceFoldersToChange) {
        $this.updateSourceFolders(sourceFoldersToChange);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\r\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u0007H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\nH\u00c6\u0003JA\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\f\b\u0002\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\n2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\u0005H\u00d6\u0001R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0015\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013\u00a8\u0006$"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/manage/SourceFolderManagerImpl$SourceFolderModel;", "", "module", "Lcom/intellij/openapi/module/Module;", "url", "", "type", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "packagePrefix", "generated", "", "(Lcom/intellij/openapi/module/Module;Ljava/lang/String;Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;Ljava/lang/String;Z)V", "getGenerated", "()Z", "setGenerated", "(Z)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "getPackagePrefix", "()Ljava/lang/String;", "setPackagePrefix", "(Ljava/lang/String;)V", "getType", "()Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "getUrl", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "intellij.platform.externalSystem.impl"})
    private static final class SourceFolderModel {
        @NotNull
        private final Module module;
        @NotNull
        private final String url;
        @NotNull
        private final JpsModuleSourceRootType<?> type;
        @Nullable
        private String packagePrefix;
        private boolean generated;

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final JpsModuleSourceRootType<?> getType() {
            return this.type;
        }

        @Nullable
        public final String getPackagePrefix() {
            return this.packagePrefix;
        }

        public final void setPackagePrefix(@Nullable String string) {
            this.packagePrefix = string;
        }

        public final boolean getGenerated() {
            return this.generated;
        }

        public final void setGenerated(boolean bl) {
            this.generated = bl;
        }

        public SourceFolderModel(@NotNull Module module, @NotNull String url, @NotNull JpsModuleSourceRootType<?> type, @Nullable String packagePrefix, boolean generated) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(type, (String)"type");
            this.module = module;
            this.url = url;
            this.type = type;
            this.packagePrefix = packagePrefix;
            this.generated = generated;
        }

        public /* synthetic */ SourceFolderModel(Module module, String string, JpsModuleSourceRootType jpsModuleSourceRootType, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string2 = null;
            }
            if ((n & 0x10) != 0) {
                bl = false;
            }
            this(module, string, jpsModuleSourceRootType, string2, bl);
        }

        @NotNull
        public final Module component1() {
            return this.module;
        }

        @NotNull
        public final String component2() {
            return this.url;
        }

        @NotNull
        public final JpsModuleSourceRootType<?> component3() {
            return this.type;
        }

        @Nullable
        public final String component4() {
            return this.packagePrefix;
        }

        public final boolean component5() {
            return this.generated;
        }

        @NotNull
        public final SourceFolderModel copy(@NotNull Module module, @NotNull String url, @NotNull JpsModuleSourceRootType<?> type, @Nullable String packagePrefix, boolean generated) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(type, (String)"type");
            return new SourceFolderModel(module, url, type, packagePrefix, generated);
        }

        public static /* synthetic */ SourceFolderModel copy$default(SourceFolderModel sourceFolderModel, Module module, String string, JpsModuleSourceRootType jpsModuleSourceRootType, String string2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                module = sourceFolderModel.module;
            }
            if ((n & 2) != 0) {
                string = sourceFolderModel.url;
            }
            if ((n & 4) != 0) {
                jpsModuleSourceRootType = sourceFolderModel.type;
            }
            if ((n & 8) != 0) {
                string2 = sourceFolderModel.packagePrefix;
            }
            if ((n & 0x10) != 0) {
                bl = sourceFolderModel.generated;
            }
            return sourceFolderModel.copy(module, string, jpsModuleSourceRootType, string2, bl);
        }

        @NotNull
        public String toString() {
            return "SourceFolderModel(module=" + this.module + ", url=" + this.url + ", type=" + this.type + ", packagePrefix=" + this.packagePrefix + ", generated=" + this.generated + ")";
        }

        public int hashCode() {
            Module module = this.module;
            String string = this.url;
            JpsModuleSourceRootType<?> jpsModuleSourceRootType = this.type;
            String string2 = this.packagePrefix;
            int n = ((((module != null ? module.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (jpsModuleSourceRootType != null ? jpsModuleSourceRootType.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31;
            int n2 = this.generated ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SourceFolderModel)) break block3;
                    SourceFolderModel sourceFolderModel = (SourceFolderModel)object;
                    if (!Intrinsics.areEqual((Object)this.module, (Object)sourceFolderModel.module) || !Intrinsics.areEqual((Object)this.url, (Object)sourceFolderModel.url) || !Intrinsics.areEqual(this.type, sourceFolderModel.type) || !Intrinsics.areEqual((Object)this.packagePrefix, (Object)sourceFolderModel.packagePrefix) || this.generated != sourceFolderModel.generated) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/manage/SourceFolderManagerImpl$ModuleModel;", "", "module", "Lcom/intellij/openapi/module/Module;", "sourceFolders", "", "", "(Lcom/intellij/openapi/module/Module;Ljava/util/Set;)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "getSourceFolders", "()Ljava/util/Set;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.externalSystem.impl"})
    private static final class ModuleModel {
        @NotNull
        private final Module module;
        @NotNull
        private final Set<String> sourceFolders;

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final Set<String> getSourceFolders() {
            return this.sourceFolders;
        }

        public ModuleModel(@NotNull Module module, @NotNull Set<String> sourceFolders2) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter(sourceFolders2, (String)"sourceFolders");
            this.module = module;
            this.sourceFolders = sourceFolders2;
        }

        public /* synthetic */ ModuleModel(Module module, Set set2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                Set set3 = CollectionFactory.createFilePathSet();
                Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"CollectionFactory.createFilePathSet()");
                set2 = set3;
            }
            this(module, set2);
        }

        @NotNull
        public final Module component1() {
            return this.module;
        }

        @NotNull
        public final Set<String> component2() {
            return this.sourceFolders;
        }

        @NotNull
        public final ModuleModel copy(@NotNull Module module, @NotNull Set<String> sourceFolders2) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter(sourceFolders2, (String)"sourceFolders");
            return new ModuleModel(module, sourceFolders2);
        }

        public static /* synthetic */ ModuleModel copy$default(ModuleModel moduleModel, Module module, Set set2, int n, Object object) {
            if ((n & 1) != 0) {
                module = moduleModel.module;
            }
            if ((n & 2) != 0) {
                set2 = moduleModel.sourceFolders;
            }
            return moduleModel.copy(module, set2);
        }

        @NotNull
        public String toString() {
            return "ModuleModel(module=" + this.module + ", sourceFolders=" + this.sourceFolders + ")";
        }

        public int hashCode() {
            Module module = this.module;
            Set<String> set2 = this.sourceFolders;
            return (module != null ? module.hashCode() : 0) * 31 + (set2 != null ? ((Object)set2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ModuleModel)) break block3;
                    ModuleModel moduleModel = (ModuleModel)object;
                    if (!Intrinsics.areEqual((Object)this.module, (Object)moduleModel.module) || !Intrinsics.areEqual(this.sourceFolders, moduleModel.sourceFolders)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/manage/SourceFolderManagerImpl$Companion;", "", "()V", "dictionary", "", "", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "getDictionary", "()Ljava/util/Map;", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        @NotNull
        public final Map<String, JpsModuleSourceRootType<?>> getDictionary() {
            return dictionary;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

