/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.importing;

import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.autolink.UnlinkedProjectNotificationAware;
import com.intellij.openapi.externalSystem.importing.AbstractOpenProjectProvider;
import com.intellij.openapi.externalSystem.importing.OpenProjectProvider;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenedCallback;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b'\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH$J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H$J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013J$\u0010\u0018\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\n2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001a\u001a\u00020\bH\u0016R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lcom/intellij/openapi/externalSystem/importing/AbstractOpenProjectProvider;", "Lcom/intellij/openapi/externalSystem/importing/OpenProjectProvider;", "()V", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "getSystemId", "()Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "canOpenProject", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "focusOnOpenedSameProject", "projectDirectory", "Ljava/nio/file/Path;", "getProjectDirectory", "isProjectFile", "linkAndRefreshProject", "", "project", "Lcom/intellij/openapi/project/Project;", "linkToExistingProject", "projectFile", "projectFilePath", "", "openProject", "projectToClose", "forceOpenInNewFrame", "Companion", "intellij.platform.externalSystem.impl"})
@ApiStatus.Experimental
public abstract class AbstractOpenProjectProvider
implements OpenProjectProvider {
    @Nullable
    private final ProjectSystemId systemId;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    @Nullable
    protected ProjectSystemId getSystemId() {
        return this.systemId;
    }

    protected abstract boolean isProjectFile(@NotNull VirtualFile var1);

    protected abstract void linkAndRefreshProject(@NotNull Path var1, @NotNull Project var2);

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean canOpenProject(@NotNull VirtualFile file2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            if (file2.isDirectory()) {
                void $this$any$iv;
                VirtualFile[] virtualFileArray = file2.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"file.children");
                VirtualFile[] virtualFileArray2 = virtualFileArray;
                AbstractOpenProjectProvider abstractOpenProjectProvider = this;
                boolean $i$f$any = false;
                void var5_5 = $this$any$iv;
                int n = ((void)var5_5).length;
                for (int j = 0; j < n; ++j) {
                    void element$iv;
                    void p1 = element$iv = var5_5[j];
                    boolean bl2 = false;
                    if (!abstractOpenProjectProvider.isProjectFile((VirtualFile)p1)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            } else {
                bl = this.isProjectFile(file2);
            }
        }
        return bl;
    }

    @Override
    @Nullable
    public Project openProject(@NotNull VirtualFile projectFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        Intrinsics.checkNotNullParameter((Object)projectFile, (String)"projectFile");
        LOG.debug("Open project from " + projectFile);
        VirtualFile projectDirectory = this.getProjectDirectory(projectFile);
        Path path = projectDirectory.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"projectDirectory.toNioPath()");
        if (this.focusOnOpenedSameProject(path)) {
            return null;
        }
        Path path2 = projectDirectory.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"projectDirectory.toNioPath()");
        Path nioPath = path2;
        boolean isValidIdeaProject = ProjectUtil.isValidProjectPath(nioPath);
        Function1 function1 = null;
        Function1 function12 = (Function1)new Function1<Project, Boolean>(this, isValidIdeaProject, nioPath){
            final /* synthetic */ AbstractOpenProjectProvider this$0;
            final /* synthetic */ boolean $isValidIdeaProject;
            final /* synthetic */ Path $nioPath;

            public final boolean invoke(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                if (this.$isValidIdeaProject) {
                    ProjectSystemId projectSystemId = this.this$0.getSystemId();
                    if (projectSystemId != null) {
                        ProjectSystemId projectSystemId2 = projectSystemId;
                        boolean bl = false;
                        boolean bl2 = false;
                        ProjectSystemId it = projectSystemId2;
                        boolean bl3 = false;
                        UnlinkedProjectNotificationAware.Companion.enableNotifications(project, it);
                    }
                    return true;
                }
                project.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, (Object)true);
                ApplicationManager.getApplication().invokeAndWait(new Runnable(this, project){
                    final /* synthetic */ openProject.options.1 this$0;
                    final /* synthetic */ Project $project;

                    public final void run() {
                        this.this$0.this$0.linkAndRefreshProject(this.this$0.$nioPath, this.$project);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$project = project;
                    }
                });
                ProjectUtil.updateLastProjectLocation(this.$nioPath);
                return true;
            }
            {
                this.this$0 = abstractOpenProjectProvider;
                this.$isValidIdeaProject = bl;
                this.$nioPath = path;
                super(1);
            }
        };
        Function1 function13 = null;
        boolean bl = false;
        boolean bl2 = false;
        String string = null;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = 0;
        int n2 = 0;
        Object var19_18 = null;
        ProjectOpenedCallback projectOpenedCallback = null;
        boolean bl6 = false;
        String string2 = null;
        Project project = null;
        boolean bl7 = false;
        Project project2 = projectToClose;
        boolean bl8 = forceOpenInNewFrame;
        boolean bl9 = !isValidIdeaProject;
        OpenProjectTask options2 = new OpenProjectTask(bl8, project2, bl9, bl7, project, string2, bl6, projectOpenedCallback, var19_18, n2, n, bl5, bl4, bl3, string, bl2, bl, function13, function12, function1, 782328, null);
        return ProjectManagerEx.getInstanceEx().openProject(nioPath, options2);
    }

    @Override
    public void linkToExistingProject(@NotNull VirtualFile projectFile, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)projectFile, (String)"projectFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LOG.debug("Import project from " + projectFile);
        VirtualFile projectDirectory = this.getProjectDirectory(projectFile);
        Path path = projectDirectory.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"projectDirectory.toNioPath()");
        this.linkAndRefreshProject(path, project);
    }

    public final void linkToExistingProject(@NotNull String projectFilePath, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)projectFilePath, (String)"projectFilePath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LocalFileSystem localFileSystem2 = LocalFileSystem.getInstance();
        VirtualFile projectFile = localFileSystem2.refreshAndFindFileByPath(projectFilePath);
        if (projectFile == null) {
            String shortPath = FileUtil.getLocationRelativeToUserHome((String)FileUtil.toSystemDependentName((String)projectFilePath), (boolean)false);
            Object[] objectArray = new Object[2];
            ProjectSystemId projectSystemId = this.getSystemId();
            objectArray[0] = projectSystemId != null ? projectSystemId.getReadableName() : null;
            objectArray[1] = shortPath;
            throw (Throwable)new IllegalArgumentException(ExternalSystemBundle.message((String)"error.project.does.not.exist", (Object[])objectArray));
        }
        this.linkToExistingProject(projectFile, project);
    }

    private final boolean focusOnOpenedSameProject(Path projectDirectory) {
        ProjectManager projectManager = ProjectManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
        for (Project project : projectManager.getOpenProjects()) {
            if (!ProjectUtil.isSameProject(projectDirectory, project)) continue;
            ProjectUtil.focusProjectWindow(project, false);
            return true;
        }
        return false;
    }

    private final VirtualFile getProjectDirectory(VirtualFile file2) {
        VirtualFile virtualFile;
        if (file2.isDirectory()) {
            virtualFile = file2;
        } else {
            VirtualFile virtualFile2 = file2.getParent();
            virtualFile = virtualFile2;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"file.parent");
        }
        return virtualFile;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AbstractOpenProjectProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/externalSystem/importing/AbstractOpenProjectProvider$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        @NotNull
        protected final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

