/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.MainMenuCollector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.PoppedIcon;
import com.intellij.openapi.actionSystem.impl.actionholder.ActionRef;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.components.JBCheckBoxMenuItem;
import com.intellij.ui.plaf.beg.BegMenuItemUI;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.LafIconLookup;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ActionMenuItem
extends JBCheckBoxMenuItem {
    static final Icon EMPTY_ICON = EmptyIcon.create((int)16, (int)1);
    private final ActionRef<AnAction> myAction;
    private final Presentation myPresentation;
    private final String myPlace;
    private final boolean myInsideCheckedGroup;
    private final boolean myEnableMnemonics;
    private final boolean myToggleable;
    private DataContext myContext;
    private AnActionEvent myEvent;
    private MenuItemSynchronizer myMenuItemSynchronizer;
    private boolean myToggled;
    private final boolean myUseDarkIcons;

    public ActionMenuItem(AnAction action2, Presentation presentation2, @NotNull String place, @NotNull DataContext context, boolean enableMnemonics, boolean prepareNow, boolean insideCheckedGroup, boolean useDarkIcons) {
        if (place == null) {
            ActionMenuItem.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ActionMenuItem.$$$reportNull$$$0(1);
        }
        this.myAction = ActionRef.fromAction(action2);
        this.myPresentation = presentation2;
        this.myPlace = place;
        this.myContext = context;
        this.myEnableMnemonics = enableMnemonics;
        this.myToggleable = action2 instanceof Toggleable;
        this.myInsideCheckedGroup = insideCheckedGroup;
        this.myUseDarkIcons = useDarkIcons;
        this.myEvent = new AnActionEvent(null, context, place, this.myPresentation, ActionManager.getInstance(), 0, true, false);
        this.addActionListener(new ActionTransmitter());
        this.setBorderPainted(false);
        this.updateUI();
        if (prepareNow) {
            this.init();
        } else {
            this.setText(IdeBundle.message((String)"menu.item.loading", (Object[])new Object[0]));
        }
    }

    public AnAction getAnAction() {
        return this.myAction.getAction();
    }

    public String getPlace() {
        return this.myPlace;
    }

    private static boolean isEnterKeyStroke(KeyStroke keyStroke) {
        return keyStroke.getKeyCode() == 10 && keyStroke.getModifiers() == 0;
    }

    public void prepare() {
        this.init();
        this.installSynchronizer();
    }

    public void fireActionPerformed(ActionEvent event) {
        Application app = ApplicationManager.getApplication();
        if (!app.isDisposed() && "MainMenu".equals(this.myPlace)) {
            MainMenuCollector.getInstance().record(this.myAction.getAction());
        }
        ((TransactionGuardImpl)TransactionGuard.getInstance()).performUserActivity(() -> super.fireActionPerformed(event));
    }

    public void addNotify() {
        super.addNotify();
        this.installSynchronizer();
        this.init();
    }

    public void removeNotify() {
        this.uninstallSynchronizer();
        super.removeNotify();
    }

    private void installSynchronizer() {
        if (this.myMenuItemSynchronizer == null) {
            this.myMenuItemSynchronizer = new MenuItemSynchronizer();
        }
    }

    private void uninstallSynchronizer() {
        if (this.myMenuItemSynchronizer != null) {
            Disposer.dispose((Disposable)this.myMenuItemSynchronizer);
            this.myMenuItemSynchronizer = null;
        }
    }

    private void init() {
        String id2;
        int mnemonicIndex;
        AnAction action2 = this.myAction.getAction();
        this.updateIcon(action2);
        this.setVisible(this.myPresentation.isVisible());
        this.setEnabled(this.myPresentation.isEnabled());
        this.setMnemonic(this.myEnableMnemonics ? this.myPresentation.getMnemonic() : 0);
        this.setText(this.myPresentation.getText(true));
        int n = mnemonicIndex = this.myEnableMnemonics ? this.myPresentation.getDisplayedMnemonicIndex() : -1;
        if (this.getText() != null && mnemonicIndex >= 0 && mnemonicIndex < this.getText().length()) {
            this.setDisplayedMnemonicIndex(mnemonicIndex);
        }
        if ((id2 = ActionManager.getInstance().getId(action2)) != null) {
            this.setAcceleratorFromShortcuts(KeymapUtil.getActiveKeymapShortcuts((String)id2).getShortcuts());
        } else {
            ShortcutSet shortcutSet = action2.getShortcutSet();
            this.setAcceleratorFromShortcuts(shortcutSet.getShortcuts());
        }
    }

    private void setAcceleratorFromShortcuts(Shortcut @NotNull [] shortcuts) {
        if (shortcuts == null) {
            ActionMenuItem.$$$reportNull$$$0(2);
        }
        for (Shortcut shortcut : shortcuts) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            KeyStroke firstKeyStroke = ((KeyboardShortcut)shortcut).getFirstKeyStroke();
            if (ActionMenuItem.isEnterKeyStroke(firstKeyStroke)) break;
            this.setAccelerator(firstKeyStroke);
            break;
        }
    }

    public void updateUI() {
        this.setUI(BegMenuItemUI.createUI((JComponent)((Object)this)));
    }

    public void menuSelectionChanged(boolean isIncluded) {
        super.menuSelectionChanged(isIncluded);
        ActionMenu.showDescriptionInStatusBar(isIncluded, (Component)((Object)this), this.myPresentation.getDescription());
    }

    @NlsSafe
    public String getFirstShortcutText() {
        return KeymapUtil.getFirstKeyboardShortcutText((AnAction)this.myAction.getAction());
    }

    public void updateContext(@NotNull DataContext context) {
        if (context == null) {
            ActionMenuItem.$$$reportNull$$$0(3);
        }
        this.myContext = context;
        this.myEvent = new AnActionEvent(null, context, this.myPlace, this.myPresentation, ActionManager.getInstance(), 0, true, false);
    }

    private void updateIcon(AnAction action2) {
        if (this.isToggleable() && (this.myPresentation.getIcon() == null || this.myInsideCheckedGroup || !UISettings.getInstance().getShowIconsInMenus())) {
            action2.update(this.myEvent);
            this.myToggled = Toggleable.isSelected((Presentation)this.myEvent.getPresentation());
            if ("MainMenu".equals(this.myPlace) && SystemInfo.isMacSystemMenu) {
                this.setState(this.myToggled);
                this.setIcon(this.wrapNullIcon(this.getIcon()));
            } else if (this.myToggled) {
                this.setIcon(LafIconLookup.getIcon((String)"checkmark"));
                this.setSelectedIcon(LafIconLookup.getSelectedIcon((String)"checkmark"));
                this.setDisabledIcon(LafIconLookup.getDisabledIcon((String)"checkmark"));
            } else {
                this.setIcon(EmptyIcon.ICON_16);
                this.setSelectedIcon(EmptyIcon.ICON_16);
                this.setDisabledIcon(EmptyIcon.ICON_16);
            }
        } else if (UISettings.getInstance().getShowIconsInMenus()) {
            Icon selected2;
            Icon disabled;
            Icon icon2 = this.myPresentation.getIcon();
            if (action2 instanceof ToggleAction && ((ToggleAction)action2).isSelected(this.myEvent)) {
                icon2 = new PoppedIcon(icon2, 16, 16);
            }
            if ((disabled = this.myPresentation.getDisabledIcon()) == null) {
                Icon icon3 = disabled = icon2 == null ? null : IconLoader.getDisabledIcon((Icon)icon2);
            }
            if ((selected2 = this.myPresentation.getSelectedIcon()) == null) {
                selected2 = icon2;
            }
            this.setIcon(this.wrapNullIcon(this.myPresentation.isEnabled() ? icon2 : disabled));
            this.setSelectedIcon(this.wrapNullIcon(selected2));
            this.setDisabledIcon(this.wrapNullIcon(disabled));
        }
    }

    private Icon wrapNullIcon(Icon icon2) {
        if (ActionMenu.isShowIcons()) {
            return null;
        }
        if (!ActionMenu.isAligned() || !ActionMenu.isAlignedInGroup()) {
            return icon2;
        }
        if (icon2 == null && SystemInfo.isMacSystemMenu && "MainMenu".equals(this.myPlace)) {
            return EMPTY_ICON;
        }
        return icon2;
    }

    public void setIcon(Icon icon2) {
        if (SystemInfo.isMacSystemMenu && "MainMenu".equals(this.myPlace) && icon2 != null) {
            icon2 = IconLoader.getMenuBarIcon((Icon)icon2, (boolean)this.myUseDarkIcons);
        }
        super.setIcon(icon2);
    }

    public boolean isToggleable() {
        return this.myToggleable;
    }

    public boolean isSelected() {
        return this.myToggled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcuts";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionMenuItem";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setAcceleratorFromShortcuts";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MenuItemSynchronizer
    implements PropertyChangeListener,
    Disposable {
        @NonNls
        private static final String SELECTED = "selected";
        private final Set<String> mySynchronized = new HashSet<String>();

        private MenuItemSynchronizer() {
            ActionMenuItem.this.myPresentation.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void dispose() {
            ActionMenuItem.this.myPresentation.removePropertyChangeListener((PropertyChangeListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            boolean queueForDispose = ActionMenuItem.this.getParent() == null;
            String name = e.getPropertyName();
            if (this.mySynchronized.contains(name)) {
                return;
            }
            this.mySynchronized.add(name);
            try {
                if ("visible".equals(name)) {
                    boolean visible = ActionMenuItem.this.myPresentation.isVisible();
                    if (!visible && SystemInfo.isMacSystemMenu && ActionMenuItem.this.myPlace.equals("MainMenu")) {
                        ActionMenuItem.this.setEnabled(false);
                    } else {
                        ActionMenuItem.this.setVisible(visible);
                    }
                } else if ("enabled".equals(name)) {
                    ActionMenuItem.this.setEnabled(ActionMenuItem.this.myPresentation.isEnabled());
                    ActionMenuItem.this.updateIcon(ActionMenuItem.this.myAction.getAction());
                } else if ("mnemonicKey".equals(name)) {
                    ActionMenuItem.this.setMnemonic(ActionMenuItem.this.myPresentation.getMnemonic());
                } else if ("mnemonicIndex".equals(name)) {
                    ActionMenuItem.this.setDisplayedMnemonicIndex(ActionMenuItem.this.myPresentation.getDisplayedMnemonicIndex());
                } else if ("text".equals(name)) {
                    ActionMenuItem.this.setText(ActionMenuItem.this.myPresentation.getText(true));
                    Window window = ComponentUtil.getWindow((Component)((Object)ActionMenuItem.this));
                    if (window != null) {
                        window.pack();
                    }
                } else if ("icon".equals(name) || "disabledIcon".equals(name) || SELECTED.equals(name)) {
                    ActionMenuItem.this.updateIcon(ActionMenuItem.this.myAction.getAction());
                }
            }
            finally {
                this.mySynchronized.remove(name);
                if (queueForDispose) {
                    SwingUtilities.invokeLater(() -> {
                        if (ActionMenuItem.this.getParent() == null) {
                            ActionMenuItem.this.uninstallSynchronizer();
                        }
                    });
                }
            }
        }
    }

    private final class ActionTransmitter
    implements ActionListener {
        private ActionTransmitter() {
        }

        private boolean isInTree(Component component2) {
            if (component2 instanceof Window) {
                return component2.isShowing();
            }
            Window windowAncestor = SwingUtilities.getWindowAncestor(component2);
            return windowAncestor != null && windowAncestor.isShowing();
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            if (e == null) {
                ActionTransmitter.$$$reportNull$$$0(0);
            }
            IdeFocusManager focusManager = IdeFocusManager.findInstanceByContext((DataContext)ActionMenuItem.this.myContext);
            ActionCallback typeAhead = new ActionCallback();
            String id2 = ActionManager.getInstance().getId(ActionMenuItem.this.myAction.getAction());
            if (id2 != null) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("context.menu.click.stats." + id2.replace(' ', '.'));
            }
            focusManager.typeAheadUntil(typeAhead, ActionMenuItem.this.getText());
            focusManager.runOnOwnContext(ActionMenuItem.this.myContext, () -> {
                AWTEvent currentEvent = IdeEventQueue.getInstance().getTrueCurrentEvent();
                AnActionEvent event = new AnActionEvent(currentEvent instanceof InputEvent ? (InputEvent)currentEvent : null, ActionMenuItem.this.myContext, ActionMenuItem.this.myPlace, ActionMenuItem.this.myPresentation, ActionManager.getInstance(), e.getModifiers(), true, false);
                AnAction menuItemAction = ActionMenuItem.this.myAction.getAction();
                if (ActionUtil.lastUpdateAndCheckDumb((AnAction)menuItemAction, (AnActionEvent)event, (boolean)false)) {
                    ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
                    actionManager.fireBeforeActionPerformed(menuItemAction, ActionMenuItem.this.myContext, event);
                    focusManager.doWhenFocusSettlesDown(() -> ((ActionCallback)typeAhead).setDone());
                    ActionUtil.performActionDumbAware((AnAction)menuItemAction, (AnActionEvent)event);
                    actionManager.queueActionPerformedEvent(menuItemAction, ActionMenuItem.this.myContext, event);
                } else {
                    typeAhead.setDone();
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/actionSystem/impl/ActionMenuItem$ActionTransmitter", "actionPerformed"));
        }
    }
}

