/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.ui;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EditorColorSchemesUsagesCollector
extends ApplicationUsagesCollector {
    private static final int CURR_VERSION = 3;
    public static final String SCHEME_NAME_OTHER = "Other";
    public static final String[] KNOWN_NAMES = new String[]{"Default", "Darcula", "Obsidian", "Visual Studio", "Solarized", "Wombat", "Monkai", "XCode", "Sublime", "Oblivion", "Zenburn", "Cobalt", "Netbeans", "Eclipse", "Aptana", "Flash Builder", "IdeaLight", "High contrast", "ReSharper", "Rider", "IntelliJ Light"};

    public int getVersion() {
        return 3;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        EditorColorsScheme currentScheme = EditorColorsManager.getInstance().getGlobalScheme();
        HashSet<MetricEvent> usages = new HashSet<MetricEvent>();
        if (currentScheme instanceof AbstractColorsScheme) {
            AbstractColorsScheme original;
            String schemeName = currentScheme.getName();
            if (schemeName.startsWith("_@user_") && (original = ((AbstractColorsScheme)currentScheme).getOriginal()) != null) {
                schemeName = original.getName();
            }
            FeatureUsageData data2 = new FeatureUsageData().addData("scheme", EditorColorSchemesUsagesCollector.getKnownSchemeName(schemeName)).addData("is_dark", ColorUtil.isDark((Color)currentScheme.getDefaultBackground()));
            usages.add(MetricEventFactoryKt.newMetric((String)"enabled.color.scheme", (FeatureUsageData)data2));
        }
        HashSet<MetricEvent> hashSet = usages;
        if (hashSet == null) {
            EditorColorSchemesUsagesCollector.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    @NotNull
    private static String getKnownSchemeName(@NonNls @NotNull String schemeName) {
        if (schemeName == null) {
            EditorColorSchemesUsagesCollector.$$$reportNull$$$0(1);
        }
        for (String knownName : KNOWN_NAMES) {
            if (!StringUtil.toUpperCase((String)schemeName).contains(StringUtil.toUpperCase((String)knownName))) continue;
            String string = knownName;
            if (string == null) {
                EditorColorSchemesUsagesCollector.$$$reportNull$$$0(2);
            }
            return string;
        }
        return SCHEME_NAME_OTHER;
    }

    @NotNull
    public String getGroupId() {
        return "ui.editor.color.schemes";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/ui/EditorColorSchemesUsagesCollector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/ui/EditorColorSchemesUsagesCollector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKnownSchemeName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getKnownSchemeName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

