/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector;

import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.ide.ui.customization.CustomisedActionGroup;
import com.intellij.internal.inspector.PropertyBean;
import com.intellij.internal.inspector.UiInspectorContextProvider;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UiInspectorUtil {
    private static final String PROPERTY_KEY = "UiInspectorContextProvider.Key";

    public static void registerProvider(@NotNull JComponent component2, @NotNull UiInspectorContextProvider provider2) {
        if (component2 == null) {
            UiInspectorUtil.$$$reportNull$$$0(0);
        }
        if (provider2 == null) {
            UiInspectorUtil.$$$reportNull$$$0(1);
        }
        component2.putClientProperty(PROPERTY_KEY, provider2);
    }

    public static UiInspectorContextProvider getProvider(@NotNull Object component2) {
        if (component2 == null) {
            UiInspectorUtil.$$$reportNull$$$0(2);
        }
        if (component2 instanceof UiInspectorContextProvider) {
            return (UiInspectorContextProvider)component2;
        }
        if (component2 instanceof JComponent) {
            return (UiInspectorContextProvider)ObjectUtils.tryCast((Object)((JComponent)component2).getClientProperty(PROPERTY_KEY), UiInspectorContextProvider.class);
        }
        return null;
    }

    @Nullable
    public static String getActionId(@NotNull AnAction action2) {
        if (action2 == null) {
            UiInspectorUtil.$$$reportNull$$$0(3);
        }
        if (action2 instanceof CustomisedActionGroup) {
            action2 = ((CustomisedActionGroup)action2).getOrigin();
        }
        return ActionManager.getInstance().getId(action2);
    }

    @NotNull
    public static List<PropertyBean> collectActionGroupInfo(@NotNull @NonNls String prefix, @NotNull ActionGroup group2, @Nullable String place) {
        if (prefix == null) {
            UiInspectorUtil.$$$reportNull$$$0(4);
        }
        if (group2 == null) {
            UiInspectorUtil.$$$reportNull$$$0(5);
        }
        ArrayList<PropertyBean> result2 = new ArrayList<PropertyBean>();
        if (place != null) {
            result2.add(new PropertyBean(prefix + " Place", place, true));
        }
        String toolbarId = UiInspectorUtil.getActionId((AnAction)group2);
        result2.add(new PropertyBean(prefix + " Group", toolbarId, true));
        HashSet<String> ids = new HashSet<String>();
        UiInspectorUtil.recursiveCollectGroupIds(group2, ids);
        ContainerUtil.addIfNotNull(ids, (Object)toolbarId);
        if (ids.size() > 1 || ids.size() == 1 && toolbarId == null) {
            result2.add(new PropertyBean("All Groups", StringUtil.join(ids, (String)", "), true));
        }
        ArrayList<PropertyBean> arrayList = result2;
        if (arrayList == null) {
            UiInspectorUtil.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public static List<PropertyBean> collectAnActionInfo(@NotNull AnAction action2) {
        if (action2 == null) {
            UiInspectorUtil.$$$reportNull$$$0(7);
        }
        ArrayList<PropertyBean> result2 = new ArrayList<PropertyBean>();
        result2.add(new PropertyBean("Action", action2.getClass().getName(), true));
        boolean isGroup = action2 instanceof ActionGroup;
        result2.add(new PropertyBean("Action" + (isGroup ? " Group" : "") + " ID", UiInspectorUtil.getActionId(action2), true));
        ClassLoader classLoader = action2.getClass().getClassLoader();
        if (classLoader instanceof PluginClassLoader) {
            result2.add(new PropertyBean("Action Plugin ID", ((PluginClassLoader)((Object)classLoader)).getPluginId().getIdString(), true));
        }
        ArrayList<PropertyBean> arrayList = result2;
        if (arrayList == null) {
            UiInspectorUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static void recursiveCollectGroupIds(@NotNull ActionGroup group2, @NotNull Set<String> result2) {
        if (group2 == null) {
            UiInspectorUtil.$$$reportNull$$$0(9);
        }
        if (result2 == null) {
            UiInspectorUtil.$$$reportNull$$$0(10);
        }
        for (AnAction action2 : group2.getChildren(null)) {
            if (!(action2 instanceof ActionGroup)) continue;
            ActionGroup child2 = (ActionGroup)action2;
            ContainerUtil.addIfNotNull(result2, (Object)UiInspectorUtil.getActionId((AnAction)child2));
            UiInspectorUtil.recursiveCollectGroupIds(child2, result2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/inspector/UiInspectorUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/inspector/UiInspectorUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectActionGroupInfo";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAnActionInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerProvider";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProvider";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getActionId";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectActionGroupInfo";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectAnActionInfo";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "recursiveCollectGroupIds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

