/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoPattern;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.SmartHashSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TodoFilter
implements Cloneable {
    private static final Logger LOG = Logger.getInstance(TodoFilter.class);
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String ELEMENT_PATTERN = "pattern";
    @NonNls
    private static final String ATTRIBUTE_INDEX = "index";
    @NlsSafe
    private String myName;
    private Set<TodoPattern> myTodoPatterns;

    public TodoFilter() {
        this.setName("");
        this.myTodoPatterns = new SmartHashSet();
    }

    public TodoFilter(@NotNull Element element2, @NotNull List<? extends TodoPattern> patterns) {
        if (element2 == null) {
            TodoFilter.$$$reportNull$$$0(0);
        }
        if (patterns == null) {
            TodoFilter.$$$reportNull$$$0(1);
        }
        this.setName("");
        this.myTodoPatterns = new SmartHashSet();
        this.readExternal(element2, patterns);
    }

    public boolean accept(PsiTodoSearchHelper searchHelper, PsiFile psiFile) {
        Iterator<TodoPattern> i2 = this.iterator();
        while (i2.hasNext()) {
            TodoPattern todoPattern = i2.next();
            if (searchHelper.getTodoItemsCount(psiFile, todoPattern) <= 0) continue;
            return true;
        }
        return false;
    }

    @NotNull
    @NlsSafe
    public String getName() {
        String string = this.myName;
        if (string == null) {
            TodoFilter.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setName(@NotNull @NlsSafe String name) {
        if (name == null) {
            TodoFilter.$$$reportNull$$$0(3);
        }
        this.myName = name;
    }

    public boolean contains(TodoPattern pattern) {
        return this.myTodoPatterns.contains(pattern);
    }

    public void addTodoPattern(TodoPattern pattern) {
        LOG.assertTrue(!this.myTodoPatterns.contains(pattern));
        this.myTodoPatterns.add(pattern);
    }

    public void removeTodoPattern(TodoPattern pattern) {
        LOG.assertTrue(this.myTodoPatterns.contains(pattern));
        this.myTodoPatterns.remove(pattern);
    }

    public Iterator<TodoPattern> iterator() {
        return this.myTodoPatterns.iterator();
    }

    public boolean isEmpty() {
        return this.myTodoPatterns.isEmpty();
    }

    private void readExternal(@NotNull Element element2, @NotNull List<? extends TodoPattern> patterns) {
        if (element2 == null) {
            TodoFilter.$$$reportNull$$$0(4);
        }
        if (patterns == null) {
            TodoFilter.$$$reportNull$$$0(5);
        }
        this.myName = element2.getAttributeValue(ATTRIBUTE_NAME);
        if (this.myName == null) {
            throw new IllegalArgumentException();
        }
        this.myTodoPatterns.clear();
        for (Element child2 : element2.getChildren(ELEMENT_PATTERN)) {
            try {
                TodoPattern pattern;
                int index = Integer.parseInt(child2.getAttributeValue(ATTRIBUTE_INDEX));
                if (index < 0 || index > patterns.size() - 1 || this.myTodoPatterns.contains(pattern = patterns.get(index))) continue;
                this.myTodoPatterns.add(pattern);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void writeExternal(Element element2, TodoPattern[] patterns) {
        element2.setAttribute(ATTRIBUTE_NAME, this.myName);
        for (TodoPattern pattern : this.myTodoPatterns) {
            int index = ArrayUtilRt.find((Object[])patterns, (Object)pattern);
            LOG.assertTrue(index != -1);
            Element child2 = new Element(ELEMENT_PATTERN);
            child2.setAttribute(ATTRIBUTE_INDEX, Integer.toString(index));
            element2.addContent(child2);
        }
    }

    public int hashCode() {
        int hashCode = this.myName.hashCode();
        for (TodoPattern myTodoPattern : this.myTodoPatterns) {
            hashCode += myTodoPattern.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TodoFilter)) {
            return false;
        }
        TodoFilter filter2 = (TodoFilter)obj;
        if (!this.myName.equals(filter2.myName)) {
            return false;
        }
        if (this.myTodoPatterns.size() != filter2.myTodoPatterns.size()) {
            return false;
        }
        for (TodoPattern pattern : this.myTodoPatterns) {
            if (filter2.contains(pattern)) continue;
            return false;
        }
        return true;
    }

    public TodoFilter clone() {
        try {
            TodoFilter filter2 = (TodoFilter)super.clone();
            filter2.myTodoPatterns = new HashSet<TodoPattern>(this.myTodoPatterns);
            return filter2;
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/TodoFilter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_NAME;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/TodoFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

