/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginUpdatesService {
    private static final List<PluginUpdatesService> SERVICES = new ArrayList<PluginUpdatesService>();
    private static Collection<IdeaPluginDescriptor> myCache;
    private static boolean myPrepared;
    private static boolean myPreparing;
    private static boolean myReset;
    private Consumer<? super Integer> myTreeCallback;
    private Consumer<? super Integer> myTabCallback;
    private Consumer<? super Collection<IdeaPluginDescriptor>> myInstalledPanelCallback;
    private Consumer<? super Collection<IdeaPluginDescriptor>> myUpdatePanelCallback;

    @NotNull
    public static PluginUpdatesService connectTreeRenderer(@NotNull Consumer<? super Integer> callback2) {
        if (callback2 == null) {
            PluginUpdatesService.$$$reportNull$$$0(0);
        }
        PluginUpdatesService.checkAccess();
        PluginUpdatesService service = new PluginUpdatesService();
        SERVICES.add(service);
        service.myTreeCallback = callback2;
        if (myPrepared) {
            callback2.accept(PluginUpdatesService.getCount());
        } else {
            PluginUpdatesService.calculateUpdates();
        }
        PluginUpdatesService pluginUpdatesService = service;
        if (pluginUpdatesService == null) {
            PluginUpdatesService.$$$reportNull$$$0(1);
        }
        return pluginUpdatesService;
    }

    @NotNull
    public static PluginUpdatesService connectConfigurable(@NotNull Consumer<? super Integer> callback2) {
        if (callback2 == null) {
            PluginUpdatesService.$$$reportNull$$$0(2);
        }
        PluginUpdatesService.checkAccess();
        PluginUpdatesService service = new PluginUpdatesService();
        SERVICES.add(service);
        service.myTabCallback = callback2;
        if (myPrepared) {
            callback2.accept(PluginUpdatesService.getCount());
        } else {
            PluginUpdatesService.calculateUpdates();
        }
        PluginUpdatesService pluginUpdatesService = service;
        if (pluginUpdatesService == null) {
            PluginUpdatesService.$$$reportNull$$$0(3);
        }
        return pluginUpdatesService;
    }

    public void connectInstalled(@NotNull Consumer<? super Collection<IdeaPluginDescriptor>> callback2) {
        if (callback2 == null) {
            PluginUpdatesService.$$$reportNull$$$0(4);
        }
        PluginUpdatesService.checkAccess();
        this.myInstalledPanelCallback = callback2;
        if (myPrepared) {
            callback2.accept(myCache);
        } else {
            PluginUpdatesService.calculateUpdates();
        }
    }

    public void calculateUpdates(@NotNull Consumer<? super Collection<IdeaPluginDescriptor>> callback2) {
        if (callback2 == null) {
            PluginUpdatesService.$$$reportNull$$$0(5);
        }
        PluginUpdatesService.checkAccess();
        this.myUpdatePanelCallback = callback2;
        if (myPrepared) {
            callback2.accept(myCache);
        } else {
            PluginUpdatesService.calculateUpdates();
        }
    }

    public void finishUpdate(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginUpdatesService.$$$reportNull$$$0(6);
        }
        PluginUpdatesService.checkAccess();
        if (!myPrepared || myCache == null) {
            return;
        }
        Iterator<IdeaPluginDescriptor> I = myCache.iterator();
        while (I.hasNext()) {
            IdeaPluginDescriptor downloadedDescriptor = I.next();
            if (!downloadedDescriptor.equals(descriptor2)) continue;
            I.remove();
            Integer countValue = PluginUpdatesService.getCount();
            for (PluginUpdatesService service : SERVICES) {
                service.runCountCallbacks(countValue);
            }
            return;
        }
    }

    public void finishUpdate() {
        PluginUpdatesService.checkAccess();
        if (!myPrepared || myCache == null) {
            return;
        }
        Integer countValue = PluginUpdatesService.getCount();
        for (PluginUpdatesService service : SERVICES) {
            service.runCountCallbacks(countValue);
        }
    }

    public void recalculateUpdates() {
        PluginUpdatesService.checkAccess();
        for (PluginUpdatesService service : SERVICES) {
            service.runAllCallbacks(0);
        }
        if (myPreparing) {
            PluginUpdatesService.resetUpdates();
        } else {
            PluginUpdatesService.calculateUpdates();
        }
    }

    private static void resetUpdates() {
        myReset = true;
    }

    public void dispose() {
        PluginUpdatesService.checkAccess();
        PluginUpdatesService.dispose(this);
    }

    private static void dispose(@NotNull PluginUpdatesService service) {
        if (service == null) {
            PluginUpdatesService.$$$reportNull$$$0(7);
        }
        SERVICES.remove(service);
        if (SERVICES.isEmpty()) {
            myCache = null;
            myPrepared = false;
            myPreparing = false;
        }
    }

    public static boolean isNeedUpdate(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginUpdatesService.$$$reportNull$$$0(8);
        }
        PluginUpdatesService.checkAccess();
        PluginId pluginId = descriptor2.getPluginId();
        if (myPrepared && myCache != null) {
            for (IdeaPluginDescriptor downloader : myCache) {
                if (!pluginId.equals(downloader.getPluginId())) continue;
                return true;
            }
        }
        return InstalledPluginsState.getInstance().hasNewerVersion(pluginId);
    }

    @Nullable
    public static Collection<IdeaPluginDescriptor> getUpdates() {
        PluginUpdatesService.checkAccess();
        return !myPrepared || myPreparing || myCache == null ? null : myCache;
    }

    private static void calculateUpdates() {
        if (myPreparing) {
            return;
        }
        myPreparing = true;
        myCache = null;
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            UpdateChecker.CheckPluginsUpdateResult updates2 = UpdateChecker.checkPluginsUpdate((ProgressIndicator)new EmptyProgressIndicator());
            ApplicationManager.getApplication().invokeLater(() -> {
                PluginUpdatesService.checkAccess();
                myPreparing = false;
                if (myReset) {
                    myReset = false;
                    PluginUpdatesService.calculateUpdates();
                    return;
                }
                myPrepared = true;
                ArrayList<IdeaPluginDescriptor> cache = new ArrayList<IdeaPluginDescriptor>();
                Collection<PluginDownloader> availableUpdates = updates2.getAvailableUpdates();
                if (availableUpdates != null) {
                    cache.addAll(ContainerUtil.map(availableUpdates, downloader -> downloader.getDescriptor()));
                }
                cache.addAll(ContainerUtil.map(updates2.getAvailableDisabledUpdates(), downloader -> downloader.getDescriptor()));
                myCache = cache;
                Integer countValue = PluginUpdatesService.getCount();
                for (PluginUpdatesService service : SERVICES) {
                    service.runAllCallbacks(countValue);
                }
            }, ModalityState.any());
        });
    }

    private void runAllCallbacks(@Nullable Integer countValue) {
        this.runCountCallbacks(countValue);
        if (this.myInstalledPanelCallback != null) {
            this.myInstalledPanelCallback.accept(myCache);
        }
        if (this.myUpdatePanelCallback != null) {
            this.myUpdatePanelCallback.accept(myCache);
        }
    }

    private void runCountCallbacks(@Nullable Integer countValue) {
        if (this.myTreeCallback != null) {
            this.myTreeCallback.accept(countValue);
        }
        if (this.myTabCallback != null) {
            this.myTabCallback.accept(countValue);
        }
    }

    @Nullable
    private static Integer getCount() {
        return myCache == null ? null : Integer.valueOf(myCache.size());
    }

    private static void checkAccess() {
        assert (SwingUtilities.isEventDispatchThread());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/PluginUpdatesService";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/PluginUpdatesService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "connectTreeRenderer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "connectConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "connectTreeRenderer";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "connectConfigurable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "connectInstalled";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calculateUpdates";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "finishUpdate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isNeedUpdate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

