/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DynamicPluginVfsListener;
import com.intellij.ide.plugins.DynamicPluginVfsListenerInitializer;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.PreloadingActivity;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ide/plugins/DynamicPluginVfsListenerInitializer;", "Lcom/intellij/openapi/application/PreloadingActivity;", "()V", "preload", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.platform.ide.impl"})
public final class DynamicPluginVfsListenerInitializer
extends PreloadingActivity {
    @Override
    public void preload(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        if (SystemProperties.is((String)"idea.auto.reload.plugins")) {
            String string = PathManager.getPluginsPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PathManager.getPluginsPath()");
            String pluginsPath = string;
            LocalFileSystem.getInstance().addRootToWatch(pluginsPath, true);
            VirtualFile pluginsRoot = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(pluginsPath));
            if (pluginsRoot != null) {
                VfsUtilCore.processFilesRecursively((VirtualFile)pluginsRoot, (Processor)preload.1.INSTANCE);
                RefreshQueue.getInstance().refresh(true, true, (Runnable)preload.2.INSTANCE, new VirtualFile[]{pluginsRoot});
            } else {
                DynamicPluginVfsListener.Companion.getLOG().info("Dynamic plugin VFS listener not active, couldn't find plugins root in VFS");
            }
        }
    }
}

