/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import org.jetbrains.annotations.Nullable;

public final class Version
implements Comparable<Version> {
    public static final Version UNKNOWN = new Version(-1, -1);
    private final int myMajor;
    private final int myMinor;

    Version(int major, int minor) {
        this.myMajor = major;
        this.myMinor = minor;
    }

    public static Version fromString(@Nullable String ver) {
        int dot;
        int major = -1;
        int minor = -1;
        int n = dot = ver == null ? -1 : ver.indexOf(46);
        if (dot > 0) {
            major = Integer.parseInt(ver.substring(0, dot));
            minor = Integer.parseInt(ver.substring(dot + 1));
        }
        return major < 0 || minor < 0 ? UNKNOWN : new Version(major, minor);
    }

    public boolean isUnknown() {
        return this.myMajor < 0 || this.myMinor < 0;
    }

    public int getMajor() {
        return this.myMajor;
    }

    public int getMinor() {
        return this.myMinor;
    }

    @Override
    public int compareTo(Version other) {
        if (this.isUnknown()) {
            return other.isUnknown() ? 0 : -1;
        }
        int majorDiff = this.myMajor - other.myMajor;
        return majorDiff != 0 ? majorDiff : this.myMinor - other.myMinor;
    }

    public boolean isNewer(Version other) {
        return this.compareTo(other) > 0;
    }

    public boolean isOlder(Version other) {
        return this.compareTo(other) < 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version2 = (Version)o;
        if (this.myMajor != version2.myMajor) {
            return false;
        }
        return this.myMinor == version2.myMinor;
    }

    public int hashCode() {
        int result2 = this.myMajor;
        result2 = 31 * result2 + this.myMinor;
        return result2;
    }

    public String toString() {
        return this.isUnknown() ? "unknown" : this.myMajor + "." + this.myMinor;
    }
}

