/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.ide.browsers.WebBrowserService;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.ide.browsers.WebBrowserXmlService;
import com.intellij.ide.browsers.actions.BaseOpenInBrowserActionKt;
import com.intellij.ide.browsers.impl.WebBrowserServiceImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.util.BitUtil;
import com.intellij.util.Url;
import java.util.Collection;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/browsers/actions/BaseOpenInBrowserAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "(Lcom/intellij/ide/browsers/WebBrowser;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getBrowser", "update", "Companion", "intellij.platform.ide.impl"})
public final class BaseOpenInBrowserAction
extends DumbAwareAction {
    private final WebBrowser browser;
    private static final Logger LOG;
    public static final Companion Companion;

    private final WebBrowser getBrowser() {
        if (WebBrowserManager.getInstance().isActive(this.browser) && this.browser.getPath() != null) {
            return this.browser;
        }
        return null;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        WebBrowser browser2 = this.getBrowser();
        if (browser2 == null) {
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
            presentation2.setEnabledAndVisible(false);
            return;
        }
        OpenInBrowserRequest result2 = null;
        if (Intrinsics.areEqual((Object)e.getPlace(), (Object)"unknown")) {
            DataContext dataContext = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"e.dataContext");
            OpenInBrowserRequest openInBrowserRequest = result2 = BaseOpenInBrowserActionKt.access$createRequest(dataContext, true);
            boolean isApplicable = openInBrowserRequest != null ? openInBrowserRequest.isPhysicalFile() : false;
            Presentation presentation3 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"e.presentation");
            presentation3.setEnabledAndVisible(isApplicable);
            if (!isApplicable) {
                return;
            }
            Intrinsics.checkNotNull((Object)result2);
        } else {
            OpenInBrowserRequest openInBrowserRequest = Companion.doUpdate(e);
            if (openInBrowserRequest == null) {
                return;
            }
            result2 = openInBrowserRequest;
        }
        Presentation presentation4 = this.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation4, (String)"templatePresentation");
        String description = presentation4.getText();
        if (Intrinsics.areEqual((Object)"ContextToolbar", (Object)e.getPlace())) {
            boolean bl = false;
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder $this$buildString = stringBuilder;
            boolean bl5 = false;
            Shortcut shortcut = KeymapUtil.getPrimaryShortcut((String)"WebOpenInAction");
            if (shortcut != null) {
                $this$buildString.append(KeymapUtil.getShortcutText((Shortcut)shortcut));
            }
            if (WebBrowserXmlService.Companion.getInstance().isHtmlFile((PsiElement)result2.getFile())) {
                $this$buildString.append(shortcut != null ? ", " : "");
                $this$buildString.append(IdeBundle.message((String)"browser.shortcut", (Object[])new Object[0]));
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            String shortcutInfo = string;
            CharSequence charSequence = shortcutInfo;
            boolean bl6 = false;
            if (charSequence.length() > 0) {
                description = description + " (" + shortcutInfo + ')';
            }
        }
        Presentation presentation5 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation5, (String)"e.presentation");
        presentation5.setText(description);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            WebBrowser webBrowser = this.getBrowser();
            if (webBrowser == null) break block0;
            WebBrowser webBrowser2 = webBrowser;
            boolean bl = false;
            boolean bl2 = false;
            WebBrowser it = webBrowser2;
            boolean bl3 = false;
            Companion.openInBrowser$intellij_platform_ide_impl(e, it);
        }
    }

    public BaseOpenInBrowserAction(@NotNull WebBrowser browser2) {
        Intrinsics.checkNotNullParameter((Object)browser2, (String)"browser");
        super(browser2.getName(), null, browser2.getIcon());
        this.browser = browser2;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BaseOpenInBrowserAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @JvmStatic
    @Nullable
    public static final OpenInBrowserRequest doUpdate(@NotNull AnActionEvent event) {
        return Companion.doUpdate(event);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J+\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\b\b\u0002\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u001f\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0000\u00a2\u0006\u0002\b\u0011R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ide/browsers/actions/BaseOpenInBrowserAction$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "doUpdate", "Lcom/intellij/ide/browsers/OpenInBrowserRequest;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "openInBrowser", "", "request", "preferLocalUrl", "", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "openInBrowser$intellij_platform_ide_impl", "intellij.platform.ide.impl"})
    public static final class Companion {
        /*
         * Unable to fully structure code
         */
        @JvmStatic
        @Nullable
        public final OpenInBrowserRequest doUpdate(@NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            v0 = event.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"event.dataContext");
            request = BaseOpenInBrowserActionKt.access$createRequest(v0, false);
            if (request == null) ** GOTO lbl-1000
            v1 = WebBrowserServiceImpl.Companion.getProviders(request).findAny();
            Intrinsics.checkNotNullExpressionValue(v1, (String)"WebBrowserServiceImpl.ge\u2026viders(request).findAny()");
            if (v1.isPresent()) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            applicable = v2;
            v3 = event.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"event.presentation");
            v3.setEnabledAndVisible(applicable);
            return applicable != false ? request : null;
        }

        public final void openInBrowser$intellij_platform_ide_impl(@NotNull OpenInBrowserRequest request, boolean preferLocalUrl, @Nullable WebBrowser browser2) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            try {
                Collection collection = WebBrowserService.getInstance().getUrlsToOpen(request, preferLocalUrl);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"WebBrowserService.getIns\u2026(request, preferLocalUrl)");
                Collection urls = collection;
                if (!urls.isEmpty()) {
                    BaseOpenInBrowserActionKt.access$chooseUrl(urls).onSuccess((Consumer)new Consumer<Url>(browser2, request){
                        final /* synthetic */ WebBrowser $browser;
                        final /* synthetic */ OpenInBrowserRequest $request;

                        public final void accept(Url url) {
                            FileDocumentManager.getInstance().saveAllDocuments();
                            BrowserLauncher browserLauncher = BrowserLauncher.Companion.getInstance();
                            String string = url.toExternalForm();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.toExternalForm()");
                            browserLauncher.browse(string, this.$browser, this.$request.getProject());
                        }
                        {
                            this.$browser = webBrowser;
                            this.$request = openInBrowserRequest;
                        }
                    });
                }
            }
            catch (WebBrowserUrlProvider.BrowserException e) {
                Messages.showErrorDialog((String)e.getMessage(), (String)IdeBundle.message((String)"browser.error", (Object[])new Object[0]));
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        public static /* synthetic */ void openInBrowser$intellij_platform_ide_impl$default(Companion companion, OpenInBrowserRequest openInBrowserRequest, boolean bl, WebBrowser webBrowser, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                webBrowser = null;
            }
            companion.openInBrowser$intellij_platform_ide_impl(openInBrowserRequest, bl, webBrowser);
        }

        public final void openInBrowser$intellij_platform_ide_impl(@NotNull AnActionEvent event, @Nullable WebBrowser browser2) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                DataContext dataContext = event.getDataContext();
                Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"event.dataContext");
                OpenInBrowserRequest openInBrowserRequest = BaseOpenInBrowserActionKt.access$createRequest(dataContext, true);
                if (openInBrowserRequest == null) break block0;
                OpenInBrowserRequest openInBrowserRequest2 = openInBrowserRequest;
                boolean bl = false;
                boolean bl2 = false;
                OpenInBrowserRequest it = openInBrowserRequest2;
                boolean bl3 = false;
                Companion.openInBrowser$intellij_platform_ide_impl(it, BitUtil.isSet((int)event.getModifiers(), (int)1), browser2);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

