/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.impl.ToolWindowEventSource;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \n2\u00020\u00012\u00020\u0002:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/actions/HideToolWindowAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "event", "Companion", "intellij.platform.ide.impl"})
public final class HideToolWindowAction
extends AnAction
implements DumbAware {
    public static final Companion Companion = new Companion(null);

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
        if (toolWindowManager == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.wm.impl.ToolWindowManagerImpl");
        }
        ToolWindowManagerImpl toolWindowManager2 = (ToolWindowManagerImpl)toolWindowManager;
        String string = toolWindowManager2.getActiveToolWindowId();
        if (string == null) {
            string = toolWindowManager2.getLastActiveToolWindowId();
        }
        if (string == null) {
            return;
        }
        String id2 = string;
        toolWindowManager2.hideToolWindow(id2, false, true, ToolWindowEventSource.HideToolWindowAction);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void update(@NotNull AnActionEvent event) {
        ToolWindow window;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Presentation presentation2 = event.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"event.presentation");
        Presentation presentation3 = presentation2;
        Project project = event.getProject();
        if (project == null) {
            presentation3.setEnabled(false);
            return;
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
        String string = toolWindowManager.getActiveToolWindowId();
        if (string == null) {
            string = toolWindowManager.getLastActiveToolWindowId();
        }
        String id2 = string;
        ToolWindow toolWindow = window = id2 == null ? null : toolWindowManager.getToolWindow(id2);
        if (window == null) {
            presentation3.setEnabled(false);
            return;
        }
        if (window.isVisible()) {
            IdeFocusManager ideFocusManager = IdeFocusManager.getGlobalInstance();
            Intrinsics.checkNotNullExpressionValue((Object)ideFocusManager, (String)"IdeFocusManager.getGlobalInstance()");
            if (UIUtil.isDescendingFrom((Component)ideFocusManager.getFocusOwner(), (Component)window.getComponent())) {
                presentation3.setEnabled(true);
                return;
            }
        }
        String string2 = id2;
        Intrinsics.checkNotNull((Object)string2);
        presentation3.setEnabled(Companion.shouldBeHiddenByShortCut$intellij_platform_ide_impl(toolWindowManager, string2));
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/intellij/ide/actions/HideToolWindowAction$Companion;", "", "()V", "shouldBeHiddenByShortCut", "", "manager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "id", "", "shouldBeHiddenByShortCut$intellij_platform_ide_impl", "intellij.platform.ide.impl"})
    public static final class Companion {
        public final boolean shouldBeHiddenByShortCut$intellij_platform_ide_impl(@NotNull ToolWindowManager manager, @NotNull String id2) {
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            ToolWindow window = manager.getToolWindow(id2);
            return window != null && window.isVisible() && window.getType() != ToolWindowType.WINDOWED && window.getType() != ToolWindowType.FLOATING;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

