/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManager;
import com.intellij.ide.actions.searcheverywhere.statistics.SearchEverywhereUsageTriggerCollector;
import com.intellij.ide.util.gotoByName.ChooseByNameFilter;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNameModelEx;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.DefaultChooseByNameItemProvider;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GotoActionBase
extends AnAction {
    private static final Logger LOG = Logger.getInstance(GotoActionBase.class);
    protected static Class myInAction;
    private static final Map<Class, Pair<String, Integer>> ourLastStrings;
    private static final Map<Class, List<String>> ourHistory;
    private int myHistoryIndex;

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GotoActionBase.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(!((Object)((Object)this)).getClass().equals(myInAction), (Object)("Action should be disabled if it's already in progress: " + ((Object)((Object)this)).getClass()));
        try {
            myInAction = ((Object)((Object)this)).getClass();
            List<String> strings = ourHistory.get(myInAction);
            this.myHistoryIndex = strings == null || strings.size() <= 1 || !ourLastStrings.containsKey(myInAction) ? 0 : 1;
            this.gotoActionPerformed(e);
        }
        catch (ProcessCanceledException e1) {
            myInAction = null;
        }
        catch (Throwable t) {
            LOG.error(t);
            myInAction = null;
        }
    }

    protected abstract void gotoActionPerformed(@NotNull AnActionEvent var1);

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            GotoActionBase.$$$reportNull$$$0(1);
        }
        Presentation presentation2 = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        boolean hasContributors = this.hasContributors(dataContext);
        presentation2.setEnabled(!((Object)((Object)this)).getClass().equals(myInAction) && (!this.requiresProject() || project != null) && hasContributors);
        presentation2.setVisible(hasContributors);
    }

    protected boolean hasContributors(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            GotoActionBase.$$$reportNull$$$0(2);
        }
        return true;
    }

    protected boolean requiresProject() {
        return true;
    }

    @Nullable
    public static PsiElement getPsiContext(AnActionEvent e) {
        PsiFile file2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (file2 != null) {
            return file2;
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        return GotoActionBase.getPsiContext(project);
    }

    @Nullable
    public static PsiElement getPsiContext(Project project) {
        if (project == null) {
            return null;
        }
        Editor selectedEditor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (selectedEditor == null) {
            return null;
        }
        com.intellij.openapi.editor.Document document = selectedEditor.getDocument();
        return PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
    }

    protected static Pair<String, Integer> getInitialText(boolean useEditorSelection, AnActionEvent e) {
        Pair<String, Integer> lastString;
        SpeedSearchSupply supply;
        String selectedText;
        String predefined = (String)e.getData(PlatformDataKeys.PREDEFINED_TEXT);
        if (!StringUtil.isEmpty((String)predefined)) {
            return Pair.create((Object)predefined, (Object)0);
        }
        if (useEditorSelection && (selectedText = GotoActionBase.getInitialTextForNavigation(e)) != null) {
            return new Pair((Object)selectedText, (Object)0);
        }
        String query2 = (String)e.getData(SpeedSearchSupply.SPEED_SEARCH_CURRENT_QUERY);
        if (!StringUtil.isEmpty((String)query2)) {
            return Pair.create((Object)query2, (Object)0);
        }
        Component focusOwner = IdeFocusManager.getInstance((Project)GotoActionBase.getEventProject((AnActionEvent)e)).getFocusOwner();
        if (focusOwner instanceof JComponent && (supply = SpeedSearchSupply.getSupply((JComponent)((JComponent)focusOwner))) != null) {
            return Pair.create((Object)supply.getEnteredPrefix(), (Object)0);
        }
        if (myInAction != null && (lastString = ourLastStrings.get(myInAction)) != null) {
            return lastString;
        }
        return Pair.create((Object)"", (Object)0);
    }

    @Nullable
    public static String getInitialTextForNavigation(@NotNull AnActionEvent e) {
        Editor editor;
        String selectedText;
        if (e == null) {
            GotoActionBase.$$$reportNull$$$0(3);
        }
        String string = selectedText = (editor = (Editor)e.getData(CommonDataKeys.EDITOR)) != null ? editor.getSelectionModel().getSelectedText() : null;
        if (selectedText == null) {
            selectedText = (String)e.getData(JBTerminalWidget.SELECTED_TEXT_DATA_KEY);
        }
        return selectedText != null && !selectedText.contains("\n") ? selectedText : null;
    }

    protected <T> void showNavigationPopup(AnActionEvent e, ChooseByNameModel model2, GotoActionCallback<T> callback2) {
        this.showNavigationPopup(e, model2, callback2, true);
    }

    protected <T> void showNavigationPopup(AnActionEvent e, ChooseByNameModel model2, GotoActionCallback<T> callback2, boolean allowMultipleSelection) {
        this.showNavigationPopup(e, model2, callback2, null, true, allowMultipleSelection);
    }

    protected <T> void showNavigationPopup(AnActionEvent e, ChooseByNameModel model2, GotoActionCallback<T> callback2, @Nullable @Nls String findUsagesTitle, boolean useSelectionFromEditor) {
        this.showNavigationPopup(e, model2, callback2, findUsagesTitle, useSelectionFromEditor, true);
    }

    protected <T> void showNavigationPopup(AnActionEvent e, ChooseByNameModel model2, GotoActionCallback<T> callback2, @Nullable @Nls String findUsagesTitle, boolean useSelectionFromEditor, boolean allowMultipleSelection) {
        this.showNavigationPopup(e, model2, callback2, findUsagesTitle, useSelectionFromEditor, allowMultipleSelection, ChooseByNameModelEx.getItemProvider(model2, GotoActionBase.getPsiContext(e)));
    }

    @Deprecated
    protected <T> void showNavigationPopup(AnActionEvent e, ChooseByNameModel model2, GotoActionCallback<T> callback2, @Nullable @Nls String findUsagesTitle, boolean useSelectionFromEditor, boolean allowMultipleSelection, DefaultChooseByNameItemProvider itemProvider) {
        this.showNavigationPopup(e, model2, callback2, findUsagesTitle, useSelectionFromEditor, allowMultipleSelection, (ChooseByNameItemProvider)itemProvider);
    }

    protected <T> void showNavigationPopup(AnActionEvent e, ChooseByNameModel model2, GotoActionCallback<T> callback2, @Nullable @Nls String findUsagesTitle, boolean useSelectionFromEditor, boolean allowMultipleSelection, ChooseByNameItemProvider itemProvider) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        boolean mayRequestOpenInCurrentWindow = model2.willOpenEditor() && FileEditorManagerEx.getInstanceEx(project).hasSplitOrUndockedWindows();
        Pair<String, Integer> start2 = GotoActionBase.getInitialText(useSelectionFromEditor, e);
        ChooseByNamePopup popup2 = ChooseByNamePopup.createPopup(project, model2, itemProvider, (String)start2.first, mayRequestOpenInCurrentWindow, (int)((Integer)start2.second));
        this.showNavigationPopup(callback2, findUsagesTitle, popup2, allowMultipleSelection);
    }

    protected <T> void showNavigationPopup(GotoActionCallback<T> callback2, @Nullable @Nls String findUsagesTitle, ChooseByNamePopup popup2) {
        this.showNavigationPopup(callback2, findUsagesTitle, popup2, true);
    }

    protected <T> void showNavigationPopup(final GotoActionCallback<T> callback2, @Nullable @Nls String findUsagesTitle, final ChooseByNamePopup popup2, boolean allowMultipleSelection) {
        final Class startedAction = myInAction;
        LOG.assertTrue(startedAction != null);
        popup2.setCheckBoxShortcut(this.getShortcutSet());
        popup2.setFindUsagesTitle(findUsagesTitle);
        final ChooseByNameFilter<T> filter2 = callback2.createFilter(popup2);
        if (GotoActionBase.historyEnabled() && popup2.getAdText() == null) {
            popup2.setAdText(IdeBundle.message((String)"searcheverywhere.history.shortcuts.hint", (Object[])new Object[]{KeymapUtil.getKeystrokeText((KeyStroke)SearchTextField.ALT_SHOW_HISTORY_KEYSTROKE), KeymapUtil.getKeystrokeText((KeyStroke)SearchTextField.SHOW_HISTORY_KEYSTROKE)}));
        }
        popup2.invoke(new ChooseByNamePopupComponent.Callback(){

            public void onClose() {
                if (startedAction != null && startedAction.equals(myInAction)) {
                    String text2 = popup2.getEnteredText();
                    ourLastStrings.put(myInAction, (Pair<String, Integer>)Pair.create((Object)text2, (Object)popup2.getSelectedIndex()));
                    this.updateHistory(text2);
                    myInAction = null;
                }
                if (filter2 != null) {
                    filter2.close();
                }
            }

            private void updateHistory(@Nullable String text2) {
                if (!StringUtil.isEmptyOrSpaces((String)text2)) {
                    List<String> history = ourHistory.get(myInAction);
                    if (history == null) {
                        history = new ArrayList<String>();
                    }
                    if (!text2.equals(ContainerUtil.getFirstItem(history))) {
                        history.add(0, text2);
                    }
                    ourHistory.put(myInAction, history);
                }
            }

            public void elementChosen(Object element2) {
                callback2.elementChosen(popup2, element2);
            }
        }, ModalityState.current(), allowMultipleSelection);
        final JTextField editor = popup2.getTextField();
        final DocumentAdapter historyResetListener = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                GotoActionBase.this.myHistoryIndex = 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/GotoActionBase$2", "textChanged"));
            }
        };
        editor.getDocument().addDocumentListener((DocumentListener)historyResetListener);
        abstract class HistoryAction
        extends DumbAwareAction {
            final /* synthetic */ JTextField val$editor;
            final /* synthetic */ DocumentAdapter val$historyResetListener;

            HistoryAction() {
                this.val$editor = jTextField;
                this.val$historyResetListener = documentAdapter;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    HistoryAction.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(GotoActionBase.historyEnabled());
            }

            void setText(@NotNull List<String> strings) {
                String text2;
                if (strings == null) {
                    HistoryAction.$$$reportNull$$$0(1);
                }
                if (Objects.equals(text2 = strings.get(GotoActionBase.this.myHistoryIndex), this.val$editor.getText())) {
                    return;
                }
                Document document = this.val$editor.getDocument();
                document.removeDocumentListener((DocumentListener)this.val$historyResetListener);
                this.val$editor.setText(text2);
                document.addDocumentListener((DocumentListener)this.val$historyResetListener);
                this.val$editor.selectAll();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "strings";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/actions/GotoActionBase$1HistoryAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setText";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        new HistoryAction(){
            {
                super(GotoActionBase.this, jTextField, documentAdapter);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                List<String> strings = ourHistory.get(myInAction);
                this.setText(strings);
                GotoActionBase.this.myHistoryIndex = GotoActionBase.this.myHistoryIndex >= strings.size() - 1 ? 0 : GotoActionBase.this.myHistoryIndex + 1;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/GotoActionBase$3", "actionPerformed"));
            }
        }.registerCustomShortcutSet((ShortcutSet)SearchTextField.ALT_SHOW_HISTORY_SHORTCUT, editor);
        new HistoryAction(){
            {
                super(GotoActionBase.this, jTextField, documentAdapter);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                List<String> strings = ourHistory.get(myInAction);
                this.setText(strings);
                GotoActionBase.this.myHistoryIndex = GotoActionBase.this.myHistoryIndex <= 0 ? strings.size() - 1 : GotoActionBase.this.myHistoryIndex - 1;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/GotoActionBase$4", "actionPerformed"));
            }
        }.registerCustomShortcutSet((ShortcutSet)SearchTextField.SHOW_HISTORY_SHORTCUT, editor);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    protected void showInSearchEverywherePopup(@NotNull String tabID, @NotNull AnActionEvent event, boolean useEditorSelection, boolean sendStatistics) {
        if (tabID == null) {
            GotoActionBase.$$$reportNull$$$0(4);
        }
        if (event == null) {
            GotoActionBase.$$$reportNull$$$0(5);
        }
        Project project = event.getProject();
        SearchEverywhereManager seManager = SearchEverywhereManager.getInstance(project);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("SearchEverywhere");
        if (seManager.isShown()) {
            if (tabID.equals(seManager.getSelectedTabID())) {
                seManager.toggleEverywhereFilter();
            } else {
                seManager.setSelectedTabID(tabID);
                if (sendStatistics) {
                    FeatureUsageData data2 = SearchEverywhereUsageTriggerCollector.createData(tabID).addInputEvent(event);
                    SearchEverywhereUsageTriggerCollector.trigger(project, "tabSwitched", data2);
                }
            }
            return;
        }
        if (sendStatistics) {
            FeatureUsageData data3 = SearchEverywhereUsageTriggerCollector.createData(tabID).addInputEvent(event);
            SearchEverywhereUsageTriggerCollector.trigger(project, "dialogOpen", data3);
        }
        IdeEventQueue.getInstance().getPopupManager().closeAllPopups(false);
        String searchText = StringUtil.nullize((String)((String)GotoActionBase.getInitialText((boolean)useEditorSelection, (AnActionEvent)event).first));
        seManager.show(tabID, searchText, event);
    }

    private static boolean historyEnabled() {
        return !ContainerUtil.isEmpty((Collection)ourHistory.get(myInAction));
    }

    static {
        ourLastStrings = new HashMap<Class, Pair<String, Integer>>();
        ourHistory = new HashMap<Class, List<String>>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabID";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/GotoActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasContributors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getInitialTextForNavigation";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showInSearchEverywherePopup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static abstract class GotoActionCallback<T> {
        protected GotoActionCallback() {
        }

        @Nullable
        protected ChooseByNameFilter<T> createFilter(@NotNull ChooseByNamePopup popup2) {
            if (popup2 == null) {
                GotoActionCallback.$$$reportNull$$$0(0);
            }
            return null;
        }

        public abstract void elementChosen(ChooseByNamePopup var1, Object var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/ide/actions/GotoActionBase$GotoActionCallback", "createFilter"));
        }
    }
}

