/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ui.AppUIUtil;
import com.intellij.ui.ComponentUtil;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public final class ActiveWindowsWatcher {
    private static final LinkedHashSet<Window> activatedWindows = new LinkedHashSet();

    public static boolean isTheCurrentWindowOnTheActivatedList(Window w) {
        ActiveWindowsWatcher.updateActivatedWindowSet();
        return activatedWindows.contains(w);
    }

    public static void addActiveWindow(Window window) {
        activatedWindows.add(window);
        ActiveWindowsWatcher.updateActivatedWindowSet();
    }

    public static void updateActivatedWindowSet() {
        Iterator iter = activatedWindows.iterator();
        while (iter.hasNext()) {
            Window window = (Window)iter.next();
            if (!(!window.isFocusableWindow() || !window.isVisible() || ComponentUtil.isMinimized((Window)window) || AppUIUtil.isInFullscreen(window) || window instanceof Frame && ((Frame)window).isUndecorated() || window instanceof Dialog && ((Dialog)window).isUndecorated()) && (window instanceof Dialog || window instanceof Frame)) continue;
            iter.remove();
        }
    }

    public static Window nextWindowAfter(@NotNull Window w) {
        Window[] windows;
        if (w == null) {
            ActiveWindowsWatcher.$$$reportNull$$$0(0);
        }
        if (w.equals((windows = activatedWindows.toArray(new Window[0]))[windows.length - 1])) {
            return windows[0];
        }
        for (int i2 = windows.length - 2; i2 >= 0; --i2) {
            if (!w.equals(windows[i2])) continue;
            return windows[i2 + 1];
        }
        throw new IllegalArgumentException("The window after " + w.getName() + " has not been found");
    }

    public static Window nextWindowBefore(@NotNull Window w) {
        if (w == null) {
            ActiveWindowsWatcher.$$$reportNull$$$0(1);
        }
        assert (activatedWindows.contains(w));
        Window[] windows = activatedWindows.toArray(new Window[0]);
        if (w.equals(windows[0])) {
            return windows[windows.length - 1];
        }
        for (int i2 = 1; i2 < windows.length; ++i2) {
            if (!w.equals(windows[i2])) continue;
            return windows[i2 - 1];
        }
        throw new IllegalArgumentException("The window after " + w.getName() + " has not been found");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "w";
        objectArray2[1] = "com/intellij/ide/ActiveWindowsWatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "nextWindowAfter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "nextWindowBefore";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

