/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

public interface Printer {
    public void print(String var1, ConsoleViewContentType var2);

    public void onNewAvailable(@NotNull Printable var1);

    public void printHyperlink(String var1, HyperlinkInfo var2);

    public void mark();

    default public void printWithAnsiColoring(@NotNull String text2, @NotNull Key processOutputType) {
        if (text2 == null) {
            Printer.$$$reportNull$$$0(0);
        }
        if (processOutputType == null) {
            Printer.$$$reportNull$$$0(1);
        }
        if (processOutputType != ProcessOutputTypes.STDERR && processOutputType != ProcessOutputTypes.STDOUT && processOutputType != ProcessOutputTypes.SYSTEM) {
            this.print(text2, ConsoleViewContentType.getConsoleViewType((Key)processOutputType));
            return;
        }
        new AnsiEscapeDecoder().escapeText(text2, processOutputType, (text1, attributes) -> this.print(text1, ConsoleViewContentType.getConsoleViewType((Key)attributes)));
    }

    default public void printExpectedActualHeader(String expected, String actual) {
        Printer.printExpectedActualHeader(this, expected, actual);
    }

    public static void printExpectedActualHeader(Printer printer, String expected, String actual) {
        printer.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
        printer.print(ExecutionBundle.message((String)"diff.content.expected.for.file.title", (Object[])new Object[0]), ConsoleViewContentType.SYSTEM_OUTPUT);
        printer.print(expected + "\n", ConsoleViewContentType.ERROR_OUTPUT);
        printer.print(ExecutionBundle.message((String)"junit.actual.text.label", (Object[])new Object[0]), ConsoleViewContentType.SYSTEM_OUTPUT);
        printer.print(actual, ConsoleViewContentType.ERROR_OUTPUT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "processOutputType";
                break;
            }
        }
        objectArray[1] = "com/intellij/execution/testframework/Printer";
        objectArray[2] = "printWithAnsiColoring";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

