/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process.mediator.daemon;

import com.google.protobuf.ByteString;
import com.intellij.execution.process.mediator.daemon.DaemonClientCredentials;
import com.intellij.execution.process.mediator.daemon.DaemonLaunchOptions;
import com.intellij.execution.process.mediator.daemon.ExitCode;
import com.intellij.execution.process.mediator.daemon.ProcessMediatorDaemonMainKt;
import com.intellij.execution.process.mediator.daemon.ProcessMediatorDaemonRuntimeClasspath;
import com.intellij.execution.process.mediator.daemon.ProcessMediatorServerDaemon;
import com.intellij.execution.process.mediator.handshake.HandshakeFileWriter;
import com.intellij.execution.process.mediator.handshake.HandshakeSocketWriter;
import com.intellij.execution.process.mediator.handshake.HandshakeStreamWriter;
import com.intellij.execution.process.mediator.handshake.HandshakeWriter;
import com.intellij.execution.process.mediator.rpc.Handshake;
import com.intellij.execution.process.mediator.util.MachUtil;
import com.intellij.execution.process.mediator.util.RsaUtilKt;
import com.intellij.execution.process.mediator.util.UnixUtil;
import io.grpc.ServerBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a!\u0010\u0000\u001a\u00020\u00012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u0005\u001a\u0019\u0010\u0006\u001a\u00020\u00072\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\b\u001a\u0014\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0016\u0010\u0011\u001a\u00020\u0007*\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"createDaemonProcessCommandLine", "Ljava/lang/ProcessBuilder;", "args", "", "", "([Ljava/lang/String;)Ljava/lang/ProcessBuilder;", "main", "", "([Ljava/lang/String;)V", "openHandshakeWriter", "Lcom/intellij/execution/process/mediator/handshake/HandshakeWriter;", "handshakeOption", "Lcom/intellij/execution/process/mediator/daemon/DaemonLaunchOptions$HandshakeOption;", "trampoline", "", "launchOptions", "Lcom/intellij/execution/process/mediator/daemon/DaemonLaunchOptions;", "writeHandshake", "handshake", "Lcom/intellij/execution/process/mediator/rpc/Handshake;", "intellij.platform.elevation.daemon"})
public final class ProcessMediatorDaemonMainKt {
    /*
     * WARNING - void declaration
     */
    private static final ProcessBuilder createDaemonProcessCommandLine(String ... args) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        SpreadBuilder spreadBuilder = new SpreadBuilder(6);
        spreadBuilder.add((Object)(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java"));
        Map<String, String> map2 = ProcessMediatorDaemonRuntimeClasspath.getProperties();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"ProcessMediatorDaemonRun\u2026Classpath.getProperties()");
        Map<String, String> map3 = map2;
        SpreadBuilder spreadBuilder2 = spreadBuilder;
        SpreadBuilder spreadBuilder3 = spreadBuilder;
        boolean $i$f$map = false;
        void var3_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var6_8 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator2 = var6_8.entrySet().iterator();
        while (iterator2.hasNext()) {
            void k;
            void $dstr$k$v;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            collection = destination$iv$iv;
            boolean bl2 = false;
            void var12_14 = $dstr$k$v;
            boolean bl3 = false;
            String string = (String)var12_14.getKey();
            var12_14 = $dstr$k$v;
            bl3 = false;
            String v = (String)var12_14.getValue();
            String string2 = "-D" + (String)k + '=' + v;
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        SpreadBuilder spreadBuilder4 = spreadBuilder3;
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        spreadBuilder2.addSpread((Object)stringArray);
        spreadBuilder4.add((Object)"-cp");
        spreadBuilder4.add((Object)System.getProperty("java.class.path"));
        Class<?> clazz = ProcessMediatorDaemonRuntimeClasspath.getMainClass();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"ProcessMediatorDaemonRun\u2026eClasspath.getMainClass()");
        spreadBuilder4.add((Object)clazz.getName());
        spreadBuilder4.addSpread((Object)args);
        String[] stringArray2 = (String[])spreadBuilder4.toArray((Object[])new String[spreadBuilder4.size()]);
        return new ProcessBuilder(stringArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Void trampoline(DaemonLaunchOptions launchOptions) {
        Closeable closeable = ProcessMediatorDaemonMainKt.openHandshakeWriter(launchOptions.getHandshakeOption());
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            HandshakeWriter handshakeWriter = (HandshakeWriter)closeable;
            boolean bl3 = false;
            DaemonLaunchOptions daemonOptions = DaemonLaunchOptions.copy$default(launchOptions, false, false, null, null, DaemonLaunchOptions.HandshakeOption.Stdout.INSTANCE, null, 46, null);
            Collection $this$toTypedArray$iv = daemonOptions.asCmdlineArgs();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Process daemonProcess = ProcessMediatorDaemonMainKt.createDaemonProcessCommandLine(Arrays.copyOf(stringArray, stringArray.length)).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.INHERIT).start();
            System.err.println("[trampoline] Started daemon process PID " + daemonProcess.pid());
            daemonProcess.onExit().whenComplete((BiConsumer)trampoline.1.1.INSTANCE);
            try {
                Object object;
                Process process2 = daemonProcess;
                Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"daemonProcess");
                Closeable closeable2 = process2.getInputStream();
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    Object p1 = (InputStream)closeable2;
                    boolean bl6 = false;
                    p1 = Handshake.parseDelimitedFrom((InputStream)p1);
                    object = p1;
                }
                catch (Throwable p1) {
                    throwable2 = p1;
                    throw p1;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                if (object == null) {
                    throw (Throwable)new IOException("Premature EOF while reading handshake");
                }
                Object handshake2 = object;
                ProcessMediatorDaemonMainKt.writeHandshake(handshakeWriter, (Handshake)handshake2);
            }
            catch (Throwable e) {
                if (e instanceof IOException) {
                    System.err.println("[trampoline] Unable to relay handshake: " + e.getMessage());
                }
                Process process3 = daemonProcess;
                boolean bl7 = false;
                boolean bl8 = false;
                Process $this$run = process3;
                boolean bl9 = false;
                $this$run.waitFor(3L, TimeUnit.SECONDS);
                $this$run.destroy();
                boolean bl10 = false;
                try {
                    Object object = Result.Companion;
                    boolean bl11 = false;
                    Boolean bl12 = $this$run.waitFor(10L, TimeUnit.SECONDS);
                    boolean bl13 = false;
                    object = Result.constructor-impl((Object)bl12);
                }
                catch (Throwable throwable3) {
                    Result.Companion companion = Result.Companion;
                    boolean bl14 = false;
                    Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable3));
                }
                $this$run.destroyForcibly();
                throw e;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        int n = 0;
        bl = false;
        System.exit(n);
        throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private static final HandshakeWriter openHandshakeWriter(DaemonLaunchOptions.HandshakeOption handshakeOption) {
        HandshakeWriter handshakeWriter;
        DaemonLaunchOptions.HandshakeOption handshakeOption2 = handshakeOption;
        if (handshakeOption2 == null) {
            handshakeWriter = null;
        } else if (Intrinsics.areEqual((Object)handshakeOption2, (Object)DaemonLaunchOptions.HandshakeOption.Stdout.INSTANCE)) {
            PrintStream printStream = System.out;
            Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"System.out");
            handshakeWriter = new HandshakeStreamWriter(printStream);
        } else if (handshakeOption2 instanceof DaemonLaunchOptions.HandshakeOption.File) {
            handshakeWriter = new HandshakeFileWriter(((DaemonLaunchOptions.HandshakeOption.File)handshakeOption).getPath());
        } else if (handshakeOption2 instanceof DaemonLaunchOptions.HandshakeOption.Port) {
            handshakeWriter = new HandshakeSocketWriter(((DaemonLaunchOptions.HandshakeOption.Port)handshakeOption).getPort-Mh2AYeg(), null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return handshakeWriter;
    }

    private static final void writeHandshake(HandshakeWriter $this$writeHandshake, Handshake handshake2) {
        HandshakeWriter handshakeWriter = $this$writeHandshake;
        if (handshakeWriter != null) {
            handshakeWriter.write((Function1<? super OutputStream, Unit>)((Function1)new Function1<OutputStream, Unit>(handshake2){

                public final void invoke(OutputStream p1) {
                    ((Handshake)this.receiver).writeDelimitedTo(p1);
                }
            }));
        } else {
            boolean bl = false;
            System.out.println(handshake2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void main(@NotNull String[] args) {
        ProcessHandle leaderProcessHandle;
        ProcessHandle processHandle;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        DaemonLaunchOptions launchOptions = DaemonLaunchOptions.Companion.parseFromArgsOrDie("ProcessMediatorDaemonMain", args);
        Long l = launchOptions.getLeaderPid();
        if (l != null) {
            Long l2 = l;
            boolean bl2 = false;
            bl = false;
            long leaderPid = ((Number)l2).longValue();
            boolean bl3 = false;
            processHandle = ProcessHandle.of(leaderPid).orElse(null);
            if (processHandle == null) {
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = false;
                System.err.println("Leader process with PID " + leaderPid + " not found, exiting immediately");
                int n = ExitCode.LEADER_EXITED.ordinal();
                boolean bl7 = false;
                System.exit(n);
                throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        } else {
            processHandle = leaderProcessHandle = null;
        }
        if (launchOptions.getTrampoline()) {
            Void void_ = ProcessMediatorDaemonMainKt.trampoline(launchOptions);
            throw new KotlinNothingValueException();
        }
        if (UnixUtil.isUnix()) {
            UnixUtil.setup(launchOptions.getDaemonize());
            if (MachUtil.isMac()) {
                MachUtil.setup(launchOptions.getMachNamespaceUid());
            }
        }
        ProcessMediatorServerDaemon daemon = null;
        Closeable closeable = ProcessMediatorDaemonMainKt.openHandshakeWriter(launchOptions.getHandshakeOption());
        bl = false;
        boolean bl8 = false;
        Throwable throwable = null;
        try {
            HandshakeWriter handshakeWriter = (HandshakeWriter)closeable;
            boolean bl9 = false;
            CoroutineScope coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)EmptyCoroutineContext.INSTANCE));
            DaemonClientCredentials credentials = DaemonClientCredentials.Companion.generate$default(DaemonClientCredentials.Companion, 0, 1, null);
            ServerBuilder serverBuilder = ServerBuilder.forPort((int)0);
            Intrinsics.checkNotNullExpressionValue((Object)serverBuilder, (String)"ServerBuilder.forPort(0)");
            daemon = new ProcessMediatorServerDaemon(coroutineScope, serverBuilder, credentials);
            try {
                Handshake handshake2;
                PublicKey publicKey;
                ByteString bl6 = credentials.getToken();
                boolean bl10 = false;
                boolean bl11 = false;
                ByteString it = bl6;
                boolean bl12 = false;
                DaemonLaunchOptions.TokenEncryptionOption tokenEncryptionOption = launchOptions.getTokenEncryptionOption();
                PublicKey publicKey2 = publicKey = tokenEncryptionOption != null ? tokenEncryptionOption.getPublicKey() : null;
                ByteString token = publicKey == null ? it : RsaUtilKt.rsaEncrypt(publicKey, it);
                Handshake handshake3 = handshake2 = Handshake.newBuilder().setPort(daemon.getPort()).setToken(token).setPid(ProcessHandle.current().pid()).build();
                Intrinsics.checkNotNullExpressionValue((Object)handshake3, (String)"handshake");
                ProcessMediatorDaemonMainKt.writeHandshake(handshakeWriter, handshake3);
            }
            catch (Throwable e) {
                if (e instanceof IOException) {
                    System.err.println("Unable to write handshake: " + e.getMessage());
                }
                daemon.stop();
                throw e;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        if (launchOptions.getDaemonize()) {
            try {
                System.in.close();
            }
            catch (IOException e) {
                System.err.println("Unable to close daemon stdin: " + e.getMessage());
            }
            System.out.close();
            System.err.close();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(daemon){
            final /* synthetic */ ProcessMediatorServerDaemon $daemon;

            public final void run() {
                System.err.println("Shutting down gRPC server since JVM is shutting down");
                this.$daemon.stop();
            }
            {
                this.$daemon = processMediatorServerDaemon;
            }
        }));
        Object object = leaderProcessHandle;
        if (object != null && (object = object.onExit()) != null) {
            ((CompletableFuture)object).whenComplete((BiConsumer)main.3.INSTANCE);
        }
        daemon.blockUntilShutdown();
    }
}

