/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.impl;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.ui.WindowWrapperBuilder;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffWindowBase {
    @Nullable
    protected final Project myProject;
    @NotNull
    protected final DiffDialogHints myHints;
    private DiffRequestProcessor myProcessor;
    private WindowWrapper myWrapper;

    public DiffWindowBase(@Nullable Project project, @NotNull DiffDialogHints hints2) {
        if (hints2 == null) {
            DiffWindowBase.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myHints = hints2;
    }

    protected void init() {
        if (this.myWrapper != null) {
            return;
        }
        this.myProcessor = this.createProcessor();
        String dialogGroupKey = (String)this.myProcessor.getContextUserData(DiffUserDataKeys.DIALOG_GROUP_KEY);
        if (dialogGroupKey == null) {
            dialogGroupKey = "DiffContextDialog";
        }
        this.myWrapper = new WindowWrapperBuilder(DiffUtil.getWindowMode(this.myHints), new MyPanel(this.myProcessor.getComponent())).setProject(this.myProject).setParent(this.myHints.getParent()).setDimensionServiceKey(dialogGroupKey).setPreferredFocusedComponent((Computable<JComponent>)((Computable)() -> this.myProcessor.getPreferredFocusedComponent())).setOnShowCallback(() -> this.myProcessor.updateRequest()).build();
        this.myWrapper.setImages((List)DiffUtil.DIFF_FRAME_ICONS.getValue());
        Disposer.register((Disposable)this.myWrapper, (Disposable)this.myProcessor);
        Consumer wrapperHandler = this.myHints.getWindowConsumer();
        if (wrapperHandler != null) {
            wrapperHandler.consume((Object)this.myWrapper);
        }
    }

    public void show() {
        this.init();
        this.myWrapper.show();
    }

    @NotNull
    protected abstract DiffRequestProcessor createProcessor();

    protected WindowWrapper getWrapper() {
        return this.myWrapper;
    }

    protected DiffRequestProcessor getProcessor() {
        return this.myProcessor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hints", "com/intellij/diff/impl/DiffWindowBase", "<init>"));
    }

    private static class MyPanel
    extends JPanel {
        MyPanel(@NotNull JComponent content2) {
            if (content2 == null) {
                MyPanel.$$$reportNull$$$0(0);
            }
            super(new BorderLayout());
            this.add((Component)content2, "Center");
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension windowSize = DiffUtil.getDefaultDiffWindowSize();
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(windowSize.width, size.width), Math.max(windowSize.height, size.height));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/impl/DiffWindowBase$MyPanel", "<init>"));
        }
    }
}

