/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.impl;

import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.diff.chains.AsyncDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.impl.CacheDiffRequestProcessor;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.Consumer;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CacheDiffRequestChainProcessor
extends CacheDiffRequestProcessor.Simple {
    @NotNull
    private final DiffRequestChain myRequestChain;
    private int myIndex;

    public CacheDiffRequestChainProcessor(@Nullable Project project, @NotNull DiffRequestChain requestChain) {
        if (requestChain == null) {
            CacheDiffRequestChainProcessor.$$$reportNull$$$0(0);
        }
        super(project, (UserDataHolder)requestChain);
        this.myRequestChain = requestChain;
        if (this.myRequestChain instanceof AsyncDiffRequestChain) {
            ((AsyncDiffRequestChain)this.myRequestChain).onAssigned(true);
            ((AsyncDiffRequestChain)this.myRequestChain).addListener(new MyChangeListener(), this);
        }
        this.myIndex = this.myRequestChain.getIndex();
    }

    @Override
    protected void onDispose() {
        if (this.myRequestChain instanceof AsyncDiffRequestChain) {
            ((AsyncDiffRequestChain)this.myRequestChain).onAssigned(false);
        }
        super.onDispose();
    }

    @Override
    protected DiffRequestProducer getCurrentRequestProvider() {
        List requests2 = this.myRequestChain.getRequests();
        if (this.myIndex < 0 || this.myIndex >= requests2.size()) {
            return null;
        }
        return (DiffRequestProducer)requests2.get(this.myIndex);
    }

    @NotNull
    public DiffRequestChain getRequestChain() {
        DiffRequestChain diffRequestChain = this.myRequestChain;
        if (diffRequestChain == null) {
            CacheDiffRequestChainProcessor.$$$reportNull$$$0(1);
        }
        return diffRequestChain;
    }

    public void setCurrentRequest(int index) {
        this.myIndex = index;
        this.updateRequest();
    }

    @Override
    @NotNull
    protected List<AnAction> getNavigationActions() {
        List<AnAction> list2 = Arrays.asList(new AnAction[]{new DiffRequestProcessor.MyPrevDifferenceAction(this), new DiffRequestProcessor.MyNextDifferenceAction(this), new DiffRequestProcessor.MyOpenInEditorAction(this), Separator.getInstance(), new DiffRequestProcessor.MyPrevChangeAction(this), new DiffRequestProcessor.MyNextChangeAction(this), this.createGoToChangeAction()});
        if (list2 == null) {
            CacheDiffRequestChainProcessor.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Override
    protected boolean hasNextChange(boolean fromUpdate) {
        return this.myIndex < this.myRequestChain.getRequests().size() - 1;
    }

    @Override
    protected boolean hasPrevChange(boolean fromUpdate) {
        return this.myIndex > 0;
    }

    @Override
    protected void goToNextChange(boolean fromDifferences) {
        ++this.myIndex;
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE : null);
    }

    @Override
    protected void goToPrevChange(boolean fromDifferences) {
        --this.myIndex;
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.LAST_CHANGE : null);
    }

    @Override
    protected boolean isNavigationEnabled() {
        return this.myRequestChain.getRequests().size() > 1;
    }

    @NotNull
    private AnAction createGoToChangeAction() {
        AnAction action2 = GoToChangePopupBuilder.create(this.myRequestChain, (Consumer<? super Integer>)((Consumer)index -> {
            if (index >= 0 && index < this.myRequestChain.getRequests().size() && index != this.myIndex) {
                this.setCurrentRequest((int)index);
            }
        }), this.myIndex);
        if (DiffUtil.isUserDataFlagSet(DiffUserDataKeysEx.DIFF_IN_EDITOR, new UserDataHolder[]{this.getContext()})) {
            CacheDiffRequestChainProcessor.patchShortcutSet(action2, "GotoClass", null);
        }
        AnAction anAction = action2;
        if (anAction == null) {
            CacheDiffRequestChainProcessor.$$$reportNull$$$0(3);
        }
        return anAction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestChain";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/impl/CacheDiffRequestChainProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/impl/CacheDiffRequestChainProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestChain";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createGoToChangeAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyChangeListener
    implements AsyncDiffRequestChain.Listener {
        private MyChangeListener() {
        }

        @Override
        public void onRequestsLoaded() {
            CacheDiffRequestChainProcessor.this.dropCaches();
            CacheDiffRequestChainProcessor.this.myIndex = CacheDiffRequestChainProcessor.this.myRequestChain.getIndex();
            CacheDiffRequestChainProcessor.this.updateRequest(true);
        }
    }
}

