/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.editor;

import com.intellij.diff.editor.DiffVirtualFile;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.FileEditorBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/diff/editor/DiffRequestProcessorEditor;", "Lcom/intellij/diff/util/FileEditorBase;", "file", "Lcom/intellij/diff/editor/DiffVirtualFile;", "processor", "Lcom/intellij/diff/impl/DiffRequestProcessor;", "(Lcom/intellij/diff/editor/DiffVirtualFile;Lcom/intellij/diff/impl/DiffRequestProcessor;)V", "getProcessor", "()Lcom/intellij/diff/impl/DiffRequestProcessor;", "dispose", "", "getComponent", "Ljavax/swing/JComponent;", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getName", "", "getPreferredFocusedComponent", "isValid", "", "selectNotify", "intellij.platform.diff.impl"})
public class DiffRequestProcessorEditor
extends FileEditorBase {
    private final DiffVirtualFile file;
    @NotNull
    private final DiffRequestProcessor processor;

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.processor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"processor.component");
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.processor.getPreferredFocusedComponent();
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isValid() {
        return !this.processor.isDisposed();
    }

    @NotNull
    public VirtualFile getFile() {
        return (VirtualFile)this.file;
    }

    @NotNull
    public String getName() {
        String string = DiffBundle.message((String)"diff.file.editor.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DiffBundle.message(\"diff.file.editor.name\")");
        return string;
    }

    @Override
    public void selectNotify() {
        this.processor.updateRequest();
    }

    @NotNull
    public final DiffRequestProcessor getProcessor() {
        return this.processor;
    }

    public DiffRequestProcessorEditor(@NotNull DiffVirtualFile file2, @NotNull DiffRequestProcessor processor2) {
        Intrinsics.checkNotNullParameter((Object)((Object)file2), (String)"file");
        Intrinsics.checkNotNullParameter((Object)processor2, (String)"processor");
        this.file = file2;
        this.processor = processor2;
        if (!DiffUtil.isUserDataFlagSet(DiffUserDataKeysEx.DIFF_IN_EDITOR_WITH_EXPLICIT_DISPOSABLE, (UserDataHolder)this.processor.getContext())) {
            Disposer.register((Disposable)((Disposable)this), (Disposable)new Disposable(){

                public final void dispose() {
                    Disposer.dispose((Disposable)this.getProcessor());
                }
            });
        }
        Disposer.register((Disposable)this.processor, (Disposable)new Disposable(){

            public final void dispose() {
                this.getPropertyChangeSupport().firePropertyChange("valid", true, false);
            }
        });
        this.processor.getComponent().registerKeyboardAction(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                Disposer.dispose((Disposable)((Disposable)this));
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }
}

