/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.ui;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.EventWatcher;
import com.intellij.diagnostic.RunnablesListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SortOrder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class EventWatcherToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            EventWatcherToolWindowFactory.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            EventWatcherToolWindowFactory.$$$reportNull$$$0(1);
        }
        TableProvidingListener listener2 = new TableProvidingListener();
        project.getMessageBus().connect((Disposable)project).subscribe(TableProvidingListener.TOPIC, (Object)listener2);
        listener2.getContents().forEach(arg_0 -> ((ContentManager)toolWindow.getContentManager()).addContent(arg_0));
    }

    public void init(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            EventWatcherToolWindowFactory.$$$reportNull$$$0(2);
        }
        toolWindow.setStripeTitle(DiagnosticBundle.message("tab.title.event.watcher", new Object[0]));
    }

    public boolean isApplicable(@NotNull Project project) {
        if (project == null) {
            EventWatcherToolWindowFactory.$$$reportNull$$$0(3);
        }
        return EventWatcher.isEnabled();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagnostic/ui/EventWatcherToolWindowFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createToolWindowContent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TableProvidingListener
    implements RunnablesListener {
        @NotNull
        private final ListTableModel<RunnablesListener.InvocationsInfo> myInvocationsModel = new ListTableModel(new ColumnInfo[]{FunctionBasedColumnInfo.stringBased(DiagnosticBundle.message("event.watcher.column.name.runnable.callable", new Object[0]), RunnablesListener.InvocationsInfo::getFQN), new FunctionBasedColumnInfo<RunnablesListener.InvocationsInfo, Double>(DiagnosticBundle.message("event.watcher.column.name.average.duration.ms", new Object[0]), Double.TYPE, RunnablesListener.InvocationsInfo::getAverageDuration), new FunctionBasedColumnInfo<RunnablesListener.InvocationsInfo, Integer>(DiagnosticBundle.message("event.watcher.column.name.count", new Object[0]), Integer.TYPE, RunnablesListener.InvocationsInfo::getCount)}, new ArrayList(), 1, SortOrder.DESCENDING);
        @NotNull
        private final ListTableModel<RunnablesListener.InvocationDescription> myRunnablesModel = new ListTableModel(new ColumnInfo[]{FunctionBasedColumnInfo.stringBased(DiagnosticBundle.message("event.watcher.column.name.runnable", new Object[0]), RunnablesListener.InvocationDescription::getProcessId), new FunctionBasedColumnInfo<RunnablesListener.InvocationDescription, Long>(DiagnosticBundle.message("event.watcher.column.name.duration.ms", new Object[0]), Long.TYPE, RunnablesListener.InvocationDescription::getDuration), new FunctionBasedColumnInfo<RunnablesListener.InvocationDescription, String>(DiagnosticBundle.message("event.watcher.column.name.started.at", new Object[0]), String.class, description -> new SimpleDateFormat().format(new Date(description.getStartedAt())), Comparator.comparingLong(RunnablesListener.InvocationDescription::getStartedAt))});
        @NotNull
        private final ListTableModel<RunnablesListener.WrapperDescription> myWrappersModel = new ListTableModel(new ColumnInfo[]{FunctionBasedColumnInfo.stringBased(DiagnosticBundle.message("event.watcher.column.name.runnable.callable", new Object[0]), RunnablesListener.WrapperDescription::getFQN), new FunctionBasedColumnInfo<RunnablesListener.WrapperDescription, Integer>(DiagnosticBundle.message("event.watcher.column.name.usages.count", new Object[0]), Integer.TYPE, RunnablesListener.WrapperDescription::getUsagesCount)});
        @NotNull
        private final ListTableModel<RunnablesListener.LockAcquirementDescription> myAcquirementsModel = new ListTableModel(new ColumnInfo[]{FunctionBasedColumnInfo.stringBased(DiagnosticBundle.message("event.watcher.column.name.runnable", new Object[0]), RunnablesListener.LockAcquirementDescription::getFQN), new FunctionBasedColumnInfo<RunnablesListener.LockAcquirementDescription, Long>(DiagnosticBundle.message("event.watcher.column.name.reads", new Object[0]), Long.TYPE, RunnablesListener.LockAcquirementDescription::getReads), new FunctionBasedColumnInfo<RunnablesListener.LockAcquirementDescription, Long>(DiagnosticBundle.message("event.watcher.column.name.writes", new Object[0]), Long.TYPE, RunnablesListener.LockAcquirementDescription::getWrites), new FunctionBasedColumnInfo<RunnablesListener.LockAcquirementDescription, Long>(DiagnosticBundle.message("event.watcher.column.name.write.intents", new Object[0]), Long.TYPE, RunnablesListener.LockAcquirementDescription::getWriteIntents)});
        @NotNull
        private final List<Content> myContents = Arrays.asList(TableProvidingListener.createTableContent(DiagnosticBundle.message("event.watcher.tab.title.invocations", new Object[0]), this.myInvocationsModel), TableProvidingListener.createTableContent(DiagnosticBundle.message("event.watcher.tab.title.runnables", new Object[0]), this.myRunnablesModel), TableProvidingListener.createTableContent(DiagnosticBundle.message("event.watcher.tab.title.wrappers", new Object[0]), this.myWrappersModel), TableProvidingListener.createTableContent(DiagnosticBundle.message("event.watcher.tab.title.locks", new Object[0]), this.myAcquirementsModel));

        TableProvidingListener() {
        }

        @Override
        public void runnablesProcessed(@NotNull Collection<RunnablesListener.InvocationDescription> invocations, @NotNull Collection<RunnablesListener.InvocationsInfo> infos, @NotNull Collection<RunnablesListener.WrapperDescription> wrappers) {
            if (invocations == null) {
                TableProvidingListener.$$$reportNull$$$0(0);
            }
            if (infos == null) {
                TableProvidingListener.$$$reportNull$$$0(1);
            }
            if (wrappers == null) {
                TableProvidingListener.$$$reportNull$$$0(2);
            }
            this.myRunnablesModel.addRows(invocations);
            this.myInvocationsModel.setItems(new ArrayList<RunnablesListener.InvocationsInfo>(infos));
            this.myWrappersModel.setItems(new ArrayList<RunnablesListener.WrapperDescription>(wrappers));
        }

        @Override
        public void locksAcquired(@NotNull Collection<RunnablesListener.LockAcquirementDescription> acquirements) {
            if (acquirements == null) {
                TableProvidingListener.$$$reportNull$$$0(3);
            }
            this.myAcquirementsModel.setItems(new ArrayList<RunnablesListener.LockAcquirementDescription>(acquirements));
        }

        @NotNull
        List<Content> getContents() {
            List<Content> list2 = this.myContents;
            if (list2 == null) {
                TableProvidingListener.$$$reportNull$$$0(4);
            }
            return list2;
        }

        @NotNull
        private static Content createTableContent(@NotNull @NlsContexts.TabTitle String tableName, @NotNull ListTableModel<?> tableModel) {
            if (tableName == null) {
                TableProvidingListener.$$$reportNull$$$0(5);
            }
            if (tableModel == null) {
                TableProvidingListener.$$$reportNull$$$0(6);
            }
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)new JBScrollPane((Component)new TableView(tableModel)), "Center");
            Content content2 = ContentFactory.SERVICE.getInstance().createContent((JComponent)panel2, tableName, false);
            if (content2 == null) {
                TableProvidingListener.$$$reportNull$$$0(7);
            }
            return content2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "invocations";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infos";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrappers";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "acquirements";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diagnostic/ui/EventWatcherToolWindowFactory$TableProvidingListener";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tableName";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tableModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diagnostic/ui/EventWatcherToolWindowFactory$TableProvidingListener";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContents";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTableContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "runnablesProcessed";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "locksAcquired";
                    break;
                }
                case 4: 
                case 7: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createTableContent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static final class FunctionBasedColumnInfo<Item extends Comparable<? super Item>, Aspect extends Comparable<? super Aspect>>
        extends ColumnInfo<Item, Aspect> {
            @NotNull
            private final Class<? extends Aspect> myColumnClass;
            @NotNull
            private final Function<? super Item, ? extends Aspect> myExtractor;
            @NotNull
            private final Comparator<Item> myComparator;

            private FunctionBasedColumnInfo(@NotNull @Nls String name, @NotNull Class<? extends Aspect> columnClass, @NotNull Function<? super Item, ? extends Aspect> extractor, @NotNull Comparator<Item> comparator2) {
                if (name == null) {
                    FunctionBasedColumnInfo.$$$reportNull$$$0(0);
                }
                if (columnClass == null) {
                    FunctionBasedColumnInfo.$$$reportNull$$$0(1);
                }
                if (extractor == null) {
                    FunctionBasedColumnInfo.$$$reportNull$$$0(2);
                }
                if (comparator2 == null) {
                    FunctionBasedColumnInfo.$$$reportNull$$$0(3);
                }
                super(name);
                this.myColumnClass = columnClass;
                this.myExtractor = extractor;
                this.myComparator = comparator2;
            }

            private FunctionBasedColumnInfo(@NotNull @Nls String name, @NotNull Class<? extends Aspect> columnClass, @NotNull Function<? super Item, ? extends Aspect> extractor) {
                if (name == null) {
                    FunctionBasedColumnInfo.$$$reportNull$$$0(4);
                }
                if (columnClass == null) {
                    FunctionBasedColumnInfo.$$$reportNull$$$0(5);
                }
                if (extractor == null) {
                    FunctionBasedColumnInfo.$$$reportNull$$$0(6);
                }
                this(name, columnClass, extractor, Comparator.comparing(extractor));
            }

            @Nullable
            public final Aspect valueOf(@NotNull Item item) {
                if (item == null) {
                    FunctionBasedColumnInfo.$$$reportNull$$$0(7);
                }
                return (Aspect)((Comparable)this.myExtractor.apply(item));
            }

            @NotNull
            public final Class<? extends Aspect> getColumnClass() {
                Class<? extends Aspect> clazz = this.myColumnClass;
                if (clazz == null) {
                    FunctionBasedColumnInfo.$$$reportNull$$$0(8);
                }
                return clazz;
            }

            @NotNull
            public final Comparator<Item> getComparator() {
                Comparator<Item> comparator2 = this.myComparator;
                if (comparator2 == null) {
                    FunctionBasedColumnInfo.$$$reportNull$$$0(9);
                }
                return comparator2;
            }

            private static <Item extends Comparable<? super Item>> FunctionBasedColumnInfo<Item, String> stringBased(@NotNull @NlsContexts.ColumnName String name, @NotNull Function<? super Item, String> extractor) {
                if (name == null) {
                    FunctionBasedColumnInfo.$$$reportNull$$$0(10);
                }
                if (extractor == null) {
                    FunctionBasedColumnInfo.$$$reportNull$$$0(11);
                }
                return new FunctionBasedColumnInfo<Item, String>(name, String.class, extractor, Comparator.naturalOrder());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 8: 
                    case 9: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 8: 
                    case 9: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "columnClass";
                        break;
                    }
                    case 2: 
                    case 6: 
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extractor";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "comparator";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                    case 8: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/diagnostic/ui/EventWatcherToolWindowFactory$TableProvidingListener$FunctionBasedColumnInfo";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/diagnostic/ui/EventWatcherToolWindowFactory$TableProvidingListener$FunctionBasedColumnInfo";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getColumnClass";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getComparator";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "valueOf";
                        break;
                    }
                    case 8: 
                    case 9: {
                        break;
                    }
                    case 10: 
                    case 11: {
                        objectArray = objectArray;
                        objectArray[2] = "stringBased";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 8: 
                    case 9: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

