/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.RunManagerSettings;
import com.intellij.conversion.impl.ConversionContextImpl;
import com.intellij.conversion.impl.MultiFilesSettings;
import com.intellij.conversion.impl.SettingsXmlFile;
import com.intellij.openapi.util.JDOMUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RunManagerSettingsImpl
implements RunManagerSettings {
    private static final String RUN_MANAGER_COMPONENT_NAME = "RunManager";
    private static final String CONFIGURATION_ELEMENT = "configuration";
    private final SettingsXmlFile myWorkspaceFile;
    @Nullable
    private final SettingsXmlFile myProjectFile;
    private final Path dir;
    private final ConversionContextImpl context;
    @Nullable
    private List<Path> sharedConfigurationFiles;

    RunManagerSettingsImpl(@NotNull SettingsXmlFile workspaceFile, @Nullable SettingsXmlFile projectFile, @Nullable Path dir, @NotNull ConversionContextImpl context) throws CannotConvertException {
        if (workspaceFile == null) {
            RunManagerSettingsImpl.$$$reportNull$$$0(0);
        }
        if (context == null) {
            RunManagerSettingsImpl.$$$reportNull$$$0(1);
        }
        this.myWorkspaceFile = workspaceFile;
        this.myProjectFile = projectFile;
        this.dir = dir;
        this.context = context;
    }

    @NotNull
    private List<Path> getSharedConfigurationFiles() {
        if (this.sharedConfigurationFiles == null) {
            this.sharedConfigurationFiles = this.dir == null ? Collections.emptyList() : MultiFilesSettings.getSettingsXmlFiles(this.dir);
        }
        List<Path> list2 = this.sharedConfigurationFiles;
        if (list2 == null) {
            RunManagerSettingsImpl.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    public Collection<Element> getRunConfigurations() {
        ArrayList<Element> result2 = new ArrayList<Element>();
        result2.addAll(JDOMUtil.getChildren((Element)this.myWorkspaceFile.findComponent(RUN_MANAGER_COMPONENT_NAME), (String)CONFIGURATION_ELEMENT));
        if (this.myProjectFile != null) {
            result2.addAll(JDOMUtil.getChildren((Element)this.myProjectFile.findComponent("ProjectRunConfigurationManager"), (String)CONFIGURATION_ELEMENT));
        }
        for (Path file2 : this.getSharedConfigurationFiles()) {
            result2.addAll(JDOMUtil.getChildren((Element)this.context.getOrCreateFile(file2).getRootElement(), (String)CONFIGURATION_ELEMENT));
        }
        ArrayList<Element> arrayList = result2;
        if (arrayList == null) {
            RunManagerSettingsImpl.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public void collectAffectedFiles(@NotNull Collection<Path> files2) {
        if (files2 == null) {
            RunManagerSettingsImpl.$$$reportNull$$$0(4);
        }
        files2.add(this.myWorkspaceFile.getFile());
        if (this.myProjectFile != null) {
            files2.add(this.myProjectFile.getFile());
        }
        files2.addAll(this.getSharedConfigurationFiles());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspaceFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/conversion/impl/RunManagerSettingsImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/conversion/impl/RunManagerSettingsImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedConfigurationFiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectAffectedFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

