/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.naming;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.naming.NamingConventionBean;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiNameIdentifierOwner;
import org.jetbrains.annotations.NonNls;

public abstract class NamingConvention<T extends PsiNameIdentifierOwner> {
    public abstract boolean isApplicable(T var1);

    @NlsContexts.Checkbox
    public abstract String getElementDescription();

    @NonNls
    public abstract String getShortName();

    public abstract NamingConventionBean createDefaultBean();

    public boolean isEnabledByDefault() {
        return false;
    }

    @InspectionMessage
    public String createErrorMessage(String name, NamingConventionBean bean) {
        int length = name.length();
        if (length < bean.m_minLength) {
            return InspectionsBundle.message((String)"naming.convention.problem.descriptor.short", (Object[])new Object[]{this.getElementDescription(), length, bean.m_minLength});
        }
        if (bean.m_maxLength > 0 && length > bean.m_maxLength) {
            return InspectionsBundle.message((String)"naming.convention.problem.descriptor.long", (Object[])new Object[]{this.getElementDescription(), length, bean.m_maxLength});
        }
        return InspectionsBundle.message((String)"naming.convention.problem.descriptor.regex.mismatch", (Object[])new Object[]{this.getElementDescription(), bean.m_regex});
    }

    public boolean isValid(T member, NamingConventionBean bean) {
        String name = member.getName();
        return name != null && bean.isValid(name);
    }
}

