/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.macro.MacroBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.NameUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertToCamelCaseMacro
extends MacroBase {
    public ConvertToCamelCaseMacro() {
        super("camelCase", "camelCase(String)");
    }

    private ConvertToCamelCaseMacro(String name, String description) {
        super(name, description);
    }

    @Override
    @Nullable
    protected Result calculateResult(Expression @NotNull [] params, ExpressionContext context, boolean quick) {
        String text2;
        if (params == null) {
            ConvertToCamelCaseMacro.$$$reportNull$$$0(0);
        }
        return (text2 = ConvertToCamelCaseMacro.getTextResult(params, context, true)) != null ? this.convertString(text2) : null;
    }

    @NotNull
    @VisibleForTesting
    public Result convertString(@NotNull String text2) {
        String[] strings;
        if (text2 == null) {
            ConvertToCamelCaseMacro.$$$reportNull$$$0(1);
        }
        if ((strings = this.splitWords(text2)).length > 0) {
            StringBuilder buf = new StringBuilder();
            buf.append(StringUtil.toLowerCase((String)strings[0]));
            for (int i2 = 1; i2 < strings.length; ++i2) {
                String string = strings[i2];
                if (!Character.isLetterOrDigit(string.charAt(0))) continue;
                buf.append(StringUtil.capitalize((String)StringUtil.toLowerCase((String)string)));
            }
            return new TextResult(buf.toString());
        }
        return new TextResult("");
    }

    protected String @NotNull [] splitWords(String text2) {
        String[] stringArray = NameUtilCore.nameToWords((String)text2);
        if (stringArray == null) {
            ConvertToCamelCaseMacro.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/macro/ConvertToCamelCaseMacro";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/macro/ConvertToCamelCaseMacro";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "splitWords";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculateResult";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "convertString";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ReplaceUnderscoresToCamelCaseMacro
    extends ConvertToCamelCaseMacro {
        public ReplaceUnderscoresToCamelCaseMacro() {
            super("underscoresToCamelCase", CodeInsightBundle.message((String)"macro.underscoresToCamelCase.string", (Object[])new Object[0]));
        }

        @Override
        protected String @NotNull [] splitWords(String text2) {
            String[] stringArray = text2.split("_");
            if (stringArray == null) {
                ReplaceUnderscoresToCamelCaseMacro.$$$reportNull$$$0(0);
            }
            return stringArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/macro/ConvertToCamelCaseMacro$ReplaceUnderscoresToCamelCaseMacro", "splitWords"));
        }
    }
}

