/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.presentation;

import com.intellij.codeInsight.hints.InlayPresentationFactory;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationUtilKt;
import com.intellij.codeInsight.hints.presentation.StaticDelegatePresentation;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ8\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u001e0'H\u0002J\u0018\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u000eH\u0002J\u0018\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020%H\u0016J\b\u0010/\u001a\u00020\u001eH\u0016J\u0018\u00100\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020%H\u0016J\u0018\u00101\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u00102\u001a\u000203H\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0010R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0010R\u0014\u0010\u001b\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0010\u00a8\u00064"}, d2={"Lcom/intellij/codeInsight/hints/presentation/ContainerInlayPresentation;", "Lcom/intellij/codeInsight/hints/presentation/StaticDelegatePresentation;", "presentation", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "padding", "Lcom/intellij/codeInsight/hints/InlayPresentationFactory$Padding;", "roundedCorners", "Lcom/intellij/codeInsight/hints/InlayPresentationFactory$RoundedCorners;", "background", "Ljava/awt/Color;", "backgroundAlpha", "", "(Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;Lcom/intellij/codeInsight/hints/InlayPresentationFactory$Padding;Lcom/intellij/codeInsight/hints/InlayPresentationFactory$RoundedCorners;Ljava/awt/Color;F)V", "bottomInset", "", "getBottomInset", "()I", "height", "getHeight", "leftInset", "getLeftInset", "presentationIsUnderCursor", "", "rightInset", "getRightInset", "topInset", "getTopInset", "width", "getWidth", "fillRoundedRectangle", "", "g", "Ljava/awt/Graphics2D;", "arcWidth", "arcHeight", "handleMouse", "original", "Ljava/awt/Point;", "action", "Lkotlin/Function1;", "isInInnerBounds", "x", "y", "mouseClicked", "event", "Ljava/awt/event/MouseEvent;", "translated", "mouseExited", "mouseMoved", "paint", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "intellij.platform.lang.impl"})
@ApiStatus.Experimental
public final class ContainerInlayPresentation
extends StaticDelegatePresentation {
    private boolean presentationIsUnderCursor;
    private final InlayPresentationFactory.Padding padding;
    private final InlayPresentationFactory.RoundedCorners roundedCorners;
    private final Color background;
    private final float backgroundAlpha;

    @Override
    public int getWidth() {
        return this.getLeftInset() + this.getPresentation().getWidth() + this.getRightInset();
    }

    @Override
    public int getHeight() {
        return this.getTopInset() + this.getPresentation().getHeight() + this.getBottomInset();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void paint(@NotNull Graphics2D g, @NotNull TextAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        if (this.background != null) {
            Color preservedBackground = g.getBackground();
            g.setColor(this.background);
            if (this.roundedCorners != null) {
                void arcWidth;
                InlayPresentationFactory.RoundedCorners roundedCorners = this.roundedCorners;
                int n = roundedCorners.component1();
                int arcHeight = roundedCorners.component2();
                this.fillRoundedRectangle(g, this.getHeight(), this.getWidth(), (int)arcWidth, arcHeight, this.backgroundAlpha);
            } else {
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            g.setColor(preservedBackground);
        }
        PresentationUtilKt.withTranslated(g, this.getLeftInset(), this.getTopInset(), (Function0<Unit>)((Function0)new Function0<Unit>(this, g, attributes){
            final /* synthetic */ ContainerInlayPresentation this$0;
            final /* synthetic */ Graphics2D $g;
            final /* synthetic */ TextAttributes $attributes;

            public final void invoke() {
                this.this$0.getPresentation().paint(this.$g, this.$attributes);
            }
            {
                this.this$0 = containerInlayPresentation;
                this.$g = graphics2D;
                this.$attributes = textAttributes;
                super(0);
            }
        }));
    }

    @Override
    public void mouseClicked(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        this.handleMouse(translated, (Function1<? super Point, Unit>)((Function1)new Function1<Point, Unit>(this, event){
            final /* synthetic */ ContainerInlayPresentation this$0;
            final /* synthetic */ MouseEvent $event;

            public final void invoke(@NotNull Point point) {
                Intrinsics.checkNotNullParameter((Object)point, (String)"point");
                this.this$0.getPresentation().mouseClicked(this.$event, point);
            }
            {
                this.this$0 = containerInlayPresentation;
                this.$event = mouseEvent;
                super(1);
            }
        }));
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        this.handleMouse(translated, (Function1<? super Point, Unit>)((Function1)new Function1<Point, Unit>(this, event){
            final /* synthetic */ ContainerInlayPresentation this$0;
            final /* synthetic */ MouseEvent $event;

            public final void invoke(@NotNull Point point) {
                Intrinsics.checkNotNullParameter((Object)point, (String)"point");
                this.this$0.getPresentation().mouseClicked(this.$event, point);
            }
            {
                this.this$0 = containerInlayPresentation;
                this.$event = mouseEvent;
                super(1);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseExited() {
        try {
            this.getPresentation().mouseExited();
        }
        finally {
            this.presentationIsUnderCursor = false;
        }
    }

    private final void handleMouse(Point original, Function1<? super Point, Unit> action2) {
        int x = original.x;
        int y = original.y;
        if (!this.isInInnerBounds(x, y)) {
            if (this.presentationIsUnderCursor) {
                this.getPresentation().mouseExited();
                this.presentationIsUnderCursor = false;
            }
            return;
        }
        Point translated = PresentationUtilKt.translateNew(original, -this.getLeftInset(), -this.getTopInset());
        action2.invoke((Object)translated);
    }

    private final boolean isInInnerBounds(int x, int y) {
        return x >= this.getLeftInset() && x < this.getLeftInset() + this.getPresentation().getWidth() && y >= this.getTopInset() && y < this.getTopInset() + this.getPresentation().getHeight();
    }

    private final int getLeftInset() {
        InlayPresentationFactory.Padding padding = this.padding;
        return padding != null ? padding.getLeft() : 0;
    }

    private final int getRightInset() {
        InlayPresentationFactory.Padding padding = this.padding;
        return padding != null ? padding.getRight() : 0;
    }

    private final int getTopInset() {
        InlayPresentationFactory.Padding padding = this.padding;
        return padding != null ? padding.getTop() : 0;
    }

    private final int getBottomInset() {
        InlayPresentationFactory.Padding padding = this.padding;
        return padding != null ? padding.getBottom() : 0;
    }

    private final void fillRoundedRectangle(Graphics2D g, int height, int width, int arcWidth, int arcHeight, float backgroundAlpha) {
        GraphicsConfig config2 = GraphicsUtil.setupAAPainting((Graphics)g);
        GraphicsUtil.paintWithAlpha((Graphics)g, (float)backgroundAlpha);
        g.fillRoundRect(0, 0, width, height, arcWidth, arcHeight);
        config2.restore();
    }

    public ContainerInlayPresentation(@NotNull InlayPresentation presentation2, @Nullable InlayPresentationFactory.Padding padding, @Nullable InlayPresentationFactory.RoundedCorners roundedCorners, @Nullable Color background, float backgroundAlpha) {
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        super(presentation2);
        this.padding = padding;
        this.roundedCorners = roundedCorners;
        this.background = background;
        this.backgroundAlpha = backgroundAlpha;
    }

    public /* synthetic */ ContainerInlayPresentation(InlayPresentation inlayPresentation, InlayPresentationFactory.Padding padding, InlayPresentationFactory.RoundedCorners roundedCorners, Color color, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            padding = null;
        }
        if ((n & 4) != 0) {
            roundedCorners = null;
        }
        if ((n & 8) != 0) {
            color = null;
        }
        if ((n & 0x10) != 0) {
            f = 0.55f;
        }
        this(inlayPresentation, padding, roundedCorners, color, f);
    }
}

