/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.CodeBlockProvider;
import com.intellij.codeInsight.editorActions.CodeBlockProviders;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.codeInsight.highlighting.CodeBlockSupportHandler;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.IndentGuideDescriptor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public final class CodeBlockUtil {
    private CodeBlockUtil() {
    }

    private static Language getBraceType(HighlighterIterator iterator2) {
        IElementType type = iterator2.getTokenType();
        return type.getLanguage();
    }

    public static void moveCaretToCodeBlockEnd(Project project, Editor editor, boolean isWithSelection) {
        Document document = editor.getDocument();
        int selectionStart = editor.getSelectionModel().getLeadSelectionOffset();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file2 == null) {
            return;
        }
        IdeDocumentHistory.getInstance(project).includeCurrentCommandAsNavigation();
        CodeBlockProvider provider2 = (CodeBlockProvider)CodeBlockProviders.INSTANCE.forLanguage(file2.getLanguage());
        if (provider2 != null) {
            TextRange range2 = provider2.getCodeBlockRange(editor, file2);
            if (range2 != null) {
                editor.getCaretModel().moveToOffset(range2.getEndOffset());
            }
        } else {
            IndentGuideDescriptor guide = editor.getIndentsModel().getCaretIndentGuide();
            if (guide != null) {
                editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(guide.endLine, guide.indentLevel));
            } else {
                int endOffset = CodeBlockUtil.calcBlockEndOffset(editor, file2);
                if (endOffset != -1) {
                    editor.getCaretModel().moveToOffset(endOffset);
                }
            }
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        if (isWithSelection) {
            editor.getSelectionModel().setSelection(selectionStart, editor.getCaretModel().getOffset());
        } else {
            editor.getSelectionModel().removeSelection();
        }
    }

    public static void moveCaretToCodeBlockStart(Project project, Editor editor, boolean isWithSelection) {
        Document document = editor.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        int selectionStart = editor.getSelectionModel().getLeadSelectionOffset();
        if (file2 == null) {
            return;
        }
        IdeDocumentHistory.getInstance(project).includeCurrentCommandAsNavigation();
        CodeBlockProvider provider2 = (CodeBlockProvider)CodeBlockProviders.INSTANCE.forLanguage(file2.getLanguage());
        if (provider2 != null) {
            TextRange range2 = provider2.getCodeBlockRange(editor, file2);
            if (range2 != null) {
                editor.getCaretModel().moveToOffset(range2.getStartOffset());
            }
        } else {
            IndentGuideDescriptor guide = editor.getIndentsModel().getCaretIndentGuide();
            if (guide != null && guide.startLine != editor.getCaretModel().getLogicalPosition().line) {
                editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(guide.startLine, guide.indentLevel));
            } else {
                int start2 = CodeBlockUtil.calcBlockStartOffset(editor, file2);
                if (start2 < 0) {
                    return;
                }
                editor.getCaretModel().moveToOffset(start2);
            }
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        if (isWithSelection) {
            editor.getSelectionModel().setSelection(selectionStart, editor.getCaretModel().getOffset());
        } else {
            editor.getSelectionModel().removeSelection();
        }
    }

    private static int calcBlockEndOffset(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            CodeBlockUtil.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            CodeBlockUtil.$$$reportNull$$$0(1);
        }
        int offsetFromBraceMatcher = CodeBlockUtil.calcBlockEndOffsetFromBraceMatcher(editor, file2);
        TextRange rangeFromStructuralSupport = CodeBlockSupportHandler.findCodeBlockRange(editor, file2);
        if (rangeFromStructuralSupport.isEmpty()) {
            return offsetFromBraceMatcher;
        }
        if (offsetFromBraceMatcher == -1) {
            return rangeFromStructuralSupport.getEndOffset();
        }
        return Math.min(rangeFromStructuralSupport.getEndOffset(), offsetFromBraceMatcher);
    }

    private static int calcBlockEndOffsetFromBraceMatcher(@NotNull Editor editor, @NotNull PsiFile file2) {
        Language braceType;
        if (editor == null) {
            CodeBlockUtil.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            CodeBlockUtil.$$$reportNull$$$0(3);
        }
        Document document = editor.getDocument();
        int offset = editor.getCaretModel().getOffset();
        FileType fileType = CodeBlockUtil.getFileType(file2, offset);
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator2.atEnd()) {
            return -1;
        }
        int depth = 0;
        boolean isBeforeLBrace = false;
        if (CodeBlockUtil.isLStructuralBrace(fileType, iterator2, document.getCharsSequence())) {
            isBeforeLBrace = true;
            depth = -1;
            braceType = CodeBlockUtil.getBraceType(iterator2);
        } else {
            braceType = null;
        }
        boolean moved = false;
        while (true) {
            if (iterator2.atEnd()) {
                return -1;
            }
            if (CodeBlockUtil.isRStructuralBrace(fileType, iterator2, document.getCharsSequence()) && (braceType == CodeBlockUtil.getBraceType(iterator2) || braceType == null)) {
                if (moved) {
                    if (depth == 0) break;
                    --depth;
                }
                if (braceType == null) {
                    braceType = CodeBlockUtil.getBraceType(iterator2);
                }
            } else if (CodeBlockUtil.isLStructuralBrace(fileType, iterator2, document.getCharsSequence()) && (braceType == CodeBlockUtil.getBraceType(iterator2) || braceType == null)) {
                if (braceType == null) {
                    braceType = CodeBlockUtil.getBraceType(iterator2);
                }
                ++depth;
            }
            moved = true;
            iterator2.advance();
        }
        return isBeforeLBrace ? iterator2.getEnd() : iterator2.getStart();
    }

    private static int calcBlockStartOffset(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            CodeBlockUtil.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            CodeBlockUtil.$$$reportNull$$$0(5);
        }
        int offsetFromBraceMatcher = CodeBlockUtil.calcBlockStartOffsetFromBraceMatcher(editor, file2);
        TextRange rangeFromStructuralSupport = CodeBlockSupportHandler.findCodeBlockRange(editor, file2);
        if (rangeFromStructuralSupport.isEmpty()) {
            return offsetFromBraceMatcher;
        }
        if (offsetFromBraceMatcher == -1) {
            return rangeFromStructuralSupport.getStartOffset();
        }
        return Math.max(rangeFromStructuralSupport.getStartOffset(), offsetFromBraceMatcher);
    }

    private static int calcBlockStartOffsetFromBraceMatcher(Editor editor, PsiFile file2) {
        Language braceType;
        int offset = editor.getCaretModel().getOffset() - 1;
        if (offset < 0) {
            return -1;
        }
        Document document = editor.getDocument();
        FileType fileType = CodeBlockUtil.getFileType(file2, offset);
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(offset);
        int depth = 0;
        boolean isAfterRBrace = false;
        if (CodeBlockUtil.isRStructuralBrace(fileType, iterator2, document.getCharsSequence())) {
            isAfterRBrace = true;
            depth = -1;
            braceType = CodeBlockUtil.getBraceType(iterator2);
        } else {
            braceType = null;
        }
        boolean moved = false;
        while (true) {
            if (iterator2.atEnd()) {
                return -1;
            }
            if (CodeBlockUtil.isLStructuralBrace(fileType, iterator2, document.getCharsSequence()) && (braceType == CodeBlockUtil.getBraceType(iterator2) || braceType == null)) {
                if (braceType == null) {
                    braceType = CodeBlockUtil.getBraceType(iterator2);
                }
                if (moved) {
                    if (depth == 0) break;
                    --depth;
                }
            } else if (CodeBlockUtil.isRStructuralBrace(fileType, iterator2, document.getCharsSequence()) && (braceType == CodeBlockUtil.getBraceType(iterator2) || braceType == null)) {
                if (braceType == null) {
                    braceType = CodeBlockUtil.getBraceType(iterator2);
                }
                ++depth;
            }
            moved = true;
            iterator2.retreat();
        }
        return isAfterRBrace ? iterator2.getStart() : iterator2.getEnd();
    }

    @NotNull
    private static FileType getFileType(PsiFile file2, int offset) {
        PsiElement psiElement = file2.findElementAt(offset);
        if (psiElement != null) {
            FileType fileType = psiElement.getContainingFile().getFileType();
            if (fileType == null) {
                CodeBlockUtil.$$$reportNull$$$0(6);
            }
            return fileType;
        }
        FileType fileType = file2.getFileType();
        if (fileType == null) {
            CodeBlockUtil.$$$reportNull$$$0(7);
        }
        return fileType;
    }

    private static boolean isLStructuralBrace(FileType fileType, HighlighterIterator iterator2, CharSequence fileText) {
        return BraceMatchingUtil.isLBraceToken(iterator2, fileText, fileType) && BraceMatchingUtil.isStructuralBraceToken(fileType, iterator2, fileText);
    }

    private static boolean isRStructuralBrace(FileType fileType, HighlighterIterator iterator2, CharSequence fileText) {
        return BraceMatchingUtil.isRBraceToken(iterator2, fileText, fileType) && BraceMatchingUtil.isStructuralBraceToken(fileType, iterator2, fileText);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/CodeBlockUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/CodeBlockUtil";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calcBlockEndOffset";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calcBlockEndOffsetFromBraceMatcher";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calcBlockStartOffset";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

