/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.DaemonTooltipRenderer;
import com.intellij.codeInsight.daemon.impl.DaemonTooltipWithActionRenderer;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoComposite;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.tooltips.TooltipActionProvider;
import com.intellij.codeInsight.hint.LineTooltipRenderer;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.ErrorStripTooltipRendererProvider;
import com.intellij.openapi.editor.ex.TooltipAction;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DaemonTooltipRendererProvider
implements ErrorStripTooltipRendererProvider {
    private final Project myProject;
    private final Editor myEditor;

    DaemonTooltipRendererProvider(Project project, Editor editor) {
        this.myProject = project;
        this.myEditor = editor;
    }

    @Override
    public TooltipRenderer calcTooltipRenderer(@NotNull Collection<? extends RangeHighlighter> highlighters) {
        if (highlighters == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(0);
        }
        LineTooltipRenderer bigRenderer = null;
        SmartList infos = new SmartList();
        THashSet tooltips = new THashSet();
        for (RangeHighlighter rangeHighlighter : highlighters) {
            Object tooltipObject = rangeHighlighter.getErrorStripeTooltip();
            if (tooltipObject == null) continue;
            if (tooltipObject instanceof HighlightInfo) {
                HighlightInfo info = (HighlightInfo)tooltipObject;
                if (info.getToolTip() == null || !tooltips.add(info.getToolTip())) continue;
                infos.add(info);
                continue;
            }
            @NlsContexts.Tooltip String text2 = tooltipObject.toString();
            if (!tooltips.add(text2)) continue;
            if (bigRenderer == null) {
                bigRenderer = new DaemonTooltipRenderer(text2, new Object[]{highlighters});
                continue;
            }
            bigRenderer.addBelow(text2);
        }
        if (!infos.isEmpty()) {
            DaemonTooltipRenderer myRenderer2;
            ContainerUtil.quickSort((List)infos, (o1, o2) -> {
                int i2 = SeverityRegistrar.getSeverityRegistrar(this.myProject).compare(o2.getSeverity(), o1.getSeverity());
                if (i2 != 0) {
                    return i2;
                }
                return o1.getToolTip().compareTo(o2.getToolTip());
            });
            HighlightInfoComposite composite = HighlightInfoComposite.create((List<? extends HighlightInfo>)infos);
            String string = composite.getToolTip();
            if (Registry.is((String)"ide.tooltip.show.with.actions")) {
                Object[] objectArray;
                TooltipAction action2 = TooltipActionProvider.calcTooltipAction(composite, this.myEditor);
                if (action2 == null) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = string;
                } else {
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = string;
                    objectArray = objectArray3;
                    objectArray3[1] = action2;
                }
                DaemonTooltipWithActionRenderer myRenderer3 = new DaemonTooltipWithActionRenderer(string, action2, 0, objectArray);
            } else {
                myRenderer2 = new DaemonTooltipRenderer(string, new Object[]{highlighters});
            }
            if (bigRenderer != null) {
                myRenderer2.addBelow(bigRenderer.getText());
            }
            bigRenderer = myRenderer2;
        }
        return bigRenderer;
    }

    @Override
    @NotNull
    public TooltipRenderer calcTooltipRenderer(@NotNull String text2) {
        if (text2 == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(1);
        }
        return new DaemonTooltipRenderer(text2, new Object[]{text2});
    }

    @Override
    @NotNull
    public TooltipRenderer calcTooltipRenderer(@NotNull String text2, int width) {
        if (text2 == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(2);
        }
        return new DaemonTooltipRenderer(text2, width, new Object[]{text2});
    }

    @Override
    @NotNull
    public TooltipRenderer calcTooltipRenderer(@NotNull String text2, @Nullable TooltipAction action2, int width) {
        if (text2 == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(3);
        }
        if (action2 != null || Registry.is((String)"ide.tooltip.show.with.actions")) {
            Object[] objectArray;
            if (action2 == null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = text2;
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = text2;
                objectArray = objectArray3;
                objectArray3[1] = action2;
            }
            return new DaemonTooltipWithActionRenderer(text2, action2, width, objectArray);
        }
        TooltipRenderer tooltipRenderer = ErrorStripTooltipRendererProvider.super.calcTooltipRenderer(text2, null, width);
        if (tooltipRenderer == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(4);
        }
        return tooltipRenderer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighters";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/DaemonTooltipRendererProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonTooltipRendererProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calcTooltipRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calcTooltipRenderer";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

