/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build.progress;

import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.StartEvent;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FileMessageEventImpl;
import com.intellij.build.events.impl.FinishEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.events.impl.OutputBuildEventImpl;
import com.intellij.build.events.impl.ProgressBuildEventImpl;
import com.intellij.build.events.impl.SkippedResultImpl;
import com.intellij.build.events.impl.StartEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.build.progress.BuildProgress;
import com.intellij.build.progress.BuildProgressDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
class BuildProgressImpl
implements BuildProgress<BuildProgressDescriptor> {
    private final Object myId = new Object();
    private final BuildProgressListener myListener;
    @Nullable
    private final BuildProgress<BuildProgressDescriptor> myParentProgress;
    private BuildProgressDescriptor myDescriptor;

    BuildProgressImpl(BuildProgressListener listener2, @Nullable BuildProgress<BuildProgressDescriptor> parentProgress) {
        this.myListener = listener2;
        this.myParentProgress = parentProgress;
    }

    protected Object getBuildId() {
        return this.myDescriptor.getBuildDescriptor().getId();
    }

    @Override
    @NotNull
    public Object getId() {
        Object object = this.myId;
        if (object == null) {
            BuildProgressImpl.$$$reportNull$$$0(0);
        }
        return object;
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> start(@NotNull BuildProgressDescriptor descriptor2) {
        if (descriptor2 == null) {
            BuildProgressImpl.$$$reportNull$$$0(1);
        }
        this.myDescriptor = descriptor2;
        StartEvent event = this.createStartEvent(descriptor2);
        this.myListener.onEvent(this.getBuildId(), (BuildEvent)event);
        BuildProgressImpl buildProgressImpl = this;
        if (buildProgressImpl == null) {
            BuildProgressImpl.$$$reportNull$$$0(2);
        }
        return buildProgressImpl;
    }

    @NotNull
    protected StartEvent createStartEvent(BuildProgressDescriptor descriptor2) {
        assert (this.myParentProgress != null);
        return new StartEventImpl(this.getId(), this.myParentProgress.getId(), System.currentTimeMillis(), descriptor2.getTitle());
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> startChildProgress(final @NotNull String title) {
        if (title == null) {
            BuildProgressImpl.$$$reportNull$$$0(3);
        }
        final BuildDescriptor buildDescriptor = this.myDescriptor.getBuildDescriptor();
        BuildProgress<BuildProgressDescriptor> buildProgress = new BuildProgressImpl(this.myListener, this).start(new BuildProgressDescriptor(){

            @Override
            @NotNull
            public String getTitle() {
                String string = title;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @NotNull
            public BuildDescriptor getBuildDescriptor() {
                BuildDescriptor buildDescriptor2 = buildDescriptor;
                if (buildDescriptor2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return buildDescriptor2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/build/progress/BuildProgressImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTitle";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBuildDescriptor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        });
        if (buildProgress == null) {
            BuildProgressImpl.$$$reportNull$$$0(4);
        }
        return buildProgress;
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> progress(@NotNull String title) {
        if (title == null) {
            BuildProgressImpl.$$$reportNull$$$0(5);
        }
        BuildProgress<BuildProgressDescriptor> buildProgress = this.progress(title, -1L, -1L, "");
        if (buildProgress == null) {
            BuildProgressImpl.$$$reportNull$$$0(6);
        }
        return buildProgress;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> progress(@NotNull String title, long total, long progress2, String string) {
        void unit;
        if (title == null) {
            BuildProgressImpl.$$$reportNull$$$0(7);
        }
        Object parentId = this.myParentProgress != null ? this.myParentProgress.getId() : null;
        this.myListener.onEvent(this.getBuildId(), (BuildEvent)new ProgressBuildEventImpl(this.getId(), parentId, System.currentTimeMillis(), title, total, progress2, (String)unit));
        BuildProgressImpl buildProgressImpl = this;
        if (buildProgressImpl == null) {
            BuildProgressImpl.$$$reportNull$$$0(8);
        }
        return buildProgressImpl;
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> output(@NotNull String text2, boolean stdOut) {
        if (text2 == null) {
            BuildProgressImpl.$$$reportNull$$$0(9);
        }
        this.myListener.onEvent(this.getBuildId(), (BuildEvent)new OutputBuildEventImpl(this.getId(), text2, stdOut));
        BuildProgressImpl buildProgressImpl = this;
        if (buildProgressImpl == null) {
            BuildProgressImpl.$$$reportNull$$$0(10);
        }
        return buildProgressImpl;
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> fileMessage(@NotNull String title, @NotNull String message, @NotNull MessageEvent.Kind kind, @NotNull FilePosition filePosition) {
        if (title == null) {
            BuildProgressImpl.$$$reportNull$$$0(11);
        }
        if (message == null) {
            BuildProgressImpl.$$$reportNull$$$0(12);
        }
        if (kind == null) {
            BuildProgressImpl.$$$reportNull$$$0(13);
        }
        if (filePosition == null) {
            BuildProgressImpl.$$$reportNull$$$0(14);
        }
        StringBuilder fileLink = new StringBuilder(filePosition.getFile().getPath());
        if (filePosition.getStartLine() > 0) {
            fileLink.append(":").append(filePosition.getStartLine() + 1);
            if (filePosition.getStartColumn() > 0) {
                fileLink.append(":").append(filePosition.getStartColumn() + 1);
            }
        }
        @NlsSafe String detailedMessage = fileLink.toString() + "\n" + message;
        FileMessageEventImpl event = new FileMessageEventImpl(this.getId(), kind, null, title, detailedMessage, filePosition);
        this.myListener.onEvent(this.getBuildId(), (BuildEvent)event);
        BuildProgressImpl buildProgressImpl = this;
        if (buildProgressImpl == null) {
            BuildProgressImpl.$$$reportNull$$$0(15);
        }
        return buildProgressImpl;
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> message(@NotNull String title, @NotNull String message, @NotNull MessageEvent.Kind kind, final @Nullable Navigatable navigatable) {
        if (title == null) {
            BuildProgressImpl.$$$reportNull$$$0(16);
        }
        if (message == null) {
            BuildProgressImpl.$$$reportNull$$$0(17);
        }
        if (kind == null) {
            BuildProgressImpl.$$$reportNull$$$0(18);
        }
        MessageEventImpl event = new MessageEventImpl(this.getId(), kind, null, title, message){

            @Override
            @Nullable
            public Navigatable getNavigatable(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                return navigatable;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/build/progress/BuildProgressImpl$2", "getNavigatable"));
            }
        };
        this.myListener.onEvent(this.getBuildId(), (BuildEvent)event);
        BuildProgressImpl buildProgressImpl = this;
        if (buildProgressImpl == null) {
            BuildProgressImpl.$$$reportNull$$$0(19);
        }
        return buildProgressImpl;
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> finish() {
        BuildProgress<BuildProgressDescriptor> buildProgress = this.finish(false);
        if (buildProgress == null) {
            BuildProgressImpl.$$$reportNull$$$0(20);
        }
        return buildProgress;
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> finish(boolean isUpToDate) {
        BuildProgress<BuildProgressDescriptor> buildProgress = this.finish(System.currentTimeMillis(), isUpToDate, this.myDescriptor.getTitle());
        if (buildProgress == null) {
            BuildProgressImpl.$$$reportNull$$$0(21);
        }
        return buildProgress;
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> finish(long timeStamp) {
        BuildProgress<BuildProgressDescriptor> buildProgress = this.finish(timeStamp, false, this.myDescriptor.getTitle());
        if (buildProgress == null) {
            BuildProgressImpl.$$$reportNull$$$0(22);
        }
        return buildProgress;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> finish(long timeStamp, boolean isUpToDate, @NotNull String string) {
        void message;
        if (string == null) {
            BuildProgressImpl.$$$reportNull$$$0(23);
        }
        this.assertStarted();
        assert (this.myParentProgress != null);
        SuccessResultImpl result2 = new SuccessResultImpl(isUpToDate);
        FinishEventImpl event = new FinishEventImpl(this.getId(), this.myParentProgress.getId(), timeStamp, (String)message, (EventResult)result2);
        this.myListener.onEvent(this.getBuildId(), (BuildEvent)event);
        BuildProgress<BuildProgressDescriptor> buildProgress = this.myParentProgress;
        if (buildProgress == null) {
            BuildProgressImpl.$$$reportNull$$$0(24);
        }
        return buildProgress;
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> fail() {
        BuildProgress<BuildProgressDescriptor> buildProgress = this.fail(System.currentTimeMillis(), this.myDescriptor.getTitle());
        if (buildProgress == null) {
            BuildProgressImpl.$$$reportNull$$$0(25);
        }
        return buildProgress;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> fail(long timeStamp, @NotNull String string) {
        void message;
        if (string == null) {
            BuildProgressImpl.$$$reportNull$$$0(26);
        }
        this.assertStarted();
        assert (this.myParentProgress != null);
        FinishEventImpl event = new FinishEventImpl(this.getId(), this.myParentProgress.getId(), timeStamp, (String)message, (EventResult)new FailureResultImpl());
        this.myListener.onEvent(this.getBuildId(), (BuildEvent)event);
        BuildProgress<BuildProgressDescriptor> buildProgress = this.myParentProgress;
        if (buildProgress == null) {
            BuildProgressImpl.$$$reportNull$$$0(27);
        }
        return buildProgress;
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> cancel() {
        BuildProgress<BuildProgressDescriptor> buildProgress = this.cancel(System.currentTimeMillis(), this.myDescriptor.getTitle());
        if (buildProgress == null) {
            BuildProgressImpl.$$$reportNull$$$0(28);
        }
        return buildProgress;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> cancel(long timeStamp, @NotNull String string) {
        void message;
        if (string == null) {
            BuildProgressImpl.$$$reportNull$$$0(29);
        }
        this.assertStarted();
        assert (this.myParentProgress != null);
        FinishEventImpl event = new FinishEventImpl(this.getId(), this.myParentProgress.getId(), timeStamp, (String)message, (EventResult)new SkippedResultImpl());
        this.myListener.onEvent(this.getBuildId(), (BuildEvent)event);
        BuildProgress<BuildProgressDescriptor> buildProgress = this.myParentProgress;
        if (buildProgress == null) {
            BuildProgressImpl.$$$reportNull$$$0(30);
        }
        return buildProgress;
    }

    protected void assertStarted() {
        if (this.myDescriptor == null) {
            throw new IllegalStateException("The start event was not triggered yet.");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 26: 
            case 29: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 26: 
            case 29: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/build/progress/BuildProgressImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: 
            case 17: 
            case 23: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 26: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/build/progress/BuildProgressImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "start";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "startChildProgress";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "progress";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "output";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "fileMessage";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "message";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "finish";
                break;
            }
            case 25: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "fail";
                break;
            }
            case 28: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "cancel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "startChildProgress";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "progress";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "output";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fileMessage";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "message";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "finish";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "fail";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "cancel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 26: 
            case 29: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

