/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import info.debatty.java.stringsimilarity.interfaces.StringDistance;
import net.jcip.annotations.Immutable;

@Immutable
public final class OptimalStringAlignment
implements StringDistance {
    public double distance(String s1, String s2) {
        if (s1 == null) {
            throw new NullPointerException("s1 must not be null");
        }
        if (s2 == null) {
            throw new NullPointerException("s2 must not be null");
        }
        if (s1.equals(s2)) {
            return 0.0;
        }
        int n = s1.length();
        int m = s2.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 2][m + 2];
        for (int i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (int j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (int i = 1; i <= n; ++i) {
            for (int j = 1; j <= m; ++j) {
                int cost = 1;
                if (s1.charAt(i - 1) == s2.charAt(j - 1)) {
                    cost = 0;
                }
                d[i][j] = OptimalStringAlignment.min(d[i - 1][j - 1] + cost, d[i][j - 1] + 1, d[i - 1][j] + 1);
                if (i <= 1 || j <= 1 || s1.charAt(i - 1) != s2.charAt(j - 2) || s1.charAt(i - 2) != s2.charAt(j - 1)) continue;
                d[i][j] = Math.min(d[i][j], d[i - 2][j - 2] + cost);
            }
        }
        return d[n][m];
    }

    private static int min(int a, int b, int c) {
        return Math.min(a, Math.min(b, c));
    }
}

