/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.util.VcsUserUtil;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRewordOperation;
import git4idea.rebase.GitSingleCommitEditingAction;
import git4idea.rebase.log.GitCommitEditingActionBase;
import git4idea.rebase.log.GitCommitEditingNotificationsKt;
import git4idea.rebase.log.GitCommitEditingOperationResult;
import git4idea.rebase.log.GitLogCommitDetailsLoaderKt;
import git4idea.rebase.log.GitNewCommitMessageActionDialog;
import git4idea.repo.GitRepository;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0014J\u001a\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0014J(\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\fH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lgit4idea/rebase/GitRewordAction;", "Lgit4idea/rebase/GitSingleCommitEditingAction;", "()V", "prohibitRebaseDuringRebasePolicy", "Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy$Prohibit;", "getProhibitRebaseDuringRebasePolicy", "()Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy$Prohibit;", "actionPerformedAfterChecks", "", "commitEditingData", "Lgit4idea/rebase/GitSingleCommitEditingAction$SingleCommitEditingData;", "getFailureTitle", "", "getProhibitedStateMessage", "operation", "rewordInBackground", "project", "Lcom/intellij/openapi/project/Project;", "commit", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "repository", "Lgit4idea/repo/GitRepository;", "newMessage", "intellij.vcs.git"})
public final class GitRewordAction
extends GitSingleCommitEditingAction {
    @NotNull
    private final GitCommitEditingActionBase.ProhibitRebaseDuringRebasePolicy.Prohibit prohibitRebaseDuringRebasePolicy;

    @Override
    @NotNull
    protected GitCommitEditingActionBase.ProhibitRebaseDuringRebasePolicy.Prohibit getProhibitRebaseDuringRebasePolicy() {
        return this.prohibitRebaseDuringRebasePolicy;
    }

    @Override
    protected void actionPerformedAfterChecks(@NotNull GitSingleCommitEditingAction.SingleCommitEditingData commitEditingData) {
        Intrinsics.checkNotNullParameter((Object)commitEditingData, (String)"commitEditingData");
        List<VcsCommitMetadata> details = GitLogCommitDetailsLoaderKt.getOrLoadDetails(commitEditingData.getProject(), commitEditingData.getLogData(), CollectionsKt.listOf((Object)commitEditingData.getSelectedCommit()));
        VcsCommitMetadata commit2 = (VcsCommitMetadata)CollectionsKt.first(details);
        GitCommitEditingActionBase.MultipleCommitEditingData multipleCommitEditingData = commitEditingData;
        String string = commit2.getFullMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"commit.fullMessage");
        String string2 = GitBundle.message("rebase.log.reword.dialog.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GitBundle.message(\"rebas\u2026log.reword.dialog.title\")");
        String string3 = GitBundle.message("rebase.log.reword.dialog.description.label", ((Hash)commit2.getId()).toShortString(), VcsUserUtil.getShortPresentation((VcsUser)commit2.getAuthor()));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"GitBundle.message(\n     \u2026on(commit.author)\n      )");
        GitNewCommitMessageActionDialog<GitCommitEditingActionBase.MultipleCommitEditingData> dialog2 = new GitNewCommitMessageActionDialog<GitCommitEditingActionBase.MultipleCommitEditingData>(multipleCommitEditingData, string, string2, string3);
        dialog2.show((Function1<String, Unit>)((Function1)new Function1<String, Unit>(this, commitEditingData, commit2){
            final /* synthetic */ GitRewordAction this$0;
            final /* synthetic */ GitSingleCommitEditingAction.SingleCommitEditingData $commitEditingData;
            final /* synthetic */ VcsCommitMetadata $commit;

            public final void invoke(@NotNull String newMessage) {
                Intrinsics.checkNotNullParameter((Object)newMessage, (String)"newMessage");
                GitRewordAction.access$rewordInBackground(this.this$0, this.$commitEditingData.getProject(), this.$commit, this.$commitEditingData.getRepository(), newMessage);
            }
            {
                this.this$0 = gitRewordAction;
                this.$commitEditingData = singleCommitEditingData;
                this.$commit = vcsCommitMetadata;
                super(1);
            }
        }));
    }

    @Override
    @NotNull
    protected String getFailureTitle() {
        String string = GitBundle.message("rebase.log.reword.action.failure.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"rebas\u2026rd.action.failure.title\")");
        return string;
    }

    private final void rewordInBackground(Project project, VcsCommitMetadata commit2, GitRepository repository, String newMessage) {
        new Task.Backgroundable(repository, commit2, newMessage, project, project, GitBundle.message("rebase.log.reword.action.progress.indicator.title", new Object[0])){
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ VcsCommitMetadata $commit;
            final /* synthetic */ String $newMessage;
            final /* synthetic */ Project $project;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                GitCommitEditingOperationResult operationResult = new GitRewordOperation(this.$repository, this.$commit, this.$newMessage).execute();
                if (operationResult instanceof GitCommitEditingOperationResult.Complete) {
                    GitCommitEditingOperationResult.Complete complete = (GitCommitEditingOperationResult.Complete)operationResult;
                    String string = GitBundle.message("rebase.log.reword.action.notification.successful.title", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"rebas\u2026cation.successful.title\")");
                    String string2 = GitBundle.message("rebase.log.reword.action.progress.indicator.undo.title", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GitBundle.message(\"rebas\u2026ss.indicator.undo.title\")");
                    String string3 = GitBundle.message("rebase.log.reword.action.notification.undo.not.allowed.title", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"GitBundle.message(\"rebas\u2026.undo.not.allowed.title\")");
                    String string4 = GitBundle.message("rebase.log.reword.action.notification.undo.failed.title", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"GitBundle.message(\"rebas\u2026ation.undo.failed.title\")");
                    GitCommitEditingNotificationsKt.notifySuccess(complete, string, string2, string3, string4);
                    ChangeListManagerImpl.getInstanceImpl((Project)this.$project).replaceCommitMessage(this.$commit.getFullMessage(), this.$newMessage);
                }
            }
            {
                this.$repository = $captured_local_variable$0;
                this.$commit = $captured_local_variable$1;
                this.$newMessage = $captured_local_variable$2;
                this.$project = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5);
            }
        }.queue();
    }

    @Override
    @Nullable
    protected String getProhibitedStateMessage(@NotNull GitSingleCommitEditingAction.SingleCommitEditingData commitEditingData, @NotNull String operation) {
        Intrinsics.checkNotNullParameter((Object)commitEditingData, (String)"commitEditingData");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        if (commitEditingData.getRepository().getState() == Repository.State.REBASING && commitEditingData.isHeadCommit()) {
            return null;
        }
        return super.getProhibitedStateMessage((GitCommitEditingActionBase.MultipleCommitEditingData)commitEditingData, operation);
    }

    public GitRewordAction() {
        String string = GitBundle.message("rebase.log.action.operation.reword.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"rebas\u2026n.operation.reword.name\")");
        this.prohibitRebaseDuringRebasePolicy = new GitCommitEditingActionBase.ProhibitRebaseDuringRebasePolicy.Prohibit(string);
    }

    public static final /* synthetic */ void access$rewordInBackground(GitRewordAction $this, Project project, VcsCommitMetadata commit2, GitRepository repository, String newMessage) {
        $this.rewordInBackground(project, commit2, repository, newMessage);
    }
}

