/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.ui;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.EditorTabPreview;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.TreeActionsToolbarPanel;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcs.commit.CommitStatusPanel;
import com.intellij.vcs.commit.CommitWorkflowUi;
import com.intellij.vcs.commit.EditedCommitDetails;
import com.intellij.vcs.commit.EditedCommitNode;
import com.intellij.vcs.commit.NonModalCommitWorkflowUi;
import com.intellij.vcs.log.BaseSingleTaskControllerKt;
import com.intellij.vcs.log.ui.frame.ProgressStripe;
import git4idea.GitVcs;
import git4idea.i18n.GitBundle;
import git4idea.index.GitStageCommitWorkflow;
import git4idea.index.GitStageCommitWorkflowHandler;
import git4idea.index.GitStageTracker;
import git4idea.index.GitStageTrackerListener;
import git4idea.index.actions.GitAddOperation;
import git4idea.index.actions.GitResetOperation;
import git4idea.index.actions.StagingAreaOperation;
import git4idea.index.actions.StagingAreaOperationActionKt;
import git4idea.index.ui.GitFileStatusNode;
import git4idea.index.ui.GitStageCommitPanel;
import git4idea.index.ui.GitStageDataKeys;
import git4idea.index.ui.GitStageDiffPreview;
import git4idea.index.ui.GitStageEditorDiffPreview;
import git4idea.index.ui.GitStagePanel$MyChangesTree$WhenMappings;
import git4idea.index.ui.GitStageTree;
import git4idea.index.ui.GitStageUiSettings;
import git4idea.index.ui.GitStageUiSettingsImpl;
import git4idea.index.ui.NodeKind;
import git4idea.repo.GitRepository;
import git4idea.status.GitChangeProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0003012B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\b\u0010#\u001a\u00020$H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(H\u0016J\u0015\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020(H\u0000\u00a2\u0006\u0002\b+J\u0018\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020\u00072\b\b\u0002\u0010.\u001a\u00020\u0007J\b\u0010/\u001a\u00020$H\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u00063"}, d2={"Lgit4idea/index/ui/GitStagePanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Lcom/intellij/openapi/Disposable;", "tracker", "Lgit4idea/index/GitStageTracker;", "isEditorDiffPreview", "", "disposableParent", "(Lgit4idea/index/GitStageTracker;ZLcom/intellij/openapi/Disposable;)V", "commitDiffSplitter", "Lcom/intellij/ui/OnePixelSplitter;", "commitPanel", "Lgit4idea/index/ui/GitStageCommitPanel;", "commitWorkflowHandler", "Lgit4idea/index/GitStageCommitWorkflowHandler;", "diffPreviewProcessor", "Lgit4idea/index/ui/GitStageDiffPreview;", "editorTabPreview", "Lcom/intellij/openapi/vcs/changes/EditorTabPreview;", "hasPendingUpdates", "progressStripe", "Lcom/intellij/vcs/log/ui/frame/ProgressStripe;", "project", "Lcom/intellij/openapi/project/Project;", "state", "Lgit4idea/index/GitStageTracker$State;", "getState", "()Lgit4idea/index/GitStageTracker$State;", "toolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "tree", "Lgit4idea/index/ui/GitStageTree;", "getTree", "()Lgit4idea/index/ui/GitStageTree;", "dispose", "", "getData", "", "dataId", "", "setCommitMessage", "commitMessage", "setCommitMessage$intellij_vcs_git", "setDiffPreviewInEditor", "isInEditor", "force", "update", "MyChangesTree", "MyGitChangeProviderListener", "MyGitStageTrackerListener", "intellij.vcs.git"})
public final class GitStagePanel
extends JPanel
implements DataProvider,
Disposable {
    private final Project project;
    @NotNull
    private final GitStageTree tree;
    private final GitStageCommitPanel commitPanel;
    private final GitStageCommitWorkflowHandler commitWorkflowHandler;
    private final ProgressStripe progressStripe;
    private final OnePixelSplitter commitDiffSplitter;
    private final ActionToolbar toolbar;
    private GitStageDiffPreview diffPreviewProcessor;
    private EditorTabPreview editorTabPreview;
    private boolean hasPendingUpdates;
    private final GitStageTracker tracker;

    @NotNull
    public final GitStageTree getTree() {
        return this.tree;
    }

    private final GitStageTracker.State getState() {
        return this.tracker.getState();
    }

    @RequiresEdt
    public final void update() {
        if (this.commitWorkflowHandler.getWorkflow().isExecuting()) {
            this.hasPendingUpdates = true;
            return;
        }
        this.tree.rebuildTree();
        this.commitPanel.setState(this.getState());
        this.commitWorkflowHandler.setState(this.getState());
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (GitStageDataKeys.GIT_STAGE_TRACKER.is(dataId)) {
            return this.tracker;
        }
        return null;
    }

    public final void setDiffPreviewInEditor(boolean isInEditor, boolean force) {
        if (Disposer.isDisposed((Disposable)this)) {
            return;
        }
        if (!force && isInEditor == (this.editorTabPreview != null)) {
            return;
        }
        if (this.diffPreviewProcessor != null) {
            GitStageDiffPreview gitStageDiffPreview = this.diffPreviewProcessor;
            Intrinsics.checkNotNull((Object)((Object)gitStageDiffPreview));
            Disposer.dispose((Disposable)((Disposable)gitStageDiffPreview));
        }
        GitStageDiffPreview gitStageDiffPreview = this.diffPreviewProcessor = new GitStageDiffPreview(this.project, this.tree, this.tracker, this);
        Intrinsics.checkNotNull((Object)((Object)gitStageDiffPreview));
        gitStageDiffPreview.getToolbarWrapper().setVerticalSizeReferent(this.toolbar.getComponent());
        if (isInEditor) {
            GitStageDiffPreview gitStageDiffPreview2 = this.diffPreviewProcessor;
            Intrinsics.checkNotNull((Object)((Object)gitStageDiffPreview2));
            this.editorTabPreview = new GitStageEditorDiffPreview(gitStageDiffPreview2, this.tree, this);
            this.commitDiffSplitter.setSecondComponent((JComponent)null);
        } else {
            this.editorTabPreview = null;
            GitStageDiffPreview gitStageDiffPreview3 = this.diffPreviewProcessor;
            Intrinsics.checkNotNull((Object)((Object)gitStageDiffPreview3));
            this.commitDiffSplitter.setSecondComponent(gitStageDiffPreview3.getComponent());
        }
    }

    public static /* synthetic */ void setDiffPreviewInEditor$default(GitStagePanel gitStagePanel, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl2 = false;
        }
        gitStagePanel.setDiffPreviewInEditor(bl, bl2);
    }

    public final void setCommitMessage$intellij_vcs_git(@NotNull String commitMessage) {
        Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
        this.commitPanel.getCommitMessage().setCommitMessage(commitMessage);
    }

    public void dispose() {
    }

    public GitStagePanel(@NotNull GitStageTracker tracker, boolean isEditorDiffPreview, @NotNull Disposable disposableParent) {
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        Intrinsics.checkNotNullParameter((Object)disposableParent, (String)"disposableParent");
        super(new BorderLayout());
        this.tracker = tracker;
        this.project = this.tracker.getProject();
        this.tree = new MyChangesTree(this.project);
        this.commitPanel = new GitStageCommitPanel(this.project);
        this.commitPanel.getCommitActionsPanel().setCommitButtonDefault((Function0)new Function0<Boolean>(){

            public final boolean invoke() {
                return !commitPanel.getCommitProgressUi().isDumbMode() && IdeFocusManager.getInstance((Project)project).getFocusedDescendantFor((Component)this) != null;
            }
        });
        this.commitPanel.getCommitActionsPanel().setupShortcuts((JComponent)this, (Disposable)this);
        this.commitPanel.addEditedCommitListener((Function0<Unit>)((Function0)new Function0<Unit>(this.tree){

            public final void invoke() {
                ((MyChangesTree)((GitStageTree)((Object)this.receiver))).editedCommitChanged();
            }
        }), this);
        this.commitWorkflowHandler = new GitStageCommitWorkflowHandler(new GitStageCommitWorkflow(this.project), (NonModalCommitWorkflowUi)this.commitPanel);
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.commitPanel));
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add(ActionManager.getInstance().getAction("Git.Stage.Toolbar"));
        toolbarGroup.addSeparator();
        toolbarGroup.add(ActionManager.getInstance().getAction("ChangesView.GroupBy"));
        toolbarGroup.addSeparator();
        toolbarGroup.addAll((Collection)TreeActionsToolbarPanel.createTreeActions((ChangesTree)this.tree));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)toolbarGroup, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"ActionManager.getInstanc\u2026NOWN, toolbarGroup, true)");
        this.toolbar = actionToolbar;
        this.toolbar.setTargetComponent((JComponent)((Object)this.tree));
        PopupHandler.installPopupHandler((JComponent)((JComponent)((Object)this.tree)), (String)"Git.Stage.Tree.Menu", (String)"Git.Stage.Tree.Menu");
        CommitStatusPanel commitStatusPanel = new CommitStatusPanel((CommitWorkflowUi)this.commitPanel);
        boolean bl = false;
        boolean bl2 = false;
        CommitStatusPanel $this$apply = commitStatusPanel;
        boolean bl3 = false;
        $this$apply.setBorder((Border)JBUI.Borders.empty((int)0, (int)1, (int)0, (int)6));
        $this$apply.setBackground(((MyChangesTree)this.tree).getBackground());
        $this$apply.addToLeft((Component)this.commitPanel.getToolbar().getComponent());
        CommitStatusPanel statusPanel = commitStatusPanel;
        BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel((Component)ScrollPaneFactory.createScrollPane((Component)((Component)((Object)this.tree)), (int)2)).addToBottom((Component)statusPanel);
        Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel, (String)"simplePanel(createScroll\u2026.addToBottom(statusPanel)");
        BorderLayoutPanel treePanel = borderLayoutPanel;
        this.progressStripe = new ProgressStripe((JComponent)treePanel, (Disposable)this, 300);
        OnePixelSplitter treeMessageSplitter = new OnePixelSplitter(true, "git.stage.tree.message.splitter", 0.7f);
        treeMessageSplitter.setFirstComponent((JComponent)this.progressStripe);
        treeMessageSplitter.setSecondComponent((JComponent)((Object)this.commitPanel));
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)this.toolbar.getComponent(), "North");
        leftPanel.add((Component)treeMessageSplitter, "Center");
        this.commitDiffSplitter = new OnePixelSplitter("git.stage.commit.diff.splitter", 0.5f);
        this.commitDiffSplitter.setFirstComponent((JComponent)leftPanel);
        this.add((Component)this.commitDiffSplitter, "Center");
        this.setDiffPreviewInEditor(isEditorDiffPreview, true);
        this.tracker.addListener(new MyGitStageTrackerListener(), this);
        this.project.getMessageBus().connect((Disposable)this).subscribe(GitChangeProvider.TOPIC, (Object)new MyGitChangeProviderListener());
        GitVcs gitVcs = GitVcs.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitVcs), (String)"GitVcs.getInstance(project)");
        GitChangeProvider gitChangeProvider = gitVcs.getChangeProvider();
        if (gitChangeProvider != null) {
            if (gitChangeProvider.isRefreshInProgress()) {
                this.tree.setEmptyText(GitBundle.message("stage.loading.status", new Object[0]));
                this.progressStripe.startLoadingImmediately();
            }
        }
        Disposer.register((Disposable)disposableParent, (Disposable)this);
        BaseSingleTaskControllerKt.runInEdtAsync((Disposable)this, (Function0)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.getTree().rebuildTree();
            }
        }));
    }

    public static final /* synthetic */ ProgressStripe access$getProgressStripe$p(GitStagePanel $this) {
        return $this.progressStripe;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0006\u0010\u0018\u001a\u00020\u0015J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001e\u0010\u001c\u001a\u00020\u00152\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\b2\u0006\u0010\u001f\u001a\u00020\rH\u0016J\u0016\u0010 \u001a\u00020\u00152\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\bH\u0016R&\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lgit4idea/index/ui/GitStagePanel$MyChangesTree;", "Lgit4idea/index/ui/GitStageTree;", "project", "Lcom/intellij/openapi/project/Project;", "(Lgit4idea/index/ui/GitStagePanel;Lcom/intellij/openapi/project/Project;)V", "ignoredFilePaths", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "Lcom/intellij/openapi/vcs/FilePath;", "getIgnoredFilePaths", "()Ljava/util/Map;", "operations", "Lgit4idea/index/actions/StagingAreaOperation;", "getOperations", "()Ljava/util/List;", "state", "Lgit4idea/index/GitStageTracker$State;", "getState", "()Lgit4idea/index/GitStageTracker$State;", "customizeTreeModel", "", "builder", "Lcom/intellij/openapi/vcs/changes/ui/TreeModelBuilder;", "editedCommitChanged", "getDndOperation", "targetKind", "Lgit4idea/index/ui/NodeKind;", "performStageOperation", "nodes", "Lgit4idea/index/ui/GitFileStatusNode;", "operation", "showMergeDialog", "conflictedFiles", "intellij.vcs.git"})
    private final class MyChangesTree
    extends GitStageTree {
        @NotNull
        private final List<StagingAreaOperation> operations;

        @Override
        @NotNull
        protected GitStageTracker.State getState() {
            return GitStagePanel.this.getState();
        }

        @Override
        @NotNull
        protected Map<VirtualFile, List<FilePath>> getIgnoredFilePaths() {
            return GitStagePanel.this.tracker.getIgnoredPaths();
        }

        @Override
        @NotNull
        protected List<StagingAreaOperation> getOperations() {
            return this.operations;
        }

        public final void editedCommitChanged() {
            block1: {
                DefaultMutableTreeNode node2;
                this.rebuildTree();
                EditedCommitDetails editedCommitDetails = GitStagePanel.this.commitPanel.getEditedCommit();
                if (editedCommitDetails == null) break block1;
                EditedCommitDetails editedCommitDetails2 = editedCommitDetails;
                boolean bl = false;
                boolean bl2 = false;
                EditedCommitDetails it = editedCommitDetails2;
                boolean bl3 = false;
                DefaultMutableTreeNode defaultMutableTreeNode = node2 = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)((DefaultMutableTreeNode)this.getRoot()), (Object)it);
                if (defaultMutableTreeNode != null) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    DefaultMutableTreeNode it2 = defaultMutableTreeNode2;
                    boolean bl6 = false;
                    this.expandPath(TreeUtil.getPathFromRoot((TreeNode)node2));
                }
            }
        }

        @Override
        protected void customizeTreeModel(@NotNull TreeModelBuilder builder) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                super.customizeTreeModel(builder);
                EditedCommitDetails editedCommitDetails = GitStagePanel.this.commitPanel.getEditedCommit();
                if (editedCommitDetails == null) break block0;
                EditedCommitDetails editedCommitDetails2 = editedCommitDetails;
                boolean bl = false;
                boolean bl2 = false;
                EditedCommitDetails it = editedCommitDetails2;
                boolean bl3 = false;
                EditedCommitNode commitNode = new EditedCommitNode(it);
                builder.insertSubtreeRoot((ChangesBrowserNode)commitNode);
                builder.insertChanges(it.getCommit().getChanges(), (ChangesBrowserNode)commitNode);
            }
        }

        @Override
        public void performStageOperation(@NotNull List<GitFileStatusNode> nodes2, @NotNull StagingAreaOperation operation) {
            Intrinsics.checkNotNullParameter(nodes2, (String)"nodes");
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            StagingAreaOperationActionKt.performStageOperation(project, nodes2, operation);
        }

        @Override
        @Nullable
        public StagingAreaOperation getDndOperation(@NotNull NodeKind targetKind) {
            StagingAreaOperation stagingAreaOperation;
            Intrinsics.checkNotNullParameter((Object)((Object)targetKind), (String)"targetKind");
            switch (GitStagePanel$MyChangesTree$WhenMappings.$EnumSwitchMapping$0[targetKind.ordinal()]) {
                case 1: {
                    stagingAreaOperation = GitAddOperation.INSTANCE;
                    break;
                }
                case 2: {
                    stagingAreaOperation = GitResetOperation.INSTANCE;
                    break;
                }
                default: {
                    stagingAreaOperation = null;
                }
            }
            return stagingAreaOperation;
        }

        @Override
        public void showMergeDialog(@NotNull List<? extends VirtualFile> conflictedFiles2) {
            Intrinsics.checkNotNullParameter(conflictedFiles2, (String)"conflictedFiles");
            AbstractVcsHelper.getInstance((Project)this.getProject()).showMergeDialog(conflictedFiles2);
        }

        public MyChangesTree(Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(GitStageUiSettingsImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            super(project, (GitStageUiSettings)object, GitStagePanel.this);
            this.operations = CollectionsKt.listOf((Object[])new StagingAreaOperation[]{GitAddOperation.INSTANCE, GitResetOperation.INSTANCE});
            this.setDoubleClickHandler((Processor)new Processor<MouseEvent>(){

                public final boolean process(MouseEvent e) {
                    if (EditSourceOnDoubleClickHandler.isToggleEvent((JTree)((JTree)((Object)this)), (MouseEvent)e)) {
                        return false;
                    }
                    DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)this));
                    Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"DataManager.getInstance().getDataContext(this)");
                    DataContext dataContext2 = dataContext;
                    AnAction mergeAction = ActionManager.getInstance().getAction("Git.Stage.Merge");
                    AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)mergeAction, (InputEvent)e, (String)"unknown", (DataContext)dataContext2);
                    Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"AnActionEvent.createFrom\u2026ces.UNKNOWN, dataContext)");
                    AnActionEvent event = anActionEvent;
                    if (ActionUtil.lastUpdateAndCheckDumb((AnAction)mergeAction, (AnActionEvent)event, (boolean)true)) {
                        ActionUtil.performActionDumbAwareWithCallbacks((AnAction)mergeAction, (AnActionEvent)event, (DataContext)dataContext2);
                    } else {
                        OpenSourceUtil.openSourcesFrom((DataContext)dataContext2, (boolean)true);
                    }
                    return true;
                }
            });
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lgit4idea/index/ui/GitStagePanel$MyGitStageTrackerListener;", "Lgit4idea/index/GitStageTrackerListener;", "(Lgit4idea/index/ui/GitStagePanel;)V", "update", "", "intellij.vcs.git"})
    private final class MyGitStageTrackerListener
    implements GitStageTrackerListener {
        @Override
        public void update() {
            GitStagePanel.this.update();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lgit4idea/index/ui/GitStagePanel$MyGitChangeProviderListener;", "Lgit4idea/status/GitChangeProvider$ChangeProviderListener;", "(Lgit4idea/index/ui/GitStagePanel;)V", "progressStarted", "", "progressStopped", "repositoryUpdated", "repository", "Lgit4idea/repo/GitRepository;", "intellij.vcs.git"})
    private final class MyGitChangeProviderListener
    implements GitChangeProvider.ChangeProviderListener {
        @Override
        public void progressStarted() {
            BaseSingleTaskControllerKt.runInEdt((Disposable)GitStagePanel.this, (Function0)((Function0)new Function0<Unit>(this){
                final /* synthetic */ MyGitChangeProviderListener this$0;

                public final void invoke() {
                    this.this$0.GitStagePanel.this.getTree().setEmptyText(GitBundle.message("stage.loading.status", new Object[0]));
                    GitStagePanel.access$getProgressStripe$p(this.this$0.GitStagePanel.this).startLoading();
                }
                {
                    this.this$0 = myGitChangeProviderListener;
                    super(0);
                }
            }));
        }

        @Override
        public void progressStopped() {
            BaseSingleTaskControllerKt.runInEdt((Disposable)GitStagePanel.this, (Function0)((Function0)new Function0<Unit>(this){
                final /* synthetic */ MyGitChangeProviderListener this$0;

                public final void invoke() {
                    GitStagePanel.access$getProgressStripe$p(this.this$0.GitStagePanel.this).stopLoading();
                    this.this$0.GitStagePanel.this.getTree().setEmptyText("");
                }
                {
                    this.this$0 = myGitChangeProviderListener;
                    super(0);
                }
            }));
        }

        @Override
        public void repositoryUpdated(@NotNull GitRepository repository) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        }
    }
}

