/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import git4idea.commands.GitHandler;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001b2\u00020\u0001:\u0004\u001b\u001c\u001d\u001eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH&J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u000fH&J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bH&R\u0017\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\u0082\u0001\u0003\u001f !\u00a8\u0006\""}, d2={"Lgit4idea/config/GitExecutable;", "", "()V", "exePath", "", "Lorg/jetbrains/annotations/NonNls;", "getExePath", "()Ljava/lang/String;", "id", "getId", "isLocal", "", "()Z", "convertFilePath", "file", "Ljava/io/File;", "convertFilePathBack", "path", "workingDir", "patchCommandLine", "", "handler", "Lgit4idea/commands/GitHandler;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "withLowPriority", "withNoTty", "Companion", "Local", "Unknown", "Wsl", "Lgit4idea/config/GitExecutable$Local;", "Lgit4idea/config/GitExecutable$Wsl;", "Lgit4idea/config/GitExecutable$Unknown;", "intellij.vcs.git"})
public abstract class GitExecutable {
    @NonNls
    private static final String CYGDRIVE_PREFIX = "/cygdrive/";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract String getId();

    @NotNull
    public abstract String getExePath();

    public abstract boolean isLocal();

    @NotNull
    public abstract String convertFilePath(@NotNull File var1);

    @NotNull
    public abstract File convertFilePathBack(@NotNull String var1, @NotNull File var2);

    public abstract void patchCommandLine(@NotNull GitHandler var1, @NotNull GeneralCommandLine var2, boolean var3, boolean var4) throws ExecutionException;

    private GitExecutable() {
    }

    public /* synthetic */ GitExecutable(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0013\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J(\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\nH\u0016J\b\u0010!\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000b\u00a8\u0006\""}, d2={"Lgit4idea/config/GitExecutable$Local;", "Lgit4idea/config/GitExecutable;", "exePath", "", "(Ljava/lang/String;)V", "getExePath", "()Ljava/lang/String;", "id", "getId", "isLocal", "", "()Z", "component1", "convertFilePath", "file", "Ljava/io/File;", "convertFilePathBack", "path", "workingDir", "copy", "equals", "other", "", "hashCode", "", "patchCommandLine", "", "handler", "Lgit4idea/commands/GitHandler;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "withLowPriority", "withNoTty", "toString", "intellij.vcs.git"})
    public static final class Local
    extends GitExecutable {
        @NotNull
        private final String id;
        private final boolean isLocal;
        @NotNull
        private final String exePath;

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        public boolean isLocal() {
            return this.isLocal;
        }

        @NotNull
        public String toString() {
            return this.getExePath();
        }

        @Override
        @NotNull
        public String convertFilePath(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String string = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.absolutePath");
            return string;
        }

        @Override
        @NotNull
        public File convertFilePathBack(@NotNull String path, @NotNull File workingDir) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            if (SystemInfo.isWindows && StringsKt.startsWith$default((String)path, (String)GitExecutable.CYGDRIVE_PREFIX, (boolean)false, (int)2, null)) {
                int prefixSize = GitExecutable.CYGDRIVE_PREFIX.length();
                StringBuilder stringBuilder = new StringBuilder();
                String string = path;
                int n = prefixSize + 1;
                boolean bl = false;
                String string2 = string.substring(prefixSize, n);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                StringBuilder stringBuilder2 = stringBuilder.append(string2).append(":");
                string = path;
                n = prefixSize + 1;
                bl = false;
                String string3 = string.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                String localPath = stringBuilder2.append(string3).toString();
                return new File(localPath);
            }
            return FilesKt.resolve((File)workingDir, (String)path);
        }

        @Override
        public void patchCommandLine(@NotNull GitHandler handler, @NotNull GeneralCommandLine commandLine, boolean withLowPriority, boolean withNoTty) {
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
            if (withLowPriority) {
                ExecUtil.setupLowPriorityExecution((GeneralCommandLine)commandLine);
            }
            if (withNoTty) {
                ExecUtil.setupNoTtyExecution((GeneralCommandLine)commandLine);
            }
        }

        @Override
        @NotNull
        public String getExePath() {
            return this.exePath;
        }

        public Local(@NotNull String exePath) {
            Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
            super(null);
            this.exePath = exePath;
            this.id = "local";
            this.isLocal = true;
        }

        @NotNull
        public final String component1() {
            return this.getExePath();
        }

        @NotNull
        public final Local copy(@NotNull String exePath) {
            Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
            return new Local(exePath);
        }

        public static /* synthetic */ Local copy$default(Local local, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = local.getExePath();
            }
            return local.copy(string);
        }

        public int hashCode() {
            String string = this.getExePath();
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Local)) break block3;
                    Local local = (Local)object;
                    if (!Intrinsics.areEqual((Object)this.getExePath(), (Object)local.getExePath())) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u001d\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u000eH\u0016J\b\u0010&\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000f\u00a8\u0006'"}, d2={"Lgit4idea/config/GitExecutable$Wsl;", "Lgit4idea/config/GitExecutable;", "exePath", "", "distribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "(Ljava/lang/String;Lcom/intellij/execution/wsl/WSLDistribution;)V", "getDistribution", "()Lcom/intellij/execution/wsl/WSLDistribution;", "getExePath", "()Ljava/lang/String;", "id", "getId", "isLocal", "", "()Z", "component1", "component2", "convertFilePath", "file", "Ljava/io/File;", "convertFilePathBack", "path", "workingDir", "copy", "equals", "other", "", "hashCode", "", "patchCommandLine", "", "handler", "Lgit4idea/commands/GitHandler;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "withLowPriority", "withNoTty", "toString", "intellij.vcs.git"})
    public static final class Wsl
    extends GitExecutable {
        @NotNull
        private final String id;
        private final boolean isLocal;
        @NotNull
        private final String exePath;
        @NotNull
        private final WSLDistribution distribution;

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        public boolean isLocal() {
            return this.isLocal;
        }

        @NotNull
        public String toString() {
            return this.distribution.getPresentableName() + ": " + this.getExePath();
        }

        @Override
        @NotNull
        public String convertFilePath(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String path = file.getAbsolutePath();
            String wslPath = this.distribution.getWslPath(path);
            if (wslPath != null) {
                return wslPath;
            }
            File file2 = this.distribution.getUNCRoot();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"distribution.uncRoot");
            File uncRoot = file2;
            if (FileUtil.isAncestor((File)uncRoot, (File)file, (boolean)false)) {
                String string = StringUtil.trimStart((String)FileUtil.toSystemIndependentName((String)path), (String)FileUtil.toSystemIndependentName((String)uncRoot.getPath()));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.trimStart(Fil\u2026endentName(uncRoot.path))");
                return string;
            }
            String string = path;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
            return string;
        }

        @Override
        @NotNull
        public File convertFilePathBack(@NotNull String path, @NotNull File workingDir) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            String localPath = this.distribution.getWindowsPath(path);
            if (localPath != null) {
                return new File(localPath);
            }
            return new File(this.distribution.getUNCRoot(), path);
        }

        @Override
        public void patchCommandLine(@NotNull GitHandler handler, @NotNull GeneralCommandLine commandLine, boolean withLowPriority, boolean withNoTty) {
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
            if (withNoTty) {
                String string = commandLine.getExePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"commandLine.exePath");
                String executablePath = string;
                commandLine.setExePath("setsid");
                if (Registry.is((String)"git.use.setsid.wait.for.wsl.ssh")) {
                    commandLine.getParametersList().prependAll(new String[]{"-w", executablePath});
                } else {
                    commandLine.getParametersList().prependAll(new String[]{executablePath});
                }
            }
            WSLCommandLineOptions options = new WSLCommandLineOptions();
            if (Registry.is((String)"git.wsl.exe.executable.no.shell")) {
                options.setLaunchWithWslExe(true);
                options.setExecuteCommandInShell(false);
                options.setPassEnvVarsUsingInterop(true);
            }
            this.distribution.patchCommandLine(commandLine, handler.project(), options);
        }

        @Override
        @NotNull
        public String getExePath() {
            return this.exePath;
        }

        @NotNull
        public final WSLDistribution getDistribution() {
            return this.distribution;
        }

        public Wsl(@NotNull String exePath, @NotNull WSLDistribution distribution) {
            Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
            Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
            super(null);
            this.exePath = exePath;
            this.distribution = distribution;
            this.id = "wsl-" + this.distribution.getId();
        }

        @NotNull
        public final String component1() {
            return this.getExePath();
        }

        @NotNull
        public final WSLDistribution component2() {
            return this.distribution;
        }

        @NotNull
        public final Wsl copy(@NotNull String exePath, @NotNull WSLDistribution distribution) {
            Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
            Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
            return new Wsl(exePath, distribution);
        }

        public static /* synthetic */ Wsl copy$default(Wsl wsl, String string, WSLDistribution wSLDistribution, int n, Object object) {
            if ((n & 1) != 0) {
                string = wsl.getExePath();
            }
            if ((n & 2) != 0) {
                wSLDistribution = wsl.distribution;
            }
            return wsl.copy(string, wSLDistribution);
        }

        public int hashCode() {
            String string = this.getExePath();
            WSLDistribution wSLDistribution = this.distribution;
            return (string != null ? string.hashCode() : 0) * 31 + (wSLDistribution != null ? wSLDistribution.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Wsl)) break block3;
                    Wsl wsl = (Wsl)object;
                    if (!Intrinsics.areEqual((Object)this.getExePath(), (Object)wsl.getExePath()) || !Intrinsics.areEqual((Object)this.distribution, (Object)wsl.distribution)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\"\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000b\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\u0011\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006H\u00c6\u0003J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J,\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\r\b\u0002\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\rH\u0016J\b\u0010&\u001a\u00020\u0003H\u0016R\u0016\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000e\u00a8\u0006'"}, d2={"Lgit4idea/config/GitExecutable$Unknown;", "Lgit4idea/config/GitExecutable;", "id", "", "exePath", "errorMessage", "Lorg/jetbrains/annotations/Nls;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getErrorMessage", "()Ljava/lang/String;", "getExePath", "getId", "isLocal", "", "()Z", "component1", "component2", "component3", "convertFilePath", "file", "Ljava/io/File;", "convertFilePathBack", "path", "workingDir", "copy", "equals", "other", "", "hashCode", "", "patchCommandLine", "", "handler", "Lgit4idea/commands/GitHandler;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "withLowPriority", "withNoTty", "toString", "intellij.vcs.git"})
    public static final class Unknown
    extends GitExecutable {
        private final boolean isLocal;
        @NotNull
        private final String id;
        @NotNull
        private final String exePath;
        @NotNull
        private final String errorMessage;

        @Override
        public boolean isLocal() {
            return this.isLocal;
        }

        @NotNull
        public String toString() {
            return this.getId() + ": " + this.getExePath();
        }

        @Override
        @NotNull
        public String convertFilePath(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String string = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.absolutePath");
            return string;
        }

        @Override
        @NotNull
        public File convertFilePathBack(@NotNull String path, @NotNull File workingDir) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            return new File(path);
        }

        @Override
        public void patchCommandLine(@NotNull GitHandler handler, @NotNull GeneralCommandLine commandLine, boolean withLowPriority, boolean withNoTty) {
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
            throw (Throwable)new ExecutionException(this.errorMessage);
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public String getExePath() {
            return this.exePath;
        }

        @NotNull
        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public Unknown(@NotNull String id, @NotNull String exePath, @NotNull String errorMessage) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
            Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
            super(null);
            this.id = id;
            this.exePath = exePath;
            this.errorMessage = errorMessage;
        }

        @NotNull
        public final String component1() {
            return this.getId();
        }

        @NotNull
        public final String component2() {
            return this.getExePath();
        }

        @NotNull
        public final String component3() {
            return this.errorMessage;
        }

        @NotNull
        public final Unknown copy(@NotNull String id, @NotNull String exePath, @NotNull String errorMessage) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
            Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
            return new Unknown(id, exePath, errorMessage);
        }

        public static /* synthetic */ Unknown copy$default(Unknown unknown, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = unknown.getId();
            }
            if ((n & 2) != 0) {
                string2 = unknown.getExePath();
            }
            if ((n & 4) != 0) {
                string3 = unknown.errorMessage;
            }
            return unknown.copy(string, string2, string3);
        }

        public int hashCode() {
            String string = this.getId();
            String string2 = this.getExePath();
            String string3 = this.errorMessage;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Unknown)) break block3;
                    Unknown unknown = (Unknown)object;
                    if (!Intrinsics.areEqual((Object)this.getId(), (Object)unknown.getId()) || !Intrinsics.areEqual((Object)this.getExePath(), (Object)unknown.getExePath()) || !Intrinsics.areEqual((Object)this.errorMessage, (Object)unknown.errorMessage)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgit4idea/config/GitExecutable$Companion;", "", "()V", "CYGDRIVE_PREFIX", "", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

