/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.CredentialPromptDialog;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ssh.SSHUtil;
import com.intellij.util.PathUtil;
import git4idea.commands.GitAuthenticationGate;
import git4idea.commands.GitAuthenticationMode;
import git4idea.commands.GitNativeSshAuthenticator;
import git4idea.i18n.GitBundle;
import java.util.regex.Matcher;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitNativeSshGuiAuthenticator
implements GitNativeSshAuthenticator {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitAuthenticationGate myAuthenticationGate;
    @NotNull
    private final GitAuthenticationMode myAuthenticationMode;
    private final boolean myDoNotRememberPasswords;
    @Nullable
    private String myLastAskedKeyPath;
    @Nullable
    private String myLastAskedUserName;
    @Nullable
    private String myLastAskedConfirmationInput;

    GitNativeSshGuiAuthenticator(@NotNull Project project, @NotNull GitAuthenticationGate authenticationGate, @NotNull GitAuthenticationMode authenticationMode, boolean doNotRememberPasswords) {
        if (project == null) {
            GitNativeSshGuiAuthenticator.$$$reportNull$$$0(0);
        }
        if (authenticationGate == null) {
            GitNativeSshGuiAuthenticator.$$$reportNull$$$0(1);
        }
        if (authenticationMode == null) {
            GitNativeSshGuiAuthenticator.$$$reportNull$$$0(2);
        }
        this.myLastAskedKeyPath = null;
        this.myLastAskedUserName = null;
        this.myLastAskedConfirmationInput = null;
        this.myProject = project;
        this.myAuthenticationGate = authenticationGate;
        this.myAuthenticationMode = authenticationMode;
        this.myDoNotRememberPasswords = doNotRememberPasswords;
    }

    @Override
    @Nullable
    public String handleInput(@NotNull @NlsSafe String description) {
        if (description == null) {
            GitNativeSshGuiAuthenticator.$$$reportNull$$$0(3);
        }
        if (this.myAuthenticationMode == GitAuthenticationMode.NONE) {
            return null;
        }
        return this.myAuthenticationGate.waitAndCompute(() -> {
            if (GitNativeSshGuiAuthenticator.isKeyPassphrase(description)) {
                return this.askKeyPassphraseInput(description);
            }
            if (GitNativeSshGuiAuthenticator.isSshPassword(description)) {
                return this.askSshPasswordInput(description);
            }
            if (GitNativeSshGuiAuthenticator.isConfirmation(description)) {
                return this.askConfirmationInput(description);
            }
            return this.askGenericInput(description);
        });
    }

    private static boolean isKeyPassphrase(@NotNull String description) {
        if (description == null) {
            GitNativeSshGuiAuthenticator.$$$reportNull$$$0(4);
        }
        return SSHUtil.PASSPHRASE_PROMPT.matcher(description).matches();
    }

    @Nullable
    private String askKeyPassphraseInput(@NotNull String description) {
        Matcher matcher;
        if (description == null) {
            GitNativeSshGuiAuthenticator.$$$reportNull$$$0(5);
        }
        if (!(matcher = SSHUtil.PASSPHRASE_PROMPT.matcher(description)).matches()) {
            throw new IllegalStateException(description);
        }
        String keyPath = matcher.group(1);
        boolean resetPassword = keyPath.equals(this.myLastAskedKeyPath);
        this.myLastAskedKeyPath = keyPath;
        if (this.myDoNotRememberPasswords) {
            return this.askUser((Computable<String>)((Computable)() -> {
                String message = GitBundle.message("ssh.ask.passphrase.message", PathUtil.getFileName((String)keyPath));
                return Messages.showPasswordDialog((Project)this.myProject, (String)message, (String)GitBundle.getString("ssh.ask.passphrase.title"), null);
            }));
        }
        return GitNativeSshGuiAuthenticator.askPassphrase(this.myProject, keyPath, resetPassword, this.myAuthenticationMode);
    }

    private static boolean isSshPassword(@NotNull String description) {
        if (description == null) {
            GitNativeSshGuiAuthenticator.$$$reportNull$$$0(6);
        }
        return SSHUtil.PASSWORD_PROMPT.matcher(description).matches();
    }

    @Nullable
    private String askSshPasswordInput(@NotNull String description) {
        Matcher matcher;
        if (description == null) {
            GitNativeSshGuiAuthenticator.$$$reportNull$$$0(7);
        }
        if (!(matcher = SSHUtil.PASSWORD_PROMPT.matcher(description)).matches()) {
            throw new IllegalStateException(description);
        }
        String username = matcher.group(1);
        boolean resetPassword = username.equals(this.myLastAskedUserName);
        this.myLastAskedUserName = username;
        if (this.myDoNotRememberPasswords) {
            return this.askUser((Computable<String>)((Computable)() -> {
                String message = GitBundle.message("ssh.password.message", username);
                return Messages.showPasswordDialog((Project)this.myProject, (String)message, (String)GitBundle.getString("ssh.password.title"), null);
            }));
        }
        return GitNativeSshGuiAuthenticator.askPassword(this.myProject, username, resetPassword, this.myAuthenticationMode);
    }

    private static boolean isConfirmation(@NotNull @NlsSafe String description) {
        if (description == null) {
            GitNativeSshGuiAuthenticator.$$$reportNull$$$0(8);
        }
        return description.contains("Are you sure you want to continue connecting");
    }

    @Nullable
    private String askConfirmationInput(@NotNull @NlsSafe String description) {
        if (description == null) {
            GitNativeSshGuiAuthenticator.$$$reportNull$$$0(9);
        }
        return this.askUser((Computable<String>)((Computable)() -> {
            String textAnswer;
            @NlsSafe String message = StringUtil.replace((String)description, (String)"Are you sure you want to continue connecting (yes/no)?", (String)"Are you sure you want to continue connecting?");
            String knownAnswer = this.myAuthenticationGate.getSavedInput(message);
            if (knownAnswer != null && this.myLastAskedConfirmationInput == null) {
                this.myLastAskedConfirmationInput = knownAnswer;
                return knownAnswer;
            }
            int answer = Messages.showYesNoDialog((Project)this.myProject, (String)message, (String)GitBundle.message("title.ssh.confirmation", new Object[0]), null);
            if (answer == 0) {
                textAnswer = "yes";
            } else if (answer == 1) {
                textAnswer = "no";
            } else {
                throw new AssertionError(answer);
            }
            this.myAuthenticationGate.saveInput(message, textAnswer);
            return textAnswer;
        }));
    }

    @Nullable
    private String askGenericInput(@NotNull @Nls String description) {
        if (description == null) {
            GitNativeSshGuiAuthenticator.$$$reportNull$$$0(10);
        }
        return this.askUser((Computable<String>)((Computable)() -> Messages.showPasswordDialog((Project)this.myProject, (String)description, (String)GitBundle.message("ssh.keyboard.interactive.title", new Object[0]), null)));
    }

    @Nullable
    private String askUser(@NotNull Computable<String> query) {
        if (query == null) {
            GitNativeSshGuiAuthenticator.$$$reportNull$$$0(11);
        }
        if (this.myAuthenticationMode != GitAuthenticationMode.FULL) {
            return null;
        }
        Ref answerRef = new Ref();
        ApplicationManager.getApplication().invokeAndWait(() -> answerRef.set((Object)((String)query.compute())), ModalityState.any());
        return (String)answerRef.get();
    }

    @NonNls
    @Nullable
    private static String askPassphrase(@Nullable Project project, @NotNull @NlsSafe String keyPath, boolean resetPassword, @NotNull GitAuthenticationMode authenticationMode) {
        String password;
        if (keyPath == null) {
            GitNativeSshGuiAuthenticator.$$$reportNull$$$0(12);
        }
        if (authenticationMode == null) {
            GitNativeSshGuiAuthenticator.$$$reportNull$$$0(13);
        }
        if (authenticationMode == GitAuthenticationMode.NONE) {
            return null;
        }
        CredentialAttributes newAttributes = GitNativeSshGuiAuthenticator.passphraseCredentialAttributes(keyPath);
        Credentials credentials = PasswordSafe.getInstance().get(newAttributes);
        if (credentials != null && !resetPassword && (password = credentials.getPasswordAsString()) != null && !password.isEmpty()) {
            return password;
        }
        if (authenticationMode == GitAuthenticationMode.SILENT) {
            return null;
        }
        return CredentialPromptDialog.askPassword((Project)project, (String)GitBundle.getString("ssh.ask.passphrase.title"), (String)GitBundle.message("ssh.ask.passphrase.message", PathUtil.getFileName((String)keyPath)), (CredentialAttributes)newAttributes, (boolean)true);
    }

    @NonNls
    @Nullable
    private static String askPassword(@Nullable Project project, @NotNull @NlsSafe String username, boolean resetPassword, @NotNull GitAuthenticationMode authenticationMode) {
        String password;
        if (username == null) {
            GitNativeSshGuiAuthenticator.$$$reportNull$$$0(14);
        }
        if (authenticationMode == null) {
            GitNativeSshGuiAuthenticator.$$$reportNull$$$0(15);
        }
        if (authenticationMode == GitAuthenticationMode.NONE) {
            return null;
        }
        CredentialAttributes newAttributes = GitNativeSshGuiAuthenticator.passwordCredentialAttributes(username);
        Credentials credentials = PasswordSafe.getInstance().get(newAttributes);
        if (credentials != null && !resetPassword && (password = credentials.getPasswordAsString()) != null) {
            return password;
        }
        if (authenticationMode == GitAuthenticationMode.SILENT) {
            return null;
        }
        return CredentialPromptDialog.askPassword((Project)project, (String)GitBundle.getString("ssh.password.title"), (String)GitBundle.message("ssh.password.message", username), (CredentialAttributes)newAttributes, (boolean)true);
    }

    @NotNull
    private static CredentialAttributes passphraseCredentialAttributes(@NotNull @Nls String key) {
        if (key == null) {
            GitNativeSshGuiAuthenticator.$$$reportNull$$$0(16);
        }
        return new CredentialAttributes(CredentialAttributesKt.generateServiceName((String)GitBundle.message("label.credential.store.key.ssh.passphrase", new Object[0]), (String)key), key);
    }

    @NotNull
    private static CredentialAttributes passwordCredentialAttributes(@NotNull @Nls String key) {
        if (key == null) {
            GitNativeSshGuiAuthenticator.$$$reportNull$$$0(17);
        }
        return new CredentialAttributes(CredentialAttributesKt.generateServiceName((String)GitBundle.message("label.credential.store.key.ssh.password", new Object[0]), (String)key), key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authenticationGate";
                break;
            }
            case 2: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authenticationMode";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyPath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "username";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "git4idea/commands/GitNativeSshGuiAuthenticator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInput";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isKeyPassphrase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "askKeyPassphraseInput";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isSshPassword";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "askSshPasswordInput";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isConfirmation";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "askConfirmationInput";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "askGenericInput";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "askUser";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "askPassphrase";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "askPassword";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "passphraseCredentialAttributes";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "passwordCredentialAttributes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

