/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.mvstore;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import net.jpountz.lz4.LZ4Compressor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.integratedBinaryPacking.IntBitPacker;
import org.jetbrains.mvstore.Chunk;
import org.jetbrains.mvstore.CursorPos;
import org.jetbrains.mvstore.DataUtil;
import org.jetbrains.mvstore.KeyManager;
import org.jetbrains.mvstore.LeafPage;
import org.jetbrains.mvstore.MVMap;
import org.jetbrains.mvstore.MVStore;
import org.jetbrains.mvstore.MVStoreException;
import org.jetbrains.mvstore.ObjectKeyManager;

abstract class Page<K, V>
implements Cloneable {
    protected static final int PAGE_TYPE_NODE = 1;
    static final int PAGE_COMPRESSED = 2;
    static final int PAGE_COMPRESSED_HIGH = 6;
    final MVMap<K, V> map;
    private volatile long position;
    int pageNo;
    private int cachedCompare;
    protected int memory;
    protected final KeyManager<K> keyManager;
    private static final AtomicLongFieldUpdater<Page> pageInfoUpdater = AtomicLongFieldUpdater.newUpdater(Page.class, "position");
    protected static final int PAGE_MEMORY = 22;
    protected static final int IN_MEMORY = Integer.MIN_VALUE;

    protected Page(MVMap<K, V> map2, long info, ByteBuf buf, int chunkId) {
        this.pageNo = -1;
        this.map = map2;
        this.position = info;
        int offset = DataUtil.getPageOffset(info);
        int pageStartReaderIndex = buf.readerIndex();
        int pageLength = buf.readInt();
        int remaining = buf.readableBytes() + 4;
        if (pageLength > remaining || pageLength < 4) {
            throw new MVStoreException(6, "File corrupted in chunk " + chunkId + ", expected page length 4.." + remaining + ", got " + pageLength);
        }
        int writerIndexToRestore = buf.writerIndex();
        buf.writerIndex(pageStartReaderIndex + pageLength);
        short check = buf.readShort();
        int checkTest = DataUtil.getCheckValue(chunkId) ^ DataUtil.getCheckValue(offset) ^ DataUtil.getCheckValue(pageLength);
        if (check != (short)checkTest) {
            throw new MVStoreException(6, "File corrupted in chunk " + chunkId + ", expected check value " + checkTest + ", got " + check);
        }
        int mapId = IntBitPacker.readVar(buf);
        if (mapId != this.map.getId()) {
            throw new MVStoreException(6, "File corrupted in chunk " + chunkId + ", expected map id " + this.map.getId() + ", got " + mapId);
        }
        this.pageNo = IntBitPacker.readVar(buf);
        int keyCount = IntBitPacker.readVar(buf);
        byte type = buf.readByte();
        if (this.isLeaf() != ((type & 1) == 0)) {
            throw new MVStoreException(6, "File corrupted in chunk " + chunkId + ", expected node type " + (this.isLeaf() ? "0" : "1") + ", got " + type);
        }
        this.keyManager = this.readPayload(buf, keyCount, (type & 2) != 0, pageLength, pageStartReaderIndex);
        buf.writerIndex(writerIndexToRestore);
        this.memory = this.calculateMemory();
    }

    protected Page(@NotNull MVMap<K, V> map2, @NotNull KeyManager<K> keyManager, int memory) {
        if (map2 == null) {
            Page.$$$reportNull$$$0(0);
        }
        if (keyManager == null) {
            Page.$$$reportNull$$$0(1);
        }
        this.pageNo = -1;
        this.map = map2;
        this.keyManager = keyManager;
        this.memory = memory;
    }

    static <K, V> Page<K, V> createEmptyLeaf(MVMap<K, V> map2) {
        return new LeafPage<K, Object>(map2, map2.getKeyType().createEmptyManager(map2), ObjectKeyManager.EMPTY_OBJECT_ARRAY, 0);
    }

    static <K, V> LeafPage<K, V> createLeaf(MVMap<K, V> map2, @NotNull KeyManager<K> keys, V[] values) {
        if (keys == null) {
            Page.$$$reportNull$$$0(2);
        }
        return new LeafPage<K, V>(map2, keys, values, 22 + map2.getValueType().getMemory(values));
    }

    static <K, V> V get(Page<K, V> p, K key) {
        while (true) {
            int index = p.binarySearch(key);
            if (p.isLeaf()) {
                return index >= 0 ? (V)p.getValue(index) : null;
            }
            if (index++ < 0) {
                index = -index;
            }
            p = p.getChildPage(index);
        }
    }

    public final int getMapId() {
        return this.map.getId();
    }

    abstract Page<K, V> copy(MVMap<K, V> var1);

    public K getKey(int index) {
        return this.keyManager.getKey(index);
    }

    public abstract Page<K, V> getChildPage(int var1);

    public abstract long getChildPagePos(int var1);

    public abstract V getValue(int var1);

    public final int getKeyCount() {
        return this.keyManager.getKeyCount();
    }

    public final boolean isLeaf() {
        return this.getNodeType() == 0;
    }

    public abstract int getNodeType();

    public final long getPosition() {
        return this.position;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        this.dump(buff);
        buff.append(')');
        return buff.toString();
    }

    protected void dump(StringBuilder buff) {
        buff.append("Page(identityHashCode=").append(System.identityHashCode(this));
        long position = this.position;
        buff.append(", position=");
        if (position == 0L) {
            buff.append("not saved");
        } else if (position == 1L) {
            buff.append("removed");
        } else {
            buff.append(position);
            buff.append(", offset=").append(DataUtil.getPageOffset(position));
        }
        if (this.isSaved()) {
            buff.append(", chunk: ").append(DataUtil.getPageChunkId(position));
        }
    }

    final int binarySearch(K key) {
        int result = this.keyManager.binarySearch(key, this.map, this.cachedCompare);
        this.cachedCompare = result < 0 ? ~result : result + 1;
        return result;
    }

    abstract Page<K, V> split(int var1, boolean var2);

    public abstract long getTotalCount();

    abstract long getCounts(int var1);

    public abstract Page<K, V> remove(int var1);

    protected abstract void writePayload(ByteBuf var1, int var2);

    protected abstract KeyManager<K> readPayload(ByteBuf var1, int var2, boolean var3, int var4, int var5);

    public final boolean isSaved() {
        return DataUtil.isPageSaved(this.position);
    }

    public final boolean isRemoved() {
        return DataUtil.isPageRemoved(this.position);
    }

    private boolean markAsRemoved() {
        assert (this.getTotalCount() > 0L) : this;
        do {
            long pagePos;
            if (DataUtil.isPageSaved(pagePos = this.position)) {
                return false;
            }
            assert (!DataUtil.isPageRemoved(pagePos));
        } while (!pageInfoUpdater.compareAndSet(this, 0L, 1L));
        return true;
    }

    protected final int write(Chunk chunk, ByteBuf buf, LongArrayList toc) {
        this.pageNo = toc.size();
        int start = buf.writerIndex();
        buf.writerIndex(buf.writerIndex() + 4 + 2);
        IntBitPacker.writeVar(buf, this.map.getId());
        IntBitPacker.writeVar(buf, this.pageNo);
        int keyCount = this.keyManager.getKeyCount();
        IntBitPacker.writeVar(buf, keyCount);
        int typePosition = buf.writerIndex();
        int type = this.isLeaf() ? 0 : 1;
        buf.writeByte((int)((byte)type));
        this.writePayload(buf, keyCount);
        int pageLength = buf.writerIndex() - start;
        int chunkId = chunk.id;
        int check = DataUtil.getCheckValue(chunkId) ^ DataUtil.getCheckValue(start) ^ DataUtil.getCheckValue(pageLength);
        buf.setInt(start, pageLength);
        buf.setShort(start + 4, check);
        long tocElement = DataUtil.getTocElement(this.map.getId(), start, pageLength, type);
        toc.add(tocElement);
        if (this.isSaved()) {
            throw new MVStoreException(3, "Page already stored");
        }
        long pageInfo = DataUtil.getPageInfo(chunkId, tocElement);
        boolean isDeleted = this.isRemoved();
        while (!pageInfoUpdater.compareAndSet(this, isDeleted ? 1L : 0L, pageInfo)) {
            isDeleted = this.isRemoved();
        }
        MVStore store = this.map.getStore();
        store.cachePage(this);
        int pageLengthEncoded = DataUtil.getPageMaxLength(this.position);
        boolean singleWriter = this.map.isSingleWriter();
        chunk.accountForWrittenPage(pageLengthEncoded, singleWriter);
        if (isDeleted) {
            store.accountForRemovedPage(pageInfo, chunk.version + 1L, singleWriter, this.pageNo);
        }
        return typePosition + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void compressData(ByteBuf dataBuffer, int type, int typePosition, int dataStart, MVStore store, int uncompressedLength, int compressionLevel) {
        LZ4Compressor compressor = store.getCompressor();
        int compressType = compressionLevel == 1 ? 2 : 6;
        int maxCompressedLength = compressor.maxCompressedLength(uncompressedLength);
        ByteBuf outBuffer = PooledByteBufAllocator.DEFAULT.ioBuffer(maxCompressedLength);
        try {
            ByteBuffer inNioBuffer = DataUtil.getNioBuffer(dataBuffer, dataStart, uncompressedLength);
            assert (outBuffer.nioBufferCount() == 1);
            ByteBuffer outNioBuffer = outBuffer.internalNioBuffer(0, maxCompressedLength);
            int compressedLength = compressor.compress(inNioBuffer, inNioBuffer.position(), uncompressedLength, outNioBuffer, outNioBuffer.position(), maxCompressedLength);
            int delta = uncompressedLength - compressedLength;
            if (delta < 32) {
                return;
            }
            dataBuffer.setByte(typePosition, (int)((byte)(type | compressType)));
            dataBuffer.writerIndex(dataStart);
            IntBitPacker.writeVar(dataBuffer, delta);
            dataBuffer.writeBytes(outBuffer, 0, compressedLength);
        }
        finally {
            outBuffer.release();
        }
    }

    abstract void writeUnsavedRecursive(Chunk var1, ByteBuf var2, LongArrayList var3);

    abstract void releaseSavedPages();

    public abstract int getRawChildPageCount();

    protected final boolean isPersistent() {
        return this.memory != Integer.MIN_VALUE;
    }

    public final int getMemory() {
        return this.memory + this.keyManager.getSerializedDataSize();
    }

    public int getUnsavedMemory() {
        return this.isSaved() ? 0 : this.getMemory();
    }

    protected abstract int calculateMemory();

    public boolean isComplete() {
        return true;
    }

    public void setComplete() {
    }

    public final int removePage(long version) {
        if (this.isPersistent() && this.getTotalCount() > 0L) {
            MVStore store = this.map.getStore();
            if (!this.markAsRemoved()) {
                long pagePos = this.position;
                store.accountForRemovedPage(pagePos, version, this.map.isSingleWriter(), this.pageNo);
            } else {
                return -this.getMemory();
            }
        }
        return 0;
    }

    public abstract CursorPos<K, V> getPrependCursorPos(CursorPos<K, V> var1);

    public abstract CursorPos<K, V> getAppendCursorPos(CursorPos<K, V> var1);

    public abstract int removeAllRecursive(long var1);

    public final K[] createKeyStorage(int size) {
        return this.map.getKeyType().createStorage(size);
    }

    public static <K, V> PageReference<K, V>[] createRefStorage(int size) {
        return new PageReference[size];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/mvstore/Page";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createLeaf";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class PageReference<K, V> {
        static final PageReference EMPTY = new PageReference(null, 0L, 0L);
        private long info;
        private Page<K, V> page;
        final long totalCount;

        public static <X, Y> PageReference<X, Y> empty() {
            return EMPTY;
        }

        PageReference(Page<K, V> page) {
            this(page, page.getPosition(), page.getTotalCount());
        }

        PageReference(long info, long totalCount) {
            this(null, info, totalCount);
            assert (DataUtil.isPageSaved(info));
        }

        private PageReference(Page<K, V> page, long info, long totalCount) {
            this.page = page;
            this.info = info;
            this.totalCount = totalCount;
        }

        public Page<K, V> getPage() {
            return this.page;
        }

        void clearPageReference() {
            if (this.page != null) {
                this.page.releaseSavedPages();
                assert (this.page.isSaved() || !this.page.isComplete());
                if (this.page.isSaved()) {
                    assert (this.info == this.page.getPosition());
                    assert (this.totalCount == this.page.getTotalCount()) : this.totalCount + " != " + this.page.getTotalCount();
                    this.page = null;
                }
            }
        }

        long getPos() {
            return this.info;
        }

        void resetPos() {
            Page<K, V> p = this.page;
            if (p != null && p.isSaved()) {
                this.info = p.getPosition();
                assert (this.totalCount == p.getTotalCount());
            }
        }

        public String toString() {
            return "totalCount=" + this.totalCount + ", info=" + (String)(this.info == 0L ? "0" : DataUtil.getPageChunkId(this.info) + (String)(this.page == null ? "" : "/" + this.page.pageNo) + "-" + DataUtil.getPageOffset(this.info) + ":" + DataUtil.getPageMaxLength(this.info)) + ((this.page == null ? DataUtil.getPageType(this.info) == 0 : this.page.isLeaf()) ? " leaf" : " node") + ", page:{" + this.page + "}";
        }
    }
}

