/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.GlobalConfig;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.UserConfig;
import org.languagetool.chunking.Chunker;
import org.languagetool.chunking.EnglishChunker;
import org.languagetool.language.AmericanEnglish;
import org.languagetool.language.Contributor;
import org.languagetool.language.Contributors;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.BERTSuggestionRanking;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.EmptyLineRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.GRPCConfusionRule;
import org.languagetool.rules.GRPCRule;
import org.languagetool.rules.LongParagraphRule;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.ParagraphRepeatBeginningRule;
import org.languagetool.rules.PunctuationMarkAtParagraphEnd;
import org.languagetool.rules.PunctuationMarkAtParagraphEnd2;
import org.languagetool.rules.ReadabilityRule;
import org.languagetool.rules.RemoteRuleConfig;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WhiteSpaceAtBeginOfParagraph;
import org.languagetool.rules.WhiteSpaceBeforeParagraphEnd;
import org.languagetool.rules.en.AvsAnRule;
import org.languagetool.rules.en.CompoundRule;
import org.languagetool.rules.en.ContractionSpellingRule;
import org.languagetool.rules.en.EnglishConfusionProbabilityRule;
import org.languagetool.rules.en.EnglishDashRule;
import org.languagetool.rules.en.EnglishDiacriticsRule;
import org.languagetool.rules.en.EnglishForFrenchFalseFriendRule;
import org.languagetool.rules.en.EnglishForGermansFalseFriendRule;
import org.languagetool.rules.en.EnglishNgramProbabilityRule;
import org.languagetool.rules.en.EnglishPlainEnglishRule;
import org.languagetool.rules.en.EnglishRedundancyRule;
import org.languagetool.rules.en.EnglishUnpairedBracketsRule;
import org.languagetool.rules.en.EnglishWordRepeatBeginningRule;
import org.languagetool.rules.en.EnglishWordRepeatRule;
import org.languagetool.rules.en.EnglishWrongWordInContextRule;
import org.languagetool.rules.en.SimpleReplaceRule;
import org.languagetool.rules.en.SpecificCaseRule;
import org.languagetool.rules.en.UpperCaseNgramRule;
import org.languagetool.rules.en.WordCoherencyRule;
import org.languagetool.rules.neuralnetwork.NeuralNetworkRuleCreator;
import org.languagetool.rules.neuralnetwork.Word2VecModel;
import org.languagetool.rules.patterns.PatternRuleLoader;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.en.EnglishSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.en.EnglishHybridDisambiguator;
import org.languagetool.tagging.en.EnglishTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.en.EnglishWordTokenizer;

public class English
extends Language
implements AutoCloseable {
    private static final LoadingCache<String, List<Rule>> cache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List<Rule>>(){

        public List<Rule> load(@NotNull String path) throws IOException {
            ArrayList<Rule> rules = new ArrayList<Rule>();
            PatternRuleLoader loader = new PatternRuleLoader();
            try (InputStream is = JLanguageTool.getDataBroker().getAsStream(path);){
                rules.addAll(loader.getRules(is, path));
            }
            return rules;
        }
    });
    private static final Language AMERICAN_ENGLISH = new AmericanEnglish();
    private LanguageModel languageModel;

    @Deprecated
    public English() {
    }

    public Language getDefaultLanguageVariant() {
        return AMERICAN_ENGLISH;
    }

    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new SRXSentenceTokenizer((Language)this);
    }

    public String getName() {
        return "English";
    }

    public String getShortCode() {
        return "en";
    }

    public String[] getCountries() {
        return new String[0];
    }

    @NotNull
    public Tagger createDefaultTagger() {
        return new EnglishTagger();
    }

    @Nullable
    public Chunker createDefaultChunker() {
        return new EnglishChunker();
    }

    @Nullable
    public Synthesizer createDefaultSynthesizer() {
        return new EnglishSynthesizer(this);
    }

    public Disambiguator createDefaultDisambiguator() {
        return new EnglishHybridDisambiguator();
    }

    public Tokenizer createDefaultWordTokenizer() {
        return new EnglishWordTokenizer();
    }

    public synchronized LanguageModel getLanguageModel(File indexDir) throws IOException {
        this.languageModel = this.initLanguageModel(indexDir, this.languageModel);
        return this.languageModel;
    }

    public synchronized Word2VecModel getWord2VecModel(File indexDir) throws IOException {
        return new Word2VecModel(indexDir + File.separator + this.getShortCode());
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Mike Unwalla"), Contributors.MARCIN_MILKOWSKI, Contributors.DANIEL_NABER};
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        ArrayList<Rule> allRules = new ArrayList<Rule>();
        if (motherTongue != null) {
            if ("de".equals(motherTongue.getShortCode())) {
                allRules.addAll((Collection)cache.getUnchecked((Object)"/org/languagetool/rules/en/grammar-l2-de.xml"));
            } else if ("fr".equals(motherTongue.getShortCode())) {
                allRules.addAll((Collection)cache.getUnchecked((Object)"/org/languagetool/rules/en/grammar-l2-fr.xml"));
            }
        }
        allRules.addAll(Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages, Example.wrong((String)"We had coffee<marker> ,</marker> cheese and crackers and grapes."), Example.fixed((String)"We had coffee<marker>,</marker> cheese and crackers and grapes.")), new DoublePunctuationRule(messages), new UppercaseSentenceStartRule(messages, (Language)this, Example.wrong((String)"This house is old. <marker>it</marker> was built in 1950."), Example.fixed((String)"This house is old. <marker>It</marker> was built in 1950.")), new MultipleWhitespaceRule(messages, (Language)this), new SentenceWhitespaceRule(messages), new WhiteSpaceBeforeParagraphEnd(messages, (Language)this), new WhiteSpaceAtBeginOfParagraph(messages), new EmptyLineRule(messages, (Language)this), new LongSentenceRule(messages, userConfig), new LongParagraphRule(messages, (Language)this, userConfig), new ParagraphRepeatBeginningRule(messages, (Language)this), new PunctuationMarkAtParagraphEnd(messages, (Language)this), new PunctuationMarkAtParagraphEnd2(messages, (Language)this), new SpecificCaseRule(messages), new EnglishUnpairedBracketsRule(messages, this), new EnglishWordRepeatRule(messages, this), new AvsAnRule(messages), new EnglishWordRepeatBeginningRule(messages, this), new CompoundRule(messages), new ContractionSpellingRule(messages), new EnglishWrongWordInContextRule(messages), new EnglishDashRule(messages), new WordCoherencyRule(messages), new EnglishDiacriticsRule(messages), new EnglishPlainEnglishRule(messages), new EnglishRedundancyRule(messages), new SimpleReplaceRule(messages), new ReadabilityRule(messages, (Language)this, userConfig, false), new ReadabilityRule(messages, (Language)this, userConfig, true)}));
        return allRules;
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel, UserConfig userConfig) throws IOException {
        return Arrays.asList(new Rule[]{new UpperCaseNgramRule(messages, languageModel, this, userConfig), new EnglishConfusionProbabilityRule(messages, languageModel, this), new EnglishNgramProbabilityRule(messages, languageModel, this)});
    }

    public List<Rule> getRelevantLanguageModelCapableRules(ResourceBundle messages, @Nullable LanguageModel languageModel, GlobalConfig globalConfig, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        if (languageModel != null && motherTongue != null && "fr".equals(motherTongue.getShortCode())) {
            return Arrays.asList(new Rule[]{new EnglishForFrenchFalseFriendRule(messages, languageModel, motherTongue, this)});
        }
        if (languageModel != null && motherTongue != null && "de".equals(motherTongue.getShortCode())) {
            return Arrays.asList(new Rule[]{new EnglishForGermansFalseFriendRule(messages, languageModel, motherTongue, this)});
        }
        return Arrays.asList(new Rule[0]);
    }

    public List<Rule> getRelevantWord2VecModelRules(ResourceBundle messages, Word2VecModel word2vecModel) throws IOException {
        return NeuralNetworkRuleCreator.createRules((ResourceBundle)messages, (Language)this, (Word2VecModel)word2vecModel);
    }

    public boolean hasNGramFalseFriendRule(Language motherTongue) {
        return motherTongue != null && ("de".equals(motherTongue.getShortCode()) || "fr".equals(motherTongue.getShortCode()));
    }

    @Override
    public void close() throws Exception {
        if (this.languageModel != null) {
            this.languageModel.close();
        }
    }

    protected int getPriorityForId(String id) {
        switch (id) {
            case "THE_INS_RULE": {
                return 50;
            }
            case "CONFPAIRS_EN_GPT2": {
                return 50;
            }
            case "CONFPAIRS_EN_GPT2_L": {
                return 50;
            }
            case "CONFPAIRS_EN_GPT2_XL": {
                return 50;
            }
            case "I_E": {
                return 10;
            }
            case "MISSING_HYPHEN": {
                return 5;
            }
            case "TRANSLATION_RULE": {
                return 5;
            }
            case "WRONG_APOSTROPHE": {
                return 5;
            }
            case "DOS_AND_DONTS": {
                return 3;
            }
            case "EN_COMPOUNDS": {
                return 2;
            }
            case "ABBREVIATION_PUNCTUATION": {
                return 2;
            }
            case "COVID_19": {
                return 1;
            }
            case "MONEY_BACK_HYPHEN": {
                return 1;
            }
            case "WORLDS_BEST": {
                return 1;
            }
            case "STEP_COMPOUNDS": {
                return 1;
            }
            case "WON_T_TO": {
                return 1;
            }
            case "WAN_T": {
                return 1;
            }
            case "THE_US": {
                return 1;
            }
            case "THE_IT": {
                return 1;
            }
            case "A_HUNDREDS": {
                return 1;
            }
            case "NOW_A_DAYS": {
                return 1;
            }
            case "COUPLE_OF_TIMES": {
                return 1;
            }
            case "A_WINDOWS": {
                return 1;
            }
            case "A_SCISSOR": {
                return 1;
            }
            case "A_SNICKERS": {
                return 1;
            }
            case "ROUND_A_BOUT": {
                return 1;
            }
            case "SEEM_SEEN": {
                return 1;
            }
            case "BORN_IN": {
                return 1;
            }
            case "DO_TO": {
                return 1;
            }
            case "IN_THIS_REGARDS": {
                return 1;
            }
            case "NO_WHERE": {
                return 1;
            }
            case "APOSTROPHE_VS_QUOTE": {
                return 1;
            }
            case "COMMA_PERIOD": {
                return 1;
            }
            case "HERE_HEAR": {
                return 1;
            }
            case "LIGATURES": {
                return 1;
            }
            case "APPSTORE": {
                return 1;
            }
            case "INCORRECT_CONTRACTIONS": {
                return 1;
            }
            case "DONT_T": {
                return 1;
            }
            case "WHATS_APP": {
                return 1;
            }
            case "NON_STANDARD_COMMA": {
                return 1;
            }
            case "NON_STANDARD_ALPHABETIC_CHARACTERS": {
                return 1;
            }
            case "WONT_CONTRACTION": {
                return 1;
            }
            case "THAN_THANK": {
                return 1;
            }
            case "CD_NN_APOSTROPHE_S": {
                return 1;
            }
            case "IT_IF": {
                return 1;
            }
            case "PROFANITY": {
                return 5;
            }
            case "RUDE_SARCASTIC": {
                return 6;
            }
            case "CHILDISH_LANGUAGE": {
                return 8;
            }
            case "EN_DIACRITICS_REPLACE": {
                return 9;
            }
            case "BLACK_SEA": {
                return -1;
            }
            case "WE_BE": {
                return -1;
            }
            case "A_LOT_OF_NN": {
                return -1;
            }
            case "IT_VBZ": {
                return -1;
            }
            case "IT_IS_2": {
                return -1;
            }
            case "A_RB_NN": {
                return -1;
            }
            case "PLURAL_VERB_AFTER_THIS": {
                return -1;
            }
            case "BE_RB_BE": {
                return -1;
            }
            case "IT_ITS": {
                return -1;
            }
            case "ENGLISH_WORD_REPEAT_RULE": {
                return -1;
            }
            case "PRP_MD_NN": {
                return -1;
            }
            case "NON_ANTI_PRE_JJ": {
                return -1;
            }
            case "DT_JJ_NO_NOUN": {
                return -1;
            }
            case "AGREEMENT_SENT_START": {
                return -1;
            }
            case "HAVE_PART_AGREEMENT": {
                return -1;
            }
            case "PREPOSITION_VERB": {
                return -1;
            }
            case "EN_A_VS_AN": {
                return -1;
            }
            case "CD_NN": {
                return -1;
            }
            case "ATD_VERBS_TO_COLLOCATION": {
                return -1;
            }
            case "ADVERB_OR_HYPHENATED_ADJECTIVE": {
                return -1;
            }
            case "GOING_TO_VBD": {
                return -1;
            }
            case "MISSING_PREPOSITION": {
                return -1;
            }
            case "BE_TO_VBG": {
                return -1;
            }
            case "NON3PRS_VERB": {
                return -1;
            }
            case "DID_FOUND_AMBIGUOUS": {
                return -1;
            }
            case "BE_I_BE_GERUND": {
                return -1;
            }
            case "VBZ_VBD": {
                return -1;
            }
            case "SUPERLATIVE_THAN": {
                return -1;
            }
            case "UNLIKELY_OPENING_PUNCTUATION": {
                return -1;
            }
            case "PRP_RB_NO_VB": {
                return -2;
            }
            case "PRP_VBG": {
                return -2;
            }
            case "PRP_VBZ": {
                return -2;
            }
            case "PRP_VB": {
                return -2;
            }
            case "BEEN_PART_AGREEMENT": {
                return -3;
            }
            case "A_INFINITIVE": {
                return -3;
            }
            case "HE_VERB_AGR": {
                return -3;
            }
            case "PRP_JJ": {
                return -3;
            }
            case "PRONOUN_NOUN": {
                return -3;
            }
            case "INDIAN_ENGLISH": {
                return -3;
            }
            case "MORFOLOGIK_RULE_EN_US": {
                return -10;
            }
            case "MORFOLOGIK_RULE_EN_GB": {
                return -10;
            }
            case "MORFOLOGIK_RULE_EN_CA": {
                return -10;
            }
            case "MORFOLOGIK_RULE_EN_ZA": {
                return -10;
            }
            case "MORFOLOGIK_RULE_EN_NZ": {
                return -10;
            }
            case "MORFOLOGIK_RULE_EN_AU": {
                return -10;
            }
            case "TWO_CONNECTED_MODAL_VERBS": {
                return -15;
            }
            case "CONFUSION_RULE": {
                return -20;
            }
            case "SENTENCE_FRAGMENT": {
                return -50;
            }
            case "SENTENCE_FRAGMENT_SINGLE_WORDS": {
                return -51;
            }
            case "EN_REDUNDANCY_REPLACE": {
                return -510;
            }
            case "EN_PLAIN_ENGLISH_REPLACE": {
                return -511;
            }
            case "TOO_LONG_SENTENCE": {
                return -997;
            }
            case "TOO_LONG_PARAGRAPH": {
                return -998;
            }
        }
        return super.getPriorityForId(id);
    }

    public Function<Rule, Rule> getRemoteEnhancedRules(ResourceBundle messageBundle, List<RemoteRuleConfig> configs, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        Function fallback = super.getRemoteEnhancedRules(messageBundle, configs, userConfig, motherTongue, altLanguages);
        RemoteRuleConfig bert = RemoteRuleConfig.getRelevantConfig((String)"BERT_SUGGESTION_RANKING", configs);
        return original -> {
            if (original.isDictionaryBasedSpellingRule() && original.getId().startsWith("MORFOLOGIK_RULE_EN") && UserConfig.hasABTestsEnabled() && bert != null) {
                return new BERTSuggestionRanking(original, bert, userConfig);
            }
            return (Rule)fallback.apply(original);
        };
    }

    public List<Rule> getRelevantRemoteRules(ResourceBundle messageBundle, List<RemoteRuleConfig> configs, GlobalConfig globalConfig, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        String missingTheID;
        RemoteRuleConfig missingTheConfig;
        ArrayList<Rule> rules = new ArrayList<Rule>(super.getRelevantRemoteRules(messageBundle, configs, globalConfig, userConfig, motherTongue, altLanguages));
        String theInsertionID = "THE_INS_RULE";
        RemoteRuleConfig theInsertionConfig = RemoteRuleConfig.getRelevantConfig((String)theInsertionID, configs);
        if (theInsertionConfig != null) {
            HashMap<String, String> theInsertionMessages = new HashMap<String, String>();
            theInsertionMessages.put("THE_INS", "the_ins_rule_del_the");
            theInsertionMessages.put("INS_THE", "the_ins_rule_ins_the");
            GRPCRule theInsertionRule = GRPCRule.create((ResourceBundle)messageBundle, (RemoteRuleConfig)theInsertionConfig, (String)theInsertionID, (String)"the_ins_rule_description", theInsertionMessages);
            rules.add((Rule)theInsertionRule);
        }
        if ((missingTheConfig = RemoteRuleConfig.getRelevantConfig((String)(missingTheID = "MISSING_THE"), configs)) != null) {
            HashMap<String, String> missingTheMessages = new HashMap<String, String>();
            missingTheMessages.put("MISSING_THE", "the_ins_rule_ins_the");
            GRPCRule missingTheRule = GRPCRule.create((ResourceBundle)messageBundle, (RemoteRuleConfig)missingTheConfig, (String)missingTheID, (String)"the_ins_rule_description", missingTheMessages);
            rules.add((Rule)missingTheRule);
        }
        List<String> confpairRules = Arrays.asList("CONFPAIRS_EN_GPT2", "CONFPAIRS_EN_GPT2_L", "CONFPAIRS_EN_GPT2_XL");
        for (String confpairID : confpairRules) {
            RemoteRuleConfig confpairConfig = RemoteRuleConfig.getRelevantConfig((String)confpairID, configs);
            if (confpairConfig == null) continue;
            GRPCConfusionRule confpairRule = new GRPCConfusionRule(messageBundle, confpairConfig);
            rules.add((Rule)confpairRule);
        }
        return rules;
    }
}

