/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class ChangesBrowserLockedFoldersNode
extends ChangesBrowserNode<Object>
implements TreeLinkMouseListener.HaveTooltip {
    @NotNull
    private static final SimpleTextAttributes CLEANUP_LINK_ATTRIBUTES = new SimpleTextAttributes(16, (Color)JBColor.RED);
    @NotNull
    private final Project myProject;

    public ChangesBrowserLockedFoldersNode(@NotNull Project project, @NotNull Object userObject) {
        if (project == null) {
            ChangesBrowserLockedFoldersNode.$$$reportNull$$$0(0);
        }
        if (userObject == null) {
            ChangesBrowserLockedFoldersNode.$$$reportNull$$$0(1);
        }
        super(userObject);
        this.myProject = project;
    }

    @NotNull
    public String getTooltip() {
        String string = VcsBundle.message((String)"changes.nodetitle.locked.folders.tooltip", (Object[])new Object[0]);
        if (string == null) {
            ChangesBrowserLockedFoldersNode.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        if (renderer == null) {
            ChangesBrowserLockedFoldersNode.$$$reportNull$$$0(3);
        }
        renderer.append(this.userObject.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        renderer.append(this.getCountText(), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        renderer.append(FontUtil.spaceAndThinSpace(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        renderer.append(VcsBundle.message((String)"changes.do.cleanup", (Object[])new Object[0]), CLEANUP_LINK_ATTRIBUTES, new CleanupWorker(this.myProject, this));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userObject";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserLockedFoldersNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserLockedFoldersNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class CleanupWorker
    implements Runnable {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ChangesBrowserNode<?> myNode;

        private CleanupWorker(@NotNull Project project, @NotNull ChangesBrowserNode<?> node) {
            if (project == null) {
                CleanupWorker.$$$reportNull$$$0(0);
            }
            if (node == null) {
                CleanupWorker.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myNode = node;
        }

        @Override
        public void run() {
            ChangesUtil.processVirtualFilesByVcs((Project)this.myProject, this.myNode.getAllFilesUnder(), (vcs, files) -> {
                ChangeProvider provider = vcs.getChangeProvider();
                if (provider != null) {
                    provider.doCleanup(files);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserLockedFoldersNode$CleanupWorker";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

