/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.ide.actions.SplitAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.DiffPreviewUpdateProcessor;
import com.intellij.openapi.vcs.changes.EditorTabDiffPreviewProvider;
import com.intellij.openapi.vcs.changes.EditorTabPreview;
import com.intellij.openapi.vcs.changes.EditorTabPreviewEscapeAction;
import com.intellij.openapi.vcs.changes.PreviewDiffVirtualFile;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.Consumer;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.Processor;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b&\u0018\u0000 62\u00020\u0001:\u000267B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001a\u001a\u00020\u001bJ\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH$J\b\u0010\u001e\u001a\u00020\u001fH$J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"H\u0002J\u000e\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&J\u001e\u0010'\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001b0)H\u0002J\b\u0010*\u001a\u00020\u001fH\u0014J\b\u0010+\u001a\u00020\u001fH\u0014J\b\u0010,\u001a\u00020\u001fH\u0002J\u000e\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u001fJ\u000e\u0010/\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"J\u000e\u00100\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"J\u0010\u00101\u001a\u00020\u001b2\u0006\u00102\u001a\u00020\u001fH\u0016J\b\u00103\u001a\u00020\u001fH\u0014J\u0010\u00104\u001a\u00020\u001b2\u0006\u00105\u001a\u00020\u001fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u00118DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/openapi/vcs/changes/EditorTabPreview;", "Lcom/intellij/openapi/vcs/changes/DiffPreview;", "diffProcessor", "Lcom/intellij/diff/impl/DiffRequestProcessor;", "(Lcom/intellij/diff/impl/DiffRequestProcessor;)V", "getDiffProcessor", "()Lcom/intellij/diff/impl/DiffRequestProcessor;", "escapeHandler", "Ljava/lang/Runnable;", "getEscapeHandler", "()Ljava/lang/Runnable;", "setEscapeHandler", "(Ljava/lang/Runnable;)V", "previewFile", "Lcom/intellij/openapi/vcs/changes/EditorTabPreview$EditorTabDiffPreviewVirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/Nullable;", "getProject", "()Lcom/intellij/openapi/project/Project;", "updatePreviewProcessor", "Lcom/intellij/openapi/vcs/changes/DiffPreviewUpdateProcessor;", "getUpdatePreviewProcessor", "()Lcom/intellij/openapi/vcs/changes/DiffPreviewUpdateProcessor;", "updatePreviewQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "closePreview", "", "getCurrentName", "", "hasContent", "", "installDoubleClickHandler", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "installEnterKeyHandler", "installNextDiffActionOn", "component", "Ljavax/swing/JComponent;", "installSelectionChangedHandler", "handler", "Lkotlin/Function0;", "isPreviewOnDoubleClickAllowed", "isPreviewOnEnterAllowed", "isPreviewOpen", "openPreview", "focusEditor", "openWithDoubleClick", "openWithSingleClick", "setPreviewVisible", "isPreviewVisible", "skipPreviewUpdate", "updatePreview", "fromModelRefresh", "Companion", "EditorTabDiffPreviewVirtualFile", "intellij.platform.vcs.impl"})
public abstract class EditorTabPreview
implements DiffPreview {
    private final EditorTabDiffPreviewVirtualFile previewFile;
    private final MergingUpdateQueue updatePreviewQueue;
    @Nullable
    private Runnable escapeHandler;
    @NotNull
    private final DiffRequestProcessor diffProcessor;
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final Project getProject() {
        Project project = this.diffProcessor.getProject();
        Intrinsics.checkNotNull((Object)project);
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"diffProcessor.project!!");
        return project;
    }

    private final DiffPreviewUpdateProcessor getUpdatePreviewProcessor() {
        DiffRequestProcessor diffRequestProcessor = this.diffProcessor;
        if (!(diffRequestProcessor instanceof DiffPreviewUpdateProcessor)) {
            diffRequestProcessor = null;
        }
        return (DiffPreviewUpdateProcessor)diffRequestProcessor;
    }

    @Nullable
    public final Runnable getEscapeHandler() {
        return this.escapeHandler;
    }

    public final void setEscapeHandler(@Nullable Runnable runnable) {
        this.escapeHandler = runnable;
    }

    public final void openWithDoubleClick(@NotNull ChangesTree tree) {
        Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
        this.installDoubleClickHandler(tree);
        this.installEnterKeyHandler(tree);
        this.installSelectionChangedHandler(tree, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ EditorTabPreview this$0;

            public final void invoke() {
                this.this$0.updatePreview(false);
            }
            {
                this.this$0 = editorTabPreview;
                super(0);
            }
        }));
    }

    public final void openWithSingleClick(@NotNull ChangesTree tree) {
        Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
        DumbService.getInstance((Project)this.getProject()).smartInvokeLater(new Runnable(this, tree){
            final /* synthetic */ EditorTabPreview this$0;
            final /* synthetic */ ChangesTree $tree;

            public final void run() {
                if (Disposer.isDisposed((Disposable)((Disposable)EditorTabPreview.access$getUpdatePreviewQueue$p(this.this$0)))) {
                    return;
                }
                EditorTabPreview.access$installSelectionChangedHandler(this.this$0, this.$tree, (Function0)new Function0<Unit>(this){
                    final /* synthetic */ openWithSingleClick.1 this$0;

                    public final void invoke() {
                        if (!this.this$0.this$0.openPreview(false)) {
                            this.this$0.this$0.closePreview();
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = editorTabPreview;
                this.$tree = changesTree;
            }
        });
    }

    public final void installNextDiffActionOn(@NotNull JComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        DumbAwareAction dumbAwareAction = DumbAwareAction.create((Consumer)((Consumer)new Consumer<AnActionEvent>(this){
            final /* synthetic */ EditorTabPreview this$0;

            public final void consume(AnActionEvent it) {
                this.this$0.openPreview(true);
            }
            {
                this.this$0 = editorTabPreview;
            }
        }));
        boolean bl = false;
        boolean bl2 = false;
        DumbAwareAction $this$apply = dumbAwareAction;
        boolean bl3 = false;
        $this$apply.copyShortcutFrom(ActionManager.getInstance().getAction("NextDiff"));
        $this$apply.registerCustomShortcutSet(component, (Disposable)this.diffProcessor);
    }

    protected boolean isPreviewOnDoubleClickAllowed() {
        return true;
    }

    protected boolean isPreviewOnEnterAllowed() {
        return true;
    }

    private final void installDoubleClickHandler(ChangesTree tree) {
        Processor<? super MouseEvent> oldDoubleClickHandler = tree.getDoubleClickHandler();
        Processor newDoubleClickHandler2 = (Processor)new Processor<MouseEvent>(this, tree, oldDoubleClickHandler){
            final /* synthetic */ EditorTabPreview this$0;
            final /* synthetic */ ChangesTree $tree;
            final /* synthetic */ Processor $oldDoubleClickHandler;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean process(MouseEvent e) {
                if (EditSourceOnDoubleClickHandler.isToggleEvent((JTree)((JTree)((Object)this.$tree)), (MouseEvent)e)) {
                    return false;
                }
                if (this.this$0.isPreviewOnDoubleClickAllowed()) {
                    if (this.this$0.openPreview(true)) return true;
                }
                Processor processor = this.$oldDoubleClickHandler;
                if (processor == null) return false;
                if (!processor.process((Object)e)) return false;
                return true;
            }
            {
                this.this$0 = editorTabPreview;
                this.$tree = changesTree;
                this.$oldDoubleClickHandler = processor;
            }
        };
        tree.setDoubleClickHandler((Processor<? super MouseEvent>)newDoubleClickHandler2);
        Disposer.register((Disposable)((Disposable)this.diffProcessor), (Disposable)new Disposable(tree, oldDoubleClickHandler){
            final /* synthetic */ ChangesTree $tree;
            final /* synthetic */ Processor $oldDoubleClickHandler;

            public final void dispose() {
                this.$tree.setDoubleClickHandler((Processor<? super MouseEvent>)this.$oldDoubleClickHandler);
            }
            {
                this.$tree = changesTree;
                this.$oldDoubleClickHandler = processor;
            }
        });
    }

    private final void installEnterKeyHandler(ChangesTree tree) {
        Processor<? super KeyEvent> oldEnterKeyHandler = tree.getEnterKeyHandler();
        Processor newEnterKeyHandler2 = (Processor)new Processor<KeyEvent>(this, oldEnterKeyHandler){
            final /* synthetic */ EditorTabPreview this$0;
            final /* synthetic */ Processor $oldEnterKeyHandler;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean process(KeyEvent e) {
                if (this.this$0.isPreviewOnEnterAllowed()) {
                    if (this.this$0.openPreview(false)) return true;
                }
                Processor processor = this.$oldEnterKeyHandler;
                if (processor == null) return false;
                if (!processor.process((Object)e)) return false;
                return true;
            }
            {
                this.this$0 = editorTabPreview;
                this.$oldEnterKeyHandler = processor;
            }
        };
        tree.setEnterKeyHandler((Processor<? super KeyEvent>)newEnterKeyHandler2);
        Disposer.register((Disposable)((Disposable)this.diffProcessor), (Disposable)new Disposable(tree, oldEnterKeyHandler){
            final /* synthetic */ ChangesTree $tree;
            final /* synthetic */ Processor $oldEnterKeyHandler;

            public final void dispose() {
                this.$tree.setEnterKeyHandler((Processor<? super KeyEvent>)this.$oldEnterKeyHandler);
            }
            {
                this.$tree = changesTree;
                this.$oldEnterKeyHandler = processor;
            }
        });
    }

    private final void installSelectionChangedHandler(ChangesTree tree, Function0<Unit> handler) {
        tree.addSelectionListener(new Runnable(this, handler){
            final /* synthetic */ EditorTabPreview this$0;
            final /* synthetic */ Function0 $handler;

            public final void run() {
                EditorTabPreview.access$getUpdatePreviewQueue$p(this.this$0).queue((Update)DisposableUpdate.createDisposable((Disposable)((Disposable)EditorTabPreview.access$getUpdatePreviewQueue$p(this.this$0)), (Object)this.this$0, (Runnable)new Runnable(this){
                    final /* synthetic */ installSelectionChangedHandler.1 this$0;

                    public final void run() {
                        if (!this.this$0.this$0.skipPreviewUpdate()) {
                            this.this$0.$handler.invoke();
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }));
            }
            {
                this.this$0 = editorTabPreview;
                this.$handler = function0;
            }
        }, (Disposable)this.updatePreviewQueue);
    }

    @Nullable
    protected abstract String getCurrentName();

    protected abstract boolean hasContent();

    protected boolean skipPreviewUpdate() {
        return ToolWindowManager.Companion.getInstance(this.getProject()).isEditorComponentActive();
    }

    @Override
    public void updatePreview(boolean fromModelRefresh) {
        block2: {
            block1: {
                if (!this.isPreviewOpen()) break block1;
                DiffPreviewUpdateProcessor diffPreviewUpdateProcessor = this.getUpdatePreviewProcessor();
                if (diffPreviewUpdateProcessor != null) {
                    diffPreviewUpdateProcessor.refresh(false);
                }
                FileEditorManagerEx.getInstanceEx((Project)this.getProject()).updateFilePresentation((VirtualFile)this.previewFile);
                break block2;
            }
            DiffPreviewUpdateProcessor diffPreviewUpdateProcessor = this.getUpdatePreviewProcessor();
            if (diffPreviewUpdateProcessor == null) break block2;
            diffPreviewUpdateProcessor.clear();
        }
    }

    @Override
    public void setPreviewVisible(boolean isPreviewVisible) {
        if (isPreviewVisible) {
            this.openPreview(false);
        } else {
            this.closePreview();
        }
    }

    private final boolean isPreviewOpen() {
        return FileEditorManager.getInstance((Project)this.getProject()).isFileOpen((VirtualFile)this.previewFile);
    }

    public final void closePreview() {
        block0: {
            FileEditorManager.getInstance((Project)this.getProject()).closeFile((VirtualFile)this.previewFile);
            DiffPreviewUpdateProcessor diffPreviewUpdateProcessor = this.getUpdatePreviewProcessor();
            if (diffPreviewUpdateProcessor == null) break block0;
            diffPreviewUpdateProcessor.clear();
        }
    }

    public final boolean openPreview(boolean focusEditor) {
        DiffPreviewUpdateProcessor diffPreviewUpdateProcessor = this.getUpdatePreviewProcessor();
        if (diffPreviewUpdateProcessor != null) {
            diffPreviewUpdateProcessor.refresh(false);
        }
        if (!this.hasContent()) {
            return false;
        }
        Companion.openPreview(this.getProject(), this.previewFile, focusEditor, this.escapeHandler);
        return true;
    }

    @NotNull
    protected final DiffRequestProcessor getDiffProcessor() {
        return this.diffProcessor;
    }

    /*
     * WARNING - void declaration
     */
    public EditorTabPreview(@NotNull DiffRequestProcessor diffProcessor) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)diffProcessor, (String)"diffProcessor");
        this.diffProcessor = diffProcessor;
        this.previewFile = new EditorTabDiffPreviewVirtualFile(this);
        MergingUpdateQueue mergingUpdateQueue = new MergingUpdateQueue("updatePreviewQueue", 100, true, null, (Disposable)this.diffProcessor);
        boolean bl = false;
        boolean bl2 = false;
        MergingUpdateQueue mergingUpdateQueue2 = mergingUpdateQueue;
        EditorTabPreview editorTabPreview = this;
        boolean bl3 = false;
        $this$apply.setRestartTimerOnAdd(true);
        Unit unit = Unit.INSTANCE;
        editorTabPreview.updatePreviewQueue = mergingUpdateQueue;
    }

    public static final /* synthetic */ MergingUpdateQueue access$getUpdatePreviewQueue$p(EditorTabPreview $this) {
        return $this.updatePreviewQueue;
    }

    public static final /* synthetic */ void access$installSelectionChangedHandler(EditorTabPreview $this, ChangesTree tree, Function0 handler) {
        $this.installSelectionChangedHandler(tree, (Function0<Unit>)handler);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/changes/EditorTabPreview$EditorTabDiffPreviewVirtualFile;", "Lcom/intellij/openapi/vcs/changes/PreviewDiffVirtualFile;", "preview", "Lcom/intellij/openapi/vcs/changes/EditorTabPreview;", "(Lcom/intellij/openapi/vcs/changes/EditorTabPreview;)V", "getPreview", "()Lcom/intellij/openapi/vcs/changes/EditorTabPreview;", "intellij.platform.vcs.impl"})
    private static final class EditorTabDiffPreviewVirtualFile
    extends PreviewDiffVirtualFile {
        @NotNull
        private final EditorTabPreview preview;

        @NotNull
        public final EditorTabPreview getPreview() {
            return this.preview;
        }

        public EditorTabDiffPreviewVirtualFile(final @NotNull EditorTabPreview preview2) {
            Intrinsics.checkNotNullParameter((Object)preview2, (String)"preview");
            super(new EditorTabDiffPreviewProvider(preview2.getDiffProcessor(), (Function0<String>)((Function0)new Function0<String>(){

                @Nullable
                public final String invoke() {
                    return preview2.getCurrentName();
                }
            })));
            this.preview = preview2;
            this.preview.getDiffProcessor().putContextUserData(DiffUserDataKeysEx.DIFF_IN_EDITOR_WITH_EXPLICIT_DISPOSABLE, (Object)true);
            this.putUserData(SplitAction.FORBID_TAB_SPLIT, true);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/vcs/changes/EditorTabPreview$Companion;", "", "()V", "openPreview", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vcs/changes/PreviewDiffVirtualFile;", "focusEditor", "", "escapeHandler", "Ljava/lang/Runnable;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        public final void openPreview(@NotNull Project project, @NotNull PreviewDiffVirtualFile file, boolean focusEditor, @Nullable Runnable escapeHandler2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
            boolean wasAlreadyOpen = FileEditorManager.getInstance((Project)project).isFileOpen((VirtualFile)file);
            Object[] objectArray = FileEditorManager.getInstance((Project)project).openFile((VirtualFile)file, focusEditor, true);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"FileEditorManager.getIns\u2026(file, focusEditor, true)");
            FileEditor fileEditor = (FileEditor)ArraysKt.singleOrNull((Object[])objectArray);
            if (fileEditor == null) {
                return;
            }
            FileEditor editor = fileEditor;
            if (wasAlreadyOpen || escapeHandler2 == null) {
                return;
            }
            new EditorTabPreviewEscapeAction(escapeHandler2).registerCustomShortcutSet(CommonShortcuts.ESCAPE, editor.getComponent(), (Disposable)editor);
        }

        public static /* synthetic */ void openPreview$default(Companion companion, Project project, PreviewDiffVirtualFile previewDiffVirtualFile, boolean bl, Runnable runnable, int n, Object object) {
            if ((n & 8) != 0) {
                runnable = null;
            }
            companion.openPreview(project, previewDiffVirtualFile, bl, runnable);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

