/*
 * Decompiled with CFR 0.152.
 */
package training.statistic;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.impl.DefaultKeymapImpl;
import com.intellij.util.TimeoutUtil;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import training.lang.LangManager;
import training.learn.CourseManager;
import training.learn.interfaces.Lesson;
import training.learn.interfaces.Module;
import training.learn.lesson.LessonManager;
import training.learn.lesson.kimpl.LessonExecutor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Ltraining/statistic/StatisticBase;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "Companion", "intellij.featuresTrainer"})
public final class StatisticBase
extends CounterUsagesCollector {
    private static final Logger LOG;
    private static final ConcurrentHashMap<String, Long> sessionLessonTimestamp;
    private static final EventLogGroup GROUP;
    private static final StringEventField lessonIdField;
    private static final StringEventField languageField;
    private static final IntEventField completedCountField;
    private static final IntEventField courseSizeField;
    private static final StringEventField moduleNameField;
    private static final StringEventField taskIdField;
    private static final StringEventField actionIdField;
    private static final StringEventField keymapSchemeField;
    private static final PrimitiveEventField<String> versionField;
    private static final StringEventField shortcutField;
    private static final EventId2<String, String> lessonStartedEvent;
    private static final EventId3<String, String, Long> lessonPassedEvent;
    private static final VarargEventId progressUpdatedEvent;
    private static final EventId2<String, String> moduleStartedEvent;
    private static final EventId1<String> welcomeScreenPanelExpandedEvent;
    private static final VarargEventId shortcutClickedEvent;
    private static final VarargEventId restorePerformedEvent;
    public static final Companion Companion;

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(StatisticBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        sessionLessonTimestamp = new ConcurrentHashMap();
        GROUP = new EventLogGroup("ideFeaturesTrainer", 6);
        lessonIdField = EventFields.StringValidatedByCustomRule((String)"lesson_id", (String)"lesson_id");
        languageField = EventFields.StringValidatedByCustomRule((String)"language", (String)"language");
        completedCountField = EventFields.Int((String)"completed_count");
        courseSizeField = EventFields.Int((String)"course_size");
        moduleNameField = EventFields.StringValidatedByCustomRule((String)"module_name", (String)"module_name");
        taskIdField = EventFields.StringValidatedByCustomRule((String)"task_id", (String)"task_id");
        actionIdField = EventFields.StringValidatedByCustomRule((String)"action_id", (String)"action_id");
        keymapSchemeField = EventFields.StringValidatedByCustomRule((String)"keymap_scheme", (String)"keymap_scheme");
        versionField = EventFields.Version;
        shortcutField = EventFields.StringValidatedByCustomRule((String)"shortcut", (String)"shortcut_or_none");
        lessonStartedEvent = GROUP.registerEvent("start", (EventField)lessonIdField, (EventField)languageField);
        lessonPassedEvent = GROUP.registerEvent("passed", (EventField)lessonIdField, (EventField)languageField, (EventField)EventFields.Long((String)"duration"));
        progressUpdatedEvent = GROUP.registerVarargEvent("progress", new EventField[]{(EventField)lessonIdField, (EventField)completedCountField, (EventField)courseSizeField, (EventField)languageField});
        moduleStartedEvent = GROUP.registerEvent("start_module_action", (EventField)moduleNameField, (EventField)languageField);
        welcomeScreenPanelExpandedEvent = GROUP.registerEvent("expand_welcome_screen", (EventField)languageField);
        shortcutClickedEvent = GROUP.registerVarargEvent("shortcut_clicked", new EventField[]{(EventField)shortcutField, (EventField)keymapSchemeField, (EventField)lessonIdField, (EventField)taskIdField, (EventField)actionIdField, (EventField)versionField});
        restorePerformedEvent = GROUP.registerVarargEvent("restore", new EventField[]{(EventField)lessonIdField, (EventField)taskIdField, (EventField)versionField});
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020\u0012H\u0002J\n\u0010'\u001a\u0004\u0018\u00010(H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010\u00122\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0012H\u0002J\u000e\u0010/\u001a\u0002002\u0006\u0010*\u001a\u00020+J\u000e\u00101\u001a\u0002002\u0006\u0010*\u001a\u00020+J\u000e\u00102\u001a\u0002002\u0006\u00103\u001a\u000204J\u0016\u00105\u001a\u0002002\u0006\u0010*\u001a\u00020+2\u0006\u00106\u001a\u00020%J\u0016\u00107\u001a\u0002002\u0006\u0010.\u001a\u00020\u00122\u0006\u00108\u001a\u00020\u0012J\u0006\u00109\u001a\u000200R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Ltraining/statistic/StatisticBase$Companion;", "", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "actionIdField", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "completedCountField", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "courseSizeField", "keymapSchemeField", "languageField", "lessonIdField", "lessonPassedEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "", "", "lessonStartedEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "moduleNameField", "moduleStartedEvent", "progressUpdatedEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "restorePerformedEvent", "sessionLessonTimestamp", "Ljava/util/concurrent/ConcurrentHashMap;", "shortcutClickedEvent", "shortcutField", "taskIdField", "versionField", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "welcomeScreenPanelExpandedEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "completedCount", "", "courseLanguage", "getDefaultKeymap", "Lcom/intellij/openapi/keymap/Keymap;", "getPluginVersion", "lesson", "Ltraining/learn/interfaces/Lesson;", "isSingleShortcut", "", "shortcut", "logLessonPassed", "", "logLessonStarted", "logModuleStarted", "module", "Ltraining/learn/interfaces/Module;", "logRestorePerformed", "taskId", "logShortcutClicked", "actionId", "logWelcomeScreenPanelExpanded", "intellij.featuresTrainer"})
    public static final class Companion {
        public final void logLessonStarted(@NotNull Lesson lesson) {
            Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
            ((Map)sessionLessonTimestamp).put(lesson.getId(), System.nanoTime());
            lessonStartedEvent.log((Object)lesson.getId(), (Object)this.courseLanguage());
        }

        public final void logLessonPassed(@NotNull Lesson lesson) {
            Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
            Long timestamp = (Long)sessionLessonTimestamp.get(lesson.getId());
            if (timestamp == null) {
                LOG.warn("Unable to find timestamp for a lesson: " + lesson.getName());
                return;
            }
            long delta = TimeoutUtil.getDurationMillis((long)timestamp);
            lessonPassedEvent.log((Object)lesson.getId(), (Object)this.courseLanguage(), (Object)delta);
            progressUpdatedEvent.log(new EventPair[]{lessonIdField.with((Object)lesson.getId()), completedCountField.with((Object)this.completedCount()), courseSizeField.with((Object)CourseManager.Companion.getInstance().getLessonsForModules().size()), languageField.with((Object)this.courseLanguage())});
        }

        public final void logModuleStarted(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            moduleStartedEvent.log((Object)module.getName(), (Object)this.courseLanguage());
        }

        public final void logWelcomeScreenPanelExpanded() {
            welcomeScreenPanelExpandedEvent.log((Object)this.courseLanguage());
        }

        public final void logShortcutClicked(@NotNull String shortcut, @NotNull String actionId) {
            Intrinsics.checkNotNullParameter((Object)shortcut, (String)"shortcut");
            Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
            LessonManager lessonManager = LessonManager.Companion.getInstance();
            if (lessonManager.lessonIsRunning$intellij_featuresTrainer()) {
                Lesson lesson = lessonManager.getCurrentLesson();
                Intrinsics.checkNotNull((Object)lesson);
                Lesson lesson2 = lesson;
                Keymap keymap = this.getDefaultKeymap();
                if (keymap == null) {
                    return;
                }
                Keymap keymap2 = keymap;
                String shortcutOrNone = this.isSingleShortcut(shortcut) ? shortcut : "none";
                EventPair[] eventPairArray = new EventPair[6];
                eventPairArray[0] = shortcutField.with((Object)shortcutOrNone);
                eventPairArray[1] = keymapSchemeField.with((Object)keymap2.getName());
                eventPairArray[2] = lessonIdField.with((Object)lesson2.getId());
                LessonExecutor lessonExecutor = lessonManager.getCurrentLessonExecutor$intellij_featuresTrainer();
                eventPairArray[3] = taskIdField.with((Object)String.valueOf(lessonExecutor != null ? Integer.valueOf(lessonExecutor.getCurrentTaskIndex$intellij_featuresTrainer()) : null));
                eventPairArray[4] = actionIdField.with((Object)actionId);
                eventPairArray[5] = versionField.with((Object)this.getPluginVersion(lesson2));
                shortcutClickedEvent.log(eventPairArray);
            }
        }

        public final void logRestorePerformed(@NotNull Lesson lesson, int taskId) {
            Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
            restorePerformedEvent.log(new EventPair[]{lessonIdField.with((Object)lesson.getId()), taskIdField.with((Object)String.valueOf(taskId)), versionField.with((Object)this.getPluginVersion(lesson))});
        }

        private final String courseLanguage() {
            Object object;
            block5: {
                block4: {
                    object = LangManager.Companion.getInstance().getLangSupport();
                    if (object == null || (object = object.getPrimaryLanguage()) == null) break block4;
                    Object object2 = object;
                    boolean bl = false;
                    Object object3 = object2;
                    if (object3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string = ((String)object3).toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toLowerCase()");
                    object = string;
                    if (string != null) break block5;
                }
                object = "";
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private final int completedCount() {
            int n;
            Iterable $this$count$iv = CourseManager.Companion.getInstance().getLessonsForModules();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                void var3_3;
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Lesson it = (Lesson)element$iv;
                    boolean bl = false;
                    if (!it.getPassed()) continue;
                    int n2 = ++count$iv;
                    boolean bl2 = false;
                    if (n2 >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = var3_3;
            }
            return n;
        }

        private final boolean isSingleShortcut(String shortcut) {
            return StringsKt.split$default((CharSequence)shortcut, (String[])new String[]{" \u2192 "}, (boolean)false, (int)0, (int)6, null).size() == 1;
        }

        private final String getPluginVersion(Lesson lesson) {
            PluginId pluginId = PluginManagerCore.getPluginByClassName((String)lesson.getClass().getName());
            IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)pluginId);
            return ideaPluginDescriptor != null ? ideaPluginDescriptor.getVersion() : null;
        }

        private final Keymap getDefaultKeymap() {
            KeymapManager keymapManager = KeymapManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)keymapManager, (String)"KeymapManager.getInstance()");
            Keymap keymap = keymapManager.getActiveKeymap();
            Intrinsics.checkNotNullExpressionValue((Object)keymap, (String)"KeymapManager.getInstance().activeKeymap");
            Keymap keymap2 = keymap;
            if (keymap2 instanceof DefaultKeymapImpl) {
                return keymap2;
            }
            Keymap keymap3 = keymap2.getParent();
            if (!(keymap3 instanceof DefaultKeymapImpl)) {
                keymap3 = null;
            }
            return (Keymap)((DefaultKeymapImpl)keymap3);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

