/*
 * Decompiled with CFR 0.152.
 */
package training.learn.lesson;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.util.DataLoader;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0011\u0010\u000e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Ltraining/learn/lesson/Scenario;", "", "path", "", "classLoader", "Ljava/lang/ClassLoader;", "(Ljava/lang/String;Ljava/lang/ClassLoader;)V", "file", "getFile", "()Ljava/lang/String;", "id", "getId", "lang", "getLang", "name", "getName", "root", "Lorg/jdom/Element;", "getRoot", "()Lorg/jdom/Element;", "Companion", "intellij.featuresTrainer"})
public final class Scenario {
    @NotNull
    private final Element root;
    private final String path;
    private static final String LANG = "lang";
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String FILE = "file";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Element getRoot() {
        return this.root;
    }

    @NotNull
    public final String getLang() {
        Attribute lang = this.root.getAttribute(LANG);
        if (lang != null) {
            String string = lang.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lang.value");
            return string;
        }
        throw (Throwable)new Exception("Cannot get 'lang' property for the lesson file with path: " + this.path);
    }

    @NotNull
    public final String getName() {
        Attribute attribute = this.root.getAttribute(NAME);
        Intrinsics.checkNotNull((Object)attribute);
        String string = attribute.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"root.getAttribute(NAME)!!.value");
        return string;
    }

    @NotNull
    public final String getId() {
        Attribute attribute = this.root.getAttribute(ID);
        Intrinsics.checkNotNull((Object)attribute);
        String string = attribute.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"root.getAttribute(ID)!!.value");
        return string;
    }

    @Nullable
    public final String getFile() {
        Attribute attribute = this.root.getAttribute(FILE);
        return attribute != null ? attribute.getValue() : null;
    }

    public Scenario(@NotNull String path, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        this.path = path;
        this.root = DataLoader.INSTANCE.getXmlRootElement(this.path, classLoader);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ltraining/learn/lesson/Scenario$Companion;", "", "()V", "FILE", "", "ID", "LANG", "NAME", "intellij.featuresTrainer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

