/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.lexer;

import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.lexer.CaptureMatchData;
import org.jetbrains.plugins.textmate.language.syntax.lexer.SyntaxMatchUtils;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateLexerState;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateWeigh;
import org.jetbrains.plugins.textmate.regex.MatchData;
import org.jetbrains.plugins.textmate.regex.RegexUtil;
import org.jetbrains.plugins.textmate.regex.StringWithId;
import org.jetbrains.plugins.textmate.regex.TextMateRange;

public class TextMateLexer {
    private static final int MAX_LOOPS_COUNT = 10;
    private ArrayList<TextMateLexerState> lastSuccessState;
    private int lastSuccessStateOccursCount;
    private int myCurrentOffset;
    private CharSequence myText;
    private final Deque<TextMateLexerState> myStates;
    private final Deque<CharSequence> openedTags;
    private final CharSequence myLanguageScopeName;
    private final int myLineLimit;
    private final Runnable myCheckCancelledCallback;
    private final TextMateLexerState myLanguageInitialState;

    public TextMateLexer(@NotNull TextMateLanguageDescriptor languageDescriptor, int lineLimit) {
        if (languageDescriptor == null) {
            TextMateLexer.$$$reportNull$$$0(0);
        }
        this.myCurrentOffset = 0;
        this.myText = "";
        this.myStates = new LinkedList<TextMateLexerState>();
        this.openedTags = new LinkedList<CharSequence>();
        this.myLanguageScopeName = languageDescriptor.getScopeName();
        this.myLanguageInitialState = TextMateLexerState.notMatched(languageDescriptor.getRootSyntaxNode());
        this.myLineLimit = lineLimit;
        this.myCheckCancelledCallback = SyntaxMatchUtils.getCheckCancelledCallback();
    }

    public void init(CharSequence text, int startOffset) {
        this.myText = text;
        this.myCurrentOffset = startOffset;
        this.myStates.clear();
        this.myStates.push(this.myLanguageInitialState);
        this.openedTags.clear();
        this.openedTags.offer(this.myLanguageScopeName);
        this.setLastSuccessState(null);
    }

    public int getCurrentOffset() {
        return this.myCurrentOffset;
    }

    public void advanceLine(@NotNull Queue<Token> output) {
        int endLineOffset;
        if (output == null) {
            TextMateLexer.$$$reportNull$$$0(1);
        }
        int startLineOffset = this.myCurrentOffset;
        for (endLineOffset = this.myCurrentOffset; endLineOffset < this.myText.length(); ++endLineOffset) {
            if (this.myText.charAt(endLineOffset) != '\n') continue;
            ++endLineOffset;
            break;
        }
        CharSequence lineCharSequence = this.myText.subSequence(startLineOffset, endLineOffset);
        if (this.myLineLimit >= 0 && lineCharSequence.length() > this.myLineLimit) {
            this.parseLine(lineCharSequence.subSequence(0, this.myLineLimit), output);
            this.addToken(output, endLineOffset);
        } else {
            this.parseLine(lineCharSequence, output);
        }
    }

    private void parseLine(@NotNull CharSequence lineCharSequence, @NotNull Queue<Token> output) {
        if (lineCharSequence == null) {
            TextMateLexer.$$$reportNull$$$0(2);
        }
        if (output == null) {
            TextMateLexer.$$$reportNull$$$0(3);
        }
        this.restoreValidStateBeforeNewLine();
        int startLineOffset = this.myCurrentOffset;
        int linePosition = 0;
        int lineByteOffset = 0;
        String line = lineCharSequence.length() > 0 && lineCharSequence.charAt(lineCharSequence.length() - 1) == '\n' ? lineCharSequence.toString() : lineCharSequence.toString() + "\n";
        StringWithId string = new StringWithId(line);
        while (true) {
            TextMateLexerState lexerState = this.myStates.element();
            if (lexerState.syntaxRule.getStringAttribute(Constants.StringKey.WHILE) == null || SyntaxMatchUtils.matchStringRegex(Constants.StringKey.WHILE, string, lineByteOffset, lexerState).matched()) break;
            this.closeScopeSelector(output, linePosition + startLineOffset);
            this.closeScopeSelector(output, linePosition + startLineOffset);
            this.myStates.pop();
        }
        TObjectIntHashMap localStates = new TObjectIntHashMap();
        while (true) {
            int currentStateLocalOccurrencesCount;
            int startPosition;
            int endPosition;
            TextMateLexerState lastState = this.myStates.element();
            SyntaxNodeDescriptor lastRule = lastState.syntaxRule;
            String currentScope = SyntaxMatchUtils.selectorsToScope(this.openedTags);
            TextMateLexerState currentState = SyntaxMatchUtils.matchFirst(lastRule, string, lineByteOffset, TextMateWeigh.Priority.NORMAL, currentScope);
            SyntaxNodeDescriptor currentRule = currentState.syntaxRule;
            MatchData currentMatch = currentState.matchData;
            MatchData endMatch = SyntaxMatchUtils.matchStringRegex(Constants.StringKey.END, string, lineByteOffset, lastState);
            if (endMatch.matched() && (!currentMatch.matched() || currentMatch.byteOffset().start >= endMatch.byteOffset().start || lastState.equals(currentState))) {
                this.myStates.pop();
                TextMateRange endRange = endMatch.charRange(line, string.bytes);
                startPosition = endPosition = endRange.start;
                this.closeScopeSelector(output, startPosition + startLineOffset);
                if (lastRule.getCaptures(Constants.CaptureKey.END_CAPTURES) == null && lastRule.getCaptures(Constants.CaptureKey.CAPTURES) == null && lastRule.getCaptures(Constants.CaptureKey.BEGIN_CAPTURES) == null || this.parseCaptures(output, Constants.CaptureKey.END_CAPTURES, lastRule, endMatch, string, line, startLineOffset) || this.parseCaptures(output, Constants.CaptureKey.CAPTURES, lastRule, endMatch, string, line, startLineOffset)) {
                    endPosition = endRange.end;
                }
                this.closeScopeSelector(output, endPosition + startLineOffset);
            } else {
                if (!currentMatch.matched()) {
                    this.addToken(output, line.length() + startLineOffset);
                    break;
                }
                TextMateRange currentRange = currentMatch.charRange(line, string.bytes);
                startPosition = currentRange.start;
                endPosition = currentRange.end;
                if (currentRule.getStringAttribute(Constants.StringKey.BEGIN) != null) {
                    this.openScopeSelector(output, currentRule.getStringAttribute(Constants.StringKey.NAME), startPosition + startLineOffset);
                    this.parseCaptures(output, Constants.CaptureKey.BEGIN_CAPTURES, currentRule, currentMatch, string, line, startLineOffset);
                    this.parseCaptures(output, Constants.CaptureKey.CAPTURES, currentRule, currentMatch, string, line, startLineOffset);
                    this.openScopeSelector(output, currentRule.getStringAttribute(Constants.StringKey.CONTENT_NAME), endPosition + startLineOffset);
                    this.myStates.push(currentState);
                } else if (currentRule.getStringAttribute(Constants.StringKey.MATCH) != null) {
                    this.openScopeSelector(output, currentRule.getStringAttribute(Constants.StringKey.NAME), startPosition + startLineOffset);
                    this.parseCaptures(output, Constants.CaptureKey.CAPTURES, currentRule, currentMatch, string, line, startLineOffset);
                    this.closeScopeSelector(output, endPosition + startLineOffset);
                }
            }
            ArrayList<TextMateLexerState> currentStateSnapshot = new ArrayList<TextMateLexerState>(this.myStates);
            if (this.lastSuccessState != null && currentStateSnapshot.equals(this.lastSuccessState)) {
                ++this.lastSuccessStateOccursCount;
                if (this.lastSuccessStateOccursCount > 10) {
                    this.addToken(output, line.length() + startLineOffset);
                    break;
                }
            }
            if ((currentStateLocalOccurrencesCount = localStates.get(currentStateSnapshot)) > 10) {
                this.addToken(output, line.length() + startLineOffset);
                break;
            }
            localStates.put(currentStateSnapshot, currentStateLocalOccurrencesCount + 1);
            if (linePosition != endPosition) {
                localStates.clear();
                linePosition = endPosition;
                lineByteOffset = RegexUtil.byteOffsetByCharOffset(line, linePosition);
            }
            if (this.myCheckCancelledCallback == null) continue;
            this.myCheckCancelledCallback.run();
        }
    }

    private void setLastSuccessState(@Nullable ArrayList<TextMateLexerState> state) {
        this.lastSuccessState = state;
        this.lastSuccessStateOccursCount = 0;
    }

    private boolean parseCaptures(@NotNull Queue<Token> output, Constants.CaptureKey capturesKey, SyntaxNodeDescriptor rule, MatchData matchData, StringWithId string, String line, int startLineOffset) {
        TIntObjectHashMap<CharSequence> captures;
        if (output == null) {
            TextMateLexer.$$$reportNull$$$0(4);
        }
        if ((captures = rule.getCaptures(capturesKey)) != null) {
            List<CaptureMatchData> matches = SyntaxMatchUtils.matchCaptures(captures, matchData, string, line);
            List nonEmptyMatches = matches.stream().filter(m -> m.selectorName.length() > 0 && !m.range.isEmpty()).collect(Collectors.toList());
            LinkedList starts = new LinkedList(nonEmptyMatches);
            Collections.sort(starts, CaptureMatchData.START_OFFSET_ORDERING);
            LinkedList ends = new LinkedList(nonEmptyMatches);
            Collections.sort(ends, CaptureMatchData.END_OFFSET_ORDERING);
            while (!starts.isEmpty() || !ends.isEmpty()) {
                CaptureMatchData start;
                CaptureMatchData end;
                if (starts.isEmpty()) {
                    end = (CaptureMatchData)ends.removeLast();
                    this.closeScopeSelector(output, end.range.end + startLineOffset);
                    continue;
                }
                if (ends.isEmpty()) {
                    start = (CaptureMatchData)starts.removeLast();
                    this.openScopeSelector(output, start.selectorName, start.range.start + startLineOffset);
                    continue;
                }
                if (((CaptureMatchData)ends.getLast()).group < ((CaptureMatchData)starts.getLast()).group) {
                    end = (CaptureMatchData)ends.removeLast();
                    this.closeScopeSelector(output, end.range.end + startLineOffset);
                    continue;
                }
                start = (CaptureMatchData)starts.removeLast();
                this.openScopeSelector(output, start.selectorName, start.range.start + startLineOffset);
            }
            return !matches.isEmpty();
        }
        return false;
    }

    private void openScopeSelector(@NotNull Queue<Token> output, @Nullable CharSequence name, int position) {
        if (output == null) {
            TextMateLexer.$$$reportNull$$$0(5);
        }
        this.addToken(output, position);
        this.openedTags.offer(name);
    }

    private void closeScopeSelector(@NotNull Queue<Token> output, int position) {
        CharSequence lastOpened;
        if (output == null) {
            TextMateLexer.$$$reportNull$$$0(6);
        }
        if (!this.openedTags.isEmpty() && (lastOpened = this.openedTags.peekLast()) != null && lastOpened.length() > 0) {
            this.addToken(output, position);
        }
        this.openedTags.pollLast();
    }

    private void addToken(@NotNull Queue<Token> output, int position) {
        if (output == null) {
            TextMateLexer.$$$reportNull$$$0(7);
        }
        if (position > this.myCurrentOffset) {
            boolean newState = this.openedTags.size() <= 1;
            output.offer(new Token(SyntaxMatchUtils.selectorsToScope(this.openedTags), this.myCurrentOffset, position, newState));
            this.myCurrentOffset = position;
            this.setLastSuccessState(new ArrayList<TextMateLexerState>(this.myStates));
        }
    }

    private void restoreValidStateBeforeNewLine() {
        if (this.openedTags.isEmpty()) {
            this.openedTags.offer(this.myLanguageScopeName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageDescriptor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineCharSequence";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/textmate/language/syntax/lexer/TextMateLexer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "advanceLine";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "parseLine";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "parseCaptures";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "openScopeSelector";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "closeScopeSelector";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addToken";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Token {
        public final String selector;
        public final int startOffset;
        public final int endOffset;
        public final boolean restartable;

        private Token(String selector, int startOffset, int endOffset, boolean restartable) {
            this.selector = selector;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.restartable = restartable;
        }
    }
}

