/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.DynamicBundle;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalProjectOptionsProvider;

public class TerminalSettingsPanel {
    private JPanel myWholePanel;
    private TextFieldWithBrowseButton myShellPathField;
    private JBCheckBox mySoundBellCheckBox;
    private JBCheckBox myCloseSessionCheckBox;
    private JBCheckBox myMouseReportCheckBox;
    private JTextField myTabNameTextField;
    private JBCheckBox myPasteOnMiddleButtonCheckBox;
    private JBCheckBox myCopyOnSelectionCheckBox;
    private JBCheckBox myOverrideIdeShortcuts;
    private JBCheckBox myShellIntegration;
    private TextFieldWithBrowseButton myStartDirectoryField;
    private JPanel myProjectSettingsPanel;
    private JPanel myGlobalSettingsPanel;
    private JPanel myConfigurablesPanel;
    private JBCheckBox myHighlightHyperlinks;
    private EnvironmentVariablesTextFieldWithBrowseButton myEnvVarField;
    private ActionLink myConfigureTerminalKeybindingsActionLink;
    private TerminalOptionsProvider myOptionsProvider;
    private TerminalProjectOptionsProvider myProjectOptionsProvider;
    private final List<UnnamedConfigurable> myConfigurables;

    public TerminalSettingsPanel() {
        this.$$$setupUI$$$();
        this.myConfigurables = new ArrayList<UnnamedConfigurable>();
    }

    /*
     * WARNING - void declaration
     */
    public JComponent createPanel(@NotNull TerminalOptionsProvider provider, @NotNull TerminalProjectOptionsProvider projectOptionsProvider) {
        void var6_9;
        if (provider == null) {
            TerminalSettingsPanel.$$$reportNull$$$0(0);
        }
        if (projectOptionsProvider == null) {
            TerminalSettingsPanel.$$$reportNull$$$0(1);
        }
        this.myOptionsProvider = provider;
        this.myProjectOptionsProvider = projectOptionsProvider;
        this.myProjectSettingsPanel.setBorder(IdeBorderFactory.createTitledBorder((String)TerminalBundle.message("settings.terminal.project.settings", new Object[0])));
        this.myGlobalSettingsPanel.setBorder(IdeBorderFactory.createTitledBorder((String)TerminalBundle.message("settings.terminal.application.settings", new Object[0])));
        this.configureShellPathField();
        this.configureStartDirectoryField();
        ArrayList<JComponent> customComponents = new ArrayList<JComponent>();
        LocalTerminalCustomizer[] localTerminalCustomizerArray = (LocalTerminalCustomizer[])LocalTerminalCustomizer.EP_NAME.getExtensions();
        int n = localTerminalCustomizerArray.length;
        boolean bl = false;
        while (var6_9 < n) {
            LocalTerminalCustomizer c = localTerminalCustomizerArray[var6_9];
            UnnamedConfigurable configurable = c.getConfigurable(projectOptionsProvider.getProject());
            if (configurable != null) {
                this.myConfigurables.add(configurable);
                JComponent component = configurable.createComponent();
                if (component != null) {
                    customComponents.add(component);
                }
            }
            ++var6_9;
        }
        if (!customComponents.isEmpty()) {
            this.myConfigurablesPanel.setLayout((LayoutManager)new GridLayoutManager(customComponents.size(), 1));
            int i = 0;
            for (Component component : customComponents) {
                this.myConfigurablesPanel.add(component, new GridConstraints(i++, 0, 1, 1, 8, 0, 0, 0, new Dimension(-1, -1), new Dimension(-1, -1), new Dimension(-1, -1), 0, false));
            }
        }
        return this.myWholePanel;
    }

    private void configureStartDirectoryField() {
        this.myStartDirectoryField.addBrowseFolderListener("", TerminalBundle.message("settings.start.directory.browseFolder.description", new Object[0]), null, FileChooserDescriptorFactory.createSingleFolderDescriptor(), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        this.setupTextFieldDefaultValue(this.myStartDirectoryField.getTextField(), () -> this.myProjectOptionsProvider.getDefaultStartingDirectory());
    }

    private void configureShellPathField() {
        this.myShellPathField.addBrowseFolderListener("", TerminalBundle.message("settings.terminal.shell.executable.path.browseFolder.description", new Object[0]), null, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor(), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        this.setupTextFieldDefaultValue(this.myShellPathField.getTextField(), () -> this.myProjectOptionsProvider.defaultShellPath());
    }

    private void setupTextFieldDefaultValue(final @NotNull JTextField textField, @NotNull Supplier<@NlsSafe String> defaultValueSupplier) {
        String defaultShellPath2;
        if (textField == null) {
            TerminalSettingsPanel.$$$reportNull$$$0(2);
        }
        if (defaultValueSupplier == null) {
            TerminalSettingsPanel.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmptyOrSpaces((String)(defaultShellPath2 = defaultValueSupplier.get()))) {
            return;
        }
        textField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                textField.setForeground(defaultShellPath2.equals(textField.getText()) ? TerminalSettingsPanel.this.getDefaultValueColor() : TerminalSettingsPanel.this.getChangedValueColor());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/terminal/TerminalSettingsPanel$1", "textChanged"));
            }
        });
        if (textField instanceof JBTextField) {
            ((JBTextField)textField).getEmptyText().setText(defaultShellPath2);
        }
    }

    public boolean isModified() {
        return !Objects.equals(this.myShellPathField.getText(), this.myProjectOptionsProvider.getShellPath()) || !Objects.equals(this.myStartDirectoryField.getText(), StringUtil.notNullize((String)this.myProjectOptionsProvider.getStartingDirectory())) || !Objects.equals(this.myTabNameTextField.getText(), this.myOptionsProvider.getTabName()) || this.myCloseSessionCheckBox.isSelected() != this.myOptionsProvider.closeSessionOnLogout() || this.myMouseReportCheckBox.isSelected() != this.myOptionsProvider.enableMouseReporting() || this.mySoundBellCheckBox.isSelected() != this.myOptionsProvider.audibleBell() || this.myCopyOnSelectionCheckBox.isSelected() != this.myOptionsProvider.copyOnSelection() || this.myPasteOnMiddleButtonCheckBox.isSelected() != this.myOptionsProvider.pasteOnMiddleMouseButton() || this.myOverrideIdeShortcuts.isSelected() != this.myOptionsProvider.overrideIdeShortcuts() || this.myShellIntegration.isSelected() != this.myOptionsProvider.shellIntegration() || this.myHighlightHyperlinks.isSelected() != this.myOptionsProvider.highlightHyperlinks() || this.myConfigurables.stream().anyMatch(c -> c.isModified()) || !Comparing.equal((Object)this.myEnvVarField.getData(), (Object)this.myProjectOptionsProvider.getEnvData());
    }

    public void apply() {
        this.myProjectOptionsProvider.setStartingDirectory(this.myStartDirectoryField.getText());
        this.myProjectOptionsProvider.setShellPath(this.myShellPathField.getText());
        this.myOptionsProvider.setTabName(this.myTabNameTextField.getText());
        this.myOptionsProvider.setCloseSessionOnLogout(this.myCloseSessionCheckBox.isSelected());
        this.myOptionsProvider.setReportMouse(this.myMouseReportCheckBox.isSelected());
        this.myOptionsProvider.setSoundBell(this.mySoundBellCheckBox.isSelected());
        this.myOptionsProvider.setCopyOnSelection(this.myCopyOnSelectionCheckBox.isSelected());
        this.myOptionsProvider.setPasteOnMiddleMouseButton(this.myPasteOnMiddleButtonCheckBox.isSelected());
        this.myOptionsProvider.setOverrideIdeShortcuts(this.myOverrideIdeShortcuts.isSelected());
        this.myOptionsProvider.setShellIntegration(this.myShellIntegration.isSelected());
        this.myOptionsProvider.setHighlightHyperlinks(this.myHighlightHyperlinks.isSelected());
        this.myConfigurables.forEach(c -> {
            try {
                c.apply();
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        });
        this.myProjectOptionsProvider.setEnvData(this.myEnvVarField.getData());
    }

    public void reset() {
        this.myShellPathField.setText(this.myProjectOptionsProvider.getShellPath());
        this.myStartDirectoryField.setText(this.myProjectOptionsProvider.getStartingDirectory());
        this.myTabNameTextField.setText(this.myOptionsProvider.getTabName());
        this.myCloseSessionCheckBox.setSelected(this.myOptionsProvider.closeSessionOnLogout());
        this.myMouseReportCheckBox.setSelected(this.myOptionsProvider.enableMouseReporting());
        this.mySoundBellCheckBox.setSelected(this.myOptionsProvider.audibleBell());
        this.myCopyOnSelectionCheckBox.setSelected(this.myOptionsProvider.copyOnSelection());
        this.myPasteOnMiddleButtonCheckBox.setSelected(this.myOptionsProvider.pasteOnMiddleMouseButton());
        this.myOverrideIdeShortcuts.setSelected(this.myOptionsProvider.overrideIdeShortcuts());
        this.myShellIntegration.setSelected(this.myOptionsProvider.shellIntegration());
        this.myHighlightHyperlinks.setSelected(this.myOptionsProvider.highlightHyperlinks());
        this.myConfigurables.forEach(c -> c.reset());
        this.myEnvVarField.setData(this.myProjectOptionsProvider.getEnvData());
    }

    public Color getDefaultValueColor() {
        return TerminalSettingsPanel.findColorByKey("TextField.inactiveForeground", "nimbusDisabledText");
    }

    private void createUIComponents() {
        this.myConfigureTerminalKeybindingsActionLink = new ActionLink(null, (AnAction)new DumbAwareAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Settings settings;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((settings = (Settings)e.getData(Settings.KEY)) != null) {
                    Configurable configurable = settings.find("preferences.keymap");
                    settings.select(configurable, "Terminal").doWhenDone(() -> EdtExecutorService.getScheduledExecutorInstance().schedule(() -> settings.select(configurable, "Terminal"), 100L, TimeUnit.MILLISECONDS));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/terminal/TerminalSettingsPanel$2", "actionPerformed"));
            }
        });
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this.myConfigureTerminalKeybindingsActionLink);
    }

    @NotNull
    private static Color findColorByKey(String ... colorKeys) {
        String key;
        Color c = null;
        String[] stringArray = colorKeys;
        int n = stringArray.length;
        for (int i = 0; i < n && (c = UIManager.getColor(key = stringArray[i])) == null; ++i) {
        }
        assert (c != null) : "Can't find color for keys " + Arrays.toString(colorKeys);
        Color color = c;
        if (color == null) {
            TerminalSettingsPanel.$$$reportNull$$$0(4);
        }
        return color;
    }

    public Color getChangedValueColor() {
        return TerminalSettingsPanel.findColorByKey("TextField.foreground");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectOptionsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValueSupplier";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/TerminalSettingsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/TerminalSettingsPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findColorByKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPanel";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupTextFieldDefaultValue";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JBCheckBox jBCheckBox4;
        JBCheckBox jBCheckBox5;
        JBCheckBox jBCheckBox6;
        JBCheckBox jBCheckBox7;
        JBCheckBox jBCheckBox8;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JTextField jTextField;
        JPanel jPanel2;
        EnvironmentVariablesTextFieldWithBrowseButton environmentVariablesTextFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.createUIComponents();
        this.myWholePanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(9, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(2, 0, 7, 4, 0, 2, 1, 6, null, null, null));
        this.myProjectSettingsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel3, new GridConstraints(0, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalTextPosition(2);
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.start.directory"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myStartDirectoryField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setHorizontalTextPosition(2);
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.environment.variables"));
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEnvVarField = environmentVariablesTextFieldWithBrowseButton = new EnvironmentVariablesTextFieldWithBrowseButton();
        environmentVariablesTextFieldWithBrowseButton.setText("");
        jPanel3.add((Component)environmentVariablesTextFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myGlobalSettingsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(10, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel2, new GridConstraints(1, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setHorizontalTextPosition(2);
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.tab.name"));
        jPanel6.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTabNameTextField = jTextField = new JTextField();
        jPanel6.add((Component)jTextField, new GridConstraints(1, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setHorizontalTextPosition(2);
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.shell.path"));
        jPanel6.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myShellPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel6.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySoundBellCheckBox = jBCheckBox8 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox8, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.audible.bell"));
        jPanel7.add((Component)jBCheckBox8, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel7.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel8, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCloseSessionCheckBox = jBCheckBox7 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox7, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.close.session.when.it.ends"));
        jPanel8.add((Component)jBCheckBox7, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel8.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel9, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myMouseReportCheckBox = jBCheckBox6 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox6, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.mouse.reporting"));
        jPanel9.add((Component)jBCheckBox6, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel9.add((Component)spacer4, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel10, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCopyOnSelectionCheckBox = jBCheckBox5 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox5, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.copy.to.clipboard.on.selection"));
        jPanel10.add((Component)jBCheckBox5, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel10.add((Component)spacer5, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel11, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPasteOnMiddleButtonCheckBox = jBCheckBox4 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.paste.on.middle.mouse.button.click"));
        jPanel11.add((Component)jBCheckBox4, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel11.add((Component)spacer6, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel12, new GridConstraints(6, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myOverrideIdeShortcuts = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.override.ide.shortcuts"));
        jPanel12.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel12.add((Component)spacer7, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        ActionLink actionLink = this.myConfigureTerminalKeybindingsActionLink;
        this.$$$loadLabelText$$$((JLabel)actionLink, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.configure.terminal.keybindings"));
        actionLink.setToolTipText(ResourceBundle.getBundle("messages/TerminalBundle").getString("settings.keymap.plugins.terminal"));
        jPanel12.add((Component)actionLink, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel13, new GridConstraints(7, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myShellIntegration = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.shell.integration"));
        jPanel13.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel13.add((Component)spacer8, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myConfigurablesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(9, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel14, new GridConstraints(8, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myHighlightHyperlinks = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.highlight.hyperlinks"));
        jPanel14.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer9 = new Spacer();
        jPanel14.add((Component)spacer9, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        jLabel.setLabelFor((Component)textFieldWithBrowseButton2);
        jLabel2.setLabelFor((Component)environmentVariablesTextFieldWithBrowseButton);
        jLabel3.setLabelFor(jTextField);
        jLabel4.setLabelFor((Component)textFieldWithBrowseButton);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

