/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.Gson;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.protocol.Bundle;
import org.netbeans.modules.java.lsp.server.protocol.CodeGenerator;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.QuickPickItem;
import org.netbeans.modules.java.lsp.server.protocol.ShowQuickPickParams;
import org.netbeans.modules.java.lsp.server.protocol.TextDocumentServiceImpl;
import org.openide.filesystems.FileObject;

public final class ConstructorGenerator
extends CodeGenerator {
    public static final String GENERATE_CONSTRUCTOR = "java.generate.constructor";
    private final Set<String> commands = Collections.singleton("java.generate.constructor");
    private final Gson gson = new Gson();

    @Override
    public List<CodeAction> getCodeActions(CompilationInfo info, CodeActionParams params) {
        List fields;
        List<Object> constructors;
        List only = params.getContext().getOnly();
        if (only == null || !only.contains("source")) {
            return Collections.emptyList();
        }
        int offset = ConstructorGenerator.getOffset(info, params.getRange().getStart());
        TreePath tp = info.getTreeUtilities().pathFor(offset);
        tp = info.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, tp);
        if (tp == null) {
            return Collections.emptyList();
        }
        TypeElement typeElement = (TypeElement)info.getTrees().getElement(tp);
        if (typeElement == null || !typeElement.getKind().isClass() || NestingKind.ANONYMOUS.equals((Object)typeElement.getNestingKind())) {
            return Collections.emptyList();
        }
        Set uninitializedFields = info.getTreeUtilities().getUninitializedFields(tp);
        ArrayList<ExecutableElement> inheritedConstructors = new ArrayList<ExecutableElement>();
        TypeMirror superClassType = typeElement.getSuperclass();
        if (superClassType.getKind() == TypeKind.DECLARED) {
            TypeElement superClass = (TypeElement)((DeclaredType)superClassType).asElement();
            Elements elements = info.getElements();
            for (ExecutableElement executableElement : ElementFilter.constructorsIn(superClass.getEnclosedElements())) {
                PackageElement currentPackage = elements.getPackageOf(typeElement);
                PackageElement ctorPackage = elements.getPackageOf(executableElement);
                Set<Modifier> ctorMods = executableElement.getModifiers();
                if (currentPackage != ctorPackage && !ctorMods.contains((Object)Modifier.PUBLIC) && !ctorMods.contains((Object)Modifier.PROTECTED) || ctorMods.contains((Object)Modifier.PRIVATE)) continue;
                inheritedConstructors.add(executableElement);
            }
        }
        if (typeElement.getKind() != ElementKind.ENUM && inheritedConstructors.size() == 1) {
            if (uninitializedFields.isEmpty() && ((ExecutableElement)inheritedConstructors.get(0)).getParameters().isEmpty() && ElementFilter.constructorsIn(typeElement.getEnclosedElements()).stream().filter(ctor -> ctor.getParameters().isEmpty() && !info.getElementUtilities().isSynthetic((Element)ctor)).count() > 0L) {
                constructors = Collections.emptyList();
            } else {
                QuickPickItem item = new QuickPickItem(ConstructorGenerator.createLabel(info, (ExecutableElement)inheritedConstructors.get(0)));
                item.setUserData(new CodeGenerator.ElementData((Element)inheritedConstructors.get(0)));
                constructors = Collections.singletonList(item);
            }
        } else if (inheritedConstructors.size() > 1) {
            constructors = new ArrayList(inheritedConstructors.size());
            for (ExecutableElement executableElement : inheritedConstructors) {
                QuickPickItem item = new QuickPickItem(ConstructorGenerator.createLabel(info, executableElement));
                item.setUserData(new CodeGenerator.ElementData(executableElement));
                constructors.add(item);
            }
        } else {
            constructors = Collections.emptyList();
        }
        if (uninitializedFields.isEmpty()) {
            fields = Collections.emptyList();
        } else {
            fields = new ArrayList();
            for (VariableElement variableElement : uninitializedFields) {
                QuickPickItem item = new QuickPickItem(ConstructorGenerator.createLabel(info, variableElement));
                item.setUserData(new CodeGenerator.ElementData(variableElement));
                fields.add(item);
            }
        }
        if (constructors.isEmpty() && fields.isEmpty()) {
            return Collections.emptyList();
        }
        String string = Utils.toUri(info.getFileObject());
        return Collections.singletonList(ConstructorGenerator.createCodeAction(Bundle.DN_GenerateConstructor(), "source.generate", GENERATE_CONSTRUCTOR, string, offset, constructors, fields));
    }

    @Override
    public Set<String> getCommands() {
        return this.commands;
    }

    @Override
    public CompletableFuture<Object> processCommand(NbCodeLanguageClient client, String command, List<Object> arguments) {
        if (arguments.size() > 3) {
            String uri = (String)this.gson.fromJson(this.gson.toJson(arguments.get(0)), String.class);
            int offset = (Integer)this.gson.fromJson(this.gson.toJson(arguments.get(1)), Integer.class);
            List<Object> constructors = Arrays.asList((Object[])this.gson.fromJson(this.gson.toJson(arguments.get(2)), QuickPickItem[].class));
            List<Object> fields = Arrays.asList((Object[])this.gson.fromJson(this.gson.toJson(arguments.get(3)), QuickPickItem[].class));
            if (constructors.size() < 2 && fields.isEmpty()) {
                this.generate(client, uri, offset, constructors, fields);
            } else if (constructors.size() > 1) {
                client.showQuickPick(new ShowQuickPickParams(Bundle.DN_SelectSuperConstructor(), true, constructors)).thenAccept(selected -> {
                    if (selected != null) {
                        this.selectFields(client, uri, offset, (List<QuickPickItem>)selected, (List<QuickPickItem>)fields);
                    }
                });
            } else {
                this.selectFields(client, uri, offset, constructors, fields);
            }
        } else {
            client.logMessage(new MessageParams(MessageType.Error, String.format("Illegal number of arguments received for command: %s", command)));
        }
        return CompletableFuture.completedFuture(true);
    }

    private void selectFields(NbCodeLanguageClient client, String uri, int offset, List<QuickPickItem> constructors, List<QuickPickItem> fields) {
        if (!fields.isEmpty()) {
            client.showQuickPick(new ShowQuickPickParams(Bundle.DN_SelectConstructorFields(), true, fields)).thenAccept(selected -> {
                if (selected != null) {
                    this.generate(client, uri, offset, constructors, (List<QuickPickItem>)selected);
                }
            });
        } else {
            this.generate(client, uri, offset, constructors, fields);
        }
    }

    private void generate(NbCodeLanguageClient client, String uri, int offset, List<QuickPickItem> constructors, List<QuickPickItem> fields) {
        try {
            FileObject file = Utils.fromUri(uri);
            JavaSource js = JavaSource.forFileObject((FileObject)file);
            if (js == null) {
                throw new IOException("Cannot get JavaSource for: " + uri);
            }
            List<TextEdit> edits = TextDocumentServiceImpl.modify2TextEdits(js, (Task<WorkingCopy>)((Task)wc -> {
                wc.toPhase(JavaSource.Phase.RESOLVED);
                TreePath tp = wc.getTreeUtilities().pathFor(offset);
                tp = wc.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, tp);
                if (tp != null) {
                    List selectedConstructors = constructors.stream().map(item -> {
                        CodeGenerator.ElementData data = (CodeGenerator.ElementData)this.gson.fromJson(this.gson.toJson(item.getUserData()), CodeGenerator.ElementData.class);
                        return (ExecutableElement)data.resolve((CompilationInfo)wc);
                    }).collect(Collectors.toList());
                    List selectedFields = fields.stream().map(item -> {
                        CodeGenerator.ElementData data = (CodeGenerator.ElementData)this.gson.fromJson(this.gson.toJson(item.getUserData()), CodeGenerator.ElementData.class);
                        return (VariableElement)data.resolve((CompilationInfo)wc);
                    }).collect(Collectors.toList());
                    GeneratorUtils.generateConstructors((WorkingCopy)wc, (TreePath)tp, selectedFields, selectedConstructors, (int)-1);
                }
            }));
            client.applyEdit(new ApplyWorkspaceEditParams(new WorkspaceEdit(Collections.singletonMap(uri, edits))));
        }
        catch (GeneratorUtils.DuplicateMemberException dme) {
            client.showMessage(new MessageParams(MessageType.Info, Bundle.DN_ConstructorAlreadyExists()));
        }
        catch (IOException | IllegalArgumentException ex) {
            client.logMessage(new MessageParams(MessageType.Error, ex.getLocalizedMessage()));
        }
    }
}

