/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.mx.project;

import java.awt.Toolkit;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.ListeningDICookie;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.base.ProcessBuilder;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.modules.java.mx.project.Bundle;
import org.netbeans.modules.java.mx.project.SuiteProject;
import org.netbeans.modules.java.mx.project.SuiteSources;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.LifecycleManager;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.Line;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

final class SuiteActionProvider
implements ActionProvider {
    private final SuiteProject prj;

    SuiteActionProvider(SuiteProject prj) {
        this.prj = prj;
    }

    public String[] getSupportedActions() {
        return new String[]{"clean", "build", "compile.single", "rebuild", "test.single", "run.single", "debug.test.single", "debug.single", "debug.single.method", "run.single.method"};
    }

    public void invokeAction(String action, Lookup context) throws IllegalArgumentException {
        FileObject fo = (FileObject)context.lookup(FileObject.class);
        String testSuffix = "";
        switch (action) {
            case "clean": {
                this.runMx(Bundle.MSG_Clean(this.prj.getName()), "clean");
                break;
            }
            case "build": {
                this.runMx(Bundle.MSG_Build(this.prj.getName()), "build");
                break;
            }
            case "rebuild": {
                this.runMx(Bundle.MSG_Rebuild(this.prj.getName()), "build");
                break;
            }
            case "compile.single": {
                SuiteSources.Group grp = this.prj.getSources().findGroup(fo);
                if (grp == null) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                String name = grp.getDisplayName();
                this.runMx(Bundle.MSG_BuildOnly(this.prj.getName(), name), "build", "--only", name);
                break;
            }
            case "run.single.method": {
                SingleMethod m = (SingleMethod)context.lookup(SingleMethod.class);
                if (m != null && fo == null) {
                    fo = m.getFile();
                    testSuffix = "#" + m.getMethodName();
                }
            }
            case "test.single": 
            case "run.single": {
                if (fo == null) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                this.runMx(Bundle.MSG_Unittest(fo.getName()), "unittest", fo.getName() + testSuffix);
                break;
            }
            case "debug.single.method": {
                SingleMethod m = (SingleMethod)context.lookup(SingleMethod.class);
                if (m != null && fo == null) {
                    fo = m.getFile();
                    testSuffix = "#" + m.getMethodName();
                }
            }
            case "debug.test.single": 
            case "debug.single": {
                if (fo == null) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                ListeningDICookie ldic = ListeningDICookie.create((int)-1);
                Object obj = ldic.getArgs().get("port");
                DebuggerInfo di = DebuggerInfo.create((String)"netbeans-jpda-ListeningDICookie", (Object[])new Object[]{ldic});
                DebuggerEngine[] engines = new DebuggerEngine[]{null};
                RequestProcessor.getDefault().post(() -> {
                    DebuggerEngine[] engs = DebuggerManager.getDebuggerManager().startDebugging(di);
                    engines[0] = engs[0];
                });
                int port = ldic.getPortNumber();
                this.runMx(Bundle.MSG_Unittest(fo.getName()), "--attach", "" + port, "unittest", fo.getName() + testSuffix);
                break;
            }
            default: {
                throw new UnsupportedOperationException(action);
            }
        }
    }

    private boolean runMx(String taskName, String ... args) {
        File suiteDir = FileUtil.toFile((FileObject)this.prj.getProjectDirectory());
        if (!suiteDir.isDirectory()) {
            Toolkit.getDefaultToolkit().beep();
            return true;
        }
        LifecycleManager.getDefault().saveAll();
        ExecutionDescriptor descriptor = new ExecutionDescriptor().frontWindow(true).controllable(true).errConvertorFactory(() -> line -> {
            File src;
            String[] segments = line.split(":");
            if (segments.length > 2 && (src = new File(segments[0])).exists()) {
                final int lineNumber = this.parseLineNumber(segments) - 1;
                return Collections.singletonList(ConvertedLine.forText((String)line, (OutputListener)new OutputListener(){

                    public void outputLineSelected(OutputEvent ev) {
                        this.openLine(Line.ShowOpenType.NONE, Line.ShowVisibilityType.FRONT);
                    }

                    public void outputLineAction(OutputEvent ev) {
                        this.openLine(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                    }

                    private boolean openLine(Line.ShowOpenType openType, Line.ShowVisibilityType visibilityType) throws IndexOutOfBoundsException {
                        FileObject fo = FileUtil.toFileObject((File)src);
                        if (fo != null) {
                            Openable open;
                            Lookup lkp = fo.getLookup();
                            LineCookie lines = (LineCookie)lkp.lookup(LineCookie.class);
                            if (lines != null && (open = lines.getLineSet().getOriginal(lineNumber)) != null) {
                                open.show(openType, visibilityType);
                                return true;
                            }
                            open = (Openable)lkp.lookup(Openable.class);
                            if (open != null) {
                                open.open();
                            } else {
                                Toolkit.getDefaultToolkit().beep();
                            }
                        }
                        return false;
                    }

                    public void outputLineCleared(OutputEvent ev) {
                    }
                }));
            }
            return null;
        });
        ProcessBuilder processBuilder = ProcessBuilder.getLocal();
        processBuilder.setWorkingDirectory(suiteDir.getPath());
        processBuilder.setExecutable("mx");
        processBuilder.setArguments(Arrays.asList(args));
        ExecutionService service = ExecutionService.newService((Callable)processBuilder, (ExecutionDescriptor)descriptor, (String)taskName);
        Future task = service.run();
        this.prj.registerTask(task);
        return false;
    }

    private int parseLineNumber(String[] segments) {
        int lineNumber;
        try {
            lineNumber = Integer.parseInt(segments[1]);
        }
        catch (NumberFormatException ex) {
            lineNumber = 1;
        }
        return lineNumber;
    }

    public boolean isActionEnabled(String action, Lookup context) throws IllegalArgumentException {
        FileObject fo = (FileObject)context.lookup(FileObject.class);
        switch (action) {
            case "debug.single.method": 
            case "run.single.method": {
                SingleMethod m = (SingleMethod)context.lookup(SingleMethod.class);
                if (fo == null && m != null) {
                    fo = m.getFile();
                }
            }
            case "compile.single": 
            case "test.single": 
            case "run.single": 
            case "debug.test.single": 
            case "debug.single": {
                return fo != null;
            }
        }
        return true;
    }
}

